/*
 *  @(#)DefaultIssueTypeInfo.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.defimpl;

import net.sourceforge.groboutils.pmti.v1.IIssueTypeInfo;
import net.sourceforge.groboutils.pmti.v1.IAttributeInfo;
import net.sourceforge.groboutils.pmti.v1.IIssueState;
 

/**
 * Information about the owning problem manager.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:58 $
 * @since      July 12, 2002
 */
public class DefaultIssueTypeInfo implements IIssueTypeInfo
{
    private String name;
    private IAttributeInfo[] attribs;
    private IIssueState[] allStates;
    private IIssueState[] passed;
    private IIssueState[] failed;
    
    
    public DefaultIssueTypeInfo( String n, IAttributeInfo[] at,
            IIssueState[] as, IIssueState[] ps, IIssueState[] fs )
    {
        if (n == null || at == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        
        this.name = n;
        this.allStates = copyStates( as );
        this.passed = copyStates( ps );
        this.failed = copyStates( fs );
        
        this.attribs = copyAttributeInfo( at );
    }
    
    
    /**
     * Returns the type name.
     */
    public String getName()
    {
        return this.name;
    }
    
    
    /**
     * Returns all states for the current issue type.
     */
    public IIssueState[] getPossibleStates()
    {
        return copyStates( this.allStates );
    }
    
    
    /**
     * Returns all attributes allowed for an issue of this type.
     */
    public IAttributeInfo[] getSupportedAttributes()
    {
        return copyAttributeInfo( this.attribs );
    }
    
    
    /**
     * Returns the state that refer to the associated tests passing.  Allows
     * for multiple states, for situations such as marked-as-fixed and
     * tests pass, or still-open but tests pass.
     */
    public IIssueState[] getTestPassedStates()
    {
        return copyStates( this.passed );
    }
    
    
    /**
     * Returns the state that refer to the associated tests failing.  Allows
     * for multiple states, for situations such as marked-as-fixed but
     * tests fail, or still-open but tests fail.
     */
    public IIssueState[] getTestFailedStates()
    {
        return copyStates( this.failed );
    }
    
    
    
    
    private IIssueState[] copyStates( IIssueState[] s )
    {
        IIssueState[] ret;
        if (s == null)
        {
            ret = new IIssueState[0];
        }
        else
        {
            ret = new IIssueState[ s.length ];
            System.arraycopy( s, 0, ret, 0, s.length );
        }
        return ret;
    }
    
    
    private IAttributeInfo[] copyAttributeInfo( IAttributeInfo[] a )
    {
        if (a == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        IAttributeInfo[] ret = new IAttributeInfo[ a.length ];
        System.arraycopy( a, 0, ret, 0, a.length );
        return ret;
    }
}

