/*
 * @(#)AutoDocITUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1;

//import net.sourceforge.groboutils.testing.junitlog.v1.*;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the AutoDocIT interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 27, 2002
 * @version   $Date: 2003/02/10 22:52:14 $
 */
public class AutoDocITUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AutoDocITUTestI.class;
//    private static final IJUnitDocumentor LOG = (new JUnitLog(THIS_CLASS)).getDocumentor();
    
    public AutoDocITUTestI( String name, ImplFactory f )
    {
        super( name, AutoDocIT.class, f );
    }

    
    public AutoDocIT createAutoDocIT()
    {
        return (AutoDocIT)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testTestsIssueSL1()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( null, 0L );
    }
    
    public void testTestsIssueSL2()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "", -1L );
    }
    
    public void testTestsIssueSL3()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "blah", 1000L );
    }
    
    public void testTestsIssueSL4()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "blah", Long.MIN_VALUE );
    }
    
    public void testTestsIssueSL5()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "blah", Long.MAX_VALUE );
    }
    
    
    public void testTestsIssueSS1()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( null, null );
    }
    
    public void testTestsIssueSS2()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "a", null );
    }
    
    public void testTestsIssueSS3()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( null, "a" );
    }
    
    public void testTestsIssueSS4()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "", "" );
    }
    
    public void testTestsIssueSS5()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "blah", "asdf" );
    }
    
    
    
    public void testTestsIssueL1()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( -1L );
    }
    
    public void testTestsIssueL2()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( 0L );
    }
    
    public void testTestsIssueL3()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( Long.MAX_VALUE );
    }
    
    public void testTestsIssueL4()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( Long.MIN_VALUE );
    }
    
    public void testTestsIssueL5()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( 10000L );
    }
    
    
    public void testTestsIssueS1()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( null );
    }
    
    public void testTestsIssueS2()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "" );
    }
    
    public void testTestsIssueS3()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( " " );
    }
    
    public void testTestsIssueS4()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "asdf" );
    }


    
    public void testMultiTests()
    {
        AutoDocIT it = createAutoDocIT();
        it.testsIssue( "asdf" );
        it.testsIssue( null );
        it.testsIssue( "blah", "asdf" );
        it.testsIssue( -1L );
        it.testsIssue( "blah", 1000L );
        it.testsIssue( "asdf" );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

