/*
 * libInstPatch
 * Copyright (C) 1999-2010 Joshua "Element" Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 2.1
 * of the License only.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA or on the web at http://www.gnu.org.
 */
/*
 * IpatchDLS2Param_tables.c - DLS2 effect parameter tables
 */
#include <glib.h>
#include "IpatchDLS2Region.h"
#include "IpatchUnit.h"
#include "IpatchUnit_DLS.h"
#include "ipatch_priv.h"
#include "i18n.h"

/* abs pitch constants: int ((1200 * (log2 (hz / 440.0)) + 6900.0) * 65536.0 + 0.5) */
#define ABSP_TENTH_HZ	-499642883L	/* 0.1 Hz */
#define ABSP_5HZ	-55791972L	/* 5 Hz */
#define ABSP_20HZ	101494427L	/* 20 Hz */
#define ABSP_5535CENTS	362741760L	/* 5535 cents */
#define ABSP_11921CENTS	781254656L	/* 11921 cents */

/* relative pitch constants: cents * 65536 */
#define RELP_N12800CENTS -838860800L	/* -12800 cents */
#define RELP_N1200CENTS	-78643200L	/* -1200 cents */
#define RELP_0CENTS	0		/* 0 cents */
#define RELP_100CENTS	6553600L	/* 100 cents */
#define RELP_1200CENTS	78643200L	/* 1200 cents */
#define RELP_6400CENTS	419430400L	/* 6400 cents */
#define RELP_12800CENTS	838860800L	/* 12800 cents */

/* abs time constants: int (1200.0 * (log2 (secs)) * 65536.0 + 0.5) */
#define ABST_0SECS	IPATCH_UNIT_DLS_ABS_TIME_0SECS	/* 0 secs degenerate case */
#define ABST_10MSECS	-522494110L	/* 10 msecs */
#define ABST_15MSECS	-476490787L	/* 15 msecs */
#define ABST_10SECS	261247056L	/* 10 secs */
#define ABST_40SECS	418533456L	/* 40 secs */

/* relative time cents constants: cents * 65536 */
#define RELT_0TCENTS	0		/* 0 time cents */
#define RELT_6000TCENTS	393216000L	/* 6000 time cents */

/* DLS gain constants: gain_db * 655360 */
#define GAIN_0DB	0		/* 0 dB */
#define GAIN_12DB	7864320L	/* 12 dB */
#define GAIN_22P5DB	14745600L	/* 22.5 dB */

/* DLS percent constants: percent * 655360 */
#define PERCENT_N50P8	-33292288L	/* -50.8% */
#define PERCENT_N50	-32768000L	/* -50% */
#define PERCENT_0	0		/* 0% */
#define PERCENT_50	32768000L	/* 50% */
#define PERCENT_50P8	33292288L	/* 50.8% */
#define PERCENT_100	65536000L	/* 100% */


/* Info for DLS2 parameters: min, max, default, unit_type, label */
const IpatchDLS2ParamInfo ipatch_dls2_param_info[] = {
  /* IPATCH_DLS2_PARAM_MOD_LFO_FREQ */
  { ABSP_TENTH_HZ, ABSP_20HZ, ABSP_5HZ, IPATCH_UNIT_TYPE_DLS_ABS_PITCH, N_("Mod LFO Freq") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_DELAY */
  { ABST_10MSECS, ABST_10SECS, ABST_10MSECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod LFO Delay") },
  /* IPATCH_DLS2_PARAM_VIB_LFO_FREQ */
  { ABSP_TENTH_HZ, ABSP_20HZ, ABSP_5HZ, IPATCH_UNIT_TYPE_DLS_ABS_PITCH, N_("Vib LFO Freq") },
  /* IPATCH_DLS2_PARAM_VIB_LFO_DELAY */
  { ABST_10MSECS, ABST_10SECS, ABST_10MSECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Vib LFO Delay") },
  /* IPATCH_DLS2_PARAM_VOL_EG_DELAY */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Vol Env Delay") },
  /* IPATCH_DLS2_PARAM_VOL_EG_ATTACK */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Vol Env Attack") },
  /* IPATCH_DLS2_PARAM_VOL_EG_HOLD */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Vol Env Hold") },
  /* IPATCH_DLS2_PARAM_VOL_EG_DECAY */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Vol Env Decay") },
  /* IPATCH_DLS2_PARAM_VOL_EG_SUSTAIN */
  { PERCENT_0, PERCENT_100, PERCENT_100, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("Vol Env Sustain") },
  /* IPATCH_DLS2_PARAM_VOL_EG_RELEASE */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Vol Env Release") },
  /* IPATCH_DLS2_PARAM_VOL_EG_SHUTDOWN */
  { ABST_0SECS, ABST_40SECS, ABST_15MSECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Vol Env Shutdown") },
  /* IPATCH_DLS2_PARAM_VOL_EG_VELOCITY_TO_ATTACK */
  { RELT_0TCENTS, RELT_6000TCENTS, RELT_0TCENTS, IPATCH_UNIT_TYPE_DLS_REL_TIME, N_("Vol Env Velocity to Attack") },
  /* IPATCH_DLS2_PARAM_VOL_EG_NOTE_TO_DECAY */
  { RELT_0TCENTS, RELT_6000TCENTS, RELT_0TCENTS, IPATCH_UNIT_TYPE_DLS_REL_TIME, N_("Vol Env Note to Decay") },
  /* IPATCH_DLS2_PARAM_VOL_EG_NOTE_TO_HOLD */
  { RELT_0TCENTS, RELT_6000TCENTS, RELT_0TCENTS, IPATCH_UNIT_TYPE_DLS_REL_TIME, N_("Vol Env Note to Hold") },
  /* IPATCH_DLS2_PARAM_MOD_EG_DELAY */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Delay") },
  /* IPATCH_DLS2_PARAM_MOD_EG_ATTACK */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Attack") },
  /* IPATCH_DLS2_PARAM_MOD_EG_HOLD */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Hold") },
  /* IPATCH_DLS2_PARAM_MOD_EG_DECAY */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Decay") },
  /* IPATCH_DLS2_PARAM_MOD_EG_SUSTAIN */
  { PERCENT_0, PERCENT_100, PERCENT_100, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("Mod Env Sustain") },
  /* IPATCH_DLS2_PARAM_MOD_EG_RELEASE */
  { ABST_0SECS, ABST_40SECS, ABST_0SECS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Release") },
  /* IPATCH_DLS2_PARAM_MOD_EG_VELOCITY_TO_ATTACK */
  { RELT_0TCENTS, RELT_6000TCENTS, RELT_0TCENTS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Velocity to Attack") },
  /* IPATCH_DLS2_PARAM_MOD_EG_NOTE_TO_DECAY */
  { RELT_0TCENTS, RELT_6000TCENTS, RELT_0TCENTS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Note to Decay") },
  /* IPATCH_DLS2_PARAM_MOD_EG_NOTE_TO_HOLD */
  { RELT_0TCENTS, RELT_6000TCENTS, RELT_0TCENTS, IPATCH_UNIT_TYPE_DLS_ABS_TIME, N_("Mod Env Note to Hold") },
  /* IPATCH_DLS2_PARAM_SCALE_TUNE */
  { RELP_0CENTS, RELP_12800CENTS, RELP_12800CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Scale Tuning") },
  /* IPATCH_DLS2_PARAM_RPN2_TO_NOTE */
  { RELP_0CENTS, RELP_6400CENTS, RELP_6400CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("RPN2 to note") },
  /* IPATCH_DLS2_PARAM_FILTER_CUTOFF */
  { ABSP_5535CENTS, ABSP_11921CENTS, 0x7FFFFFFF, IPATCH_UNIT_TYPE_DLS_ABS_PITCH, N_("Filter Cutoff") },
  /* IPATCH_DLS2_PARAM_FILTER_Q */
  { GAIN_0DB, GAIN_22P5DB, GAIN_0DB, IPATCH_UNIT_TYPE_DLS_GAIN, N_("Filter Q") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_TO_FILTER_CUTOFF */
  { RELP_N12800CENTS, RELP_12800CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod LFO to Cutoff") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_CC1_TO_FILTER_CUTOFF */
  { RELP_N12800CENTS, RELP_12800CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod LFO CC1 to Cutoff") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_CHANNEL_PRESS_TO_FILTER_CUTOFF */
  { RELP_N12800CENTS, RELP_12800CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod LFO Channel Press. to Cutoff") },
  /* IPATCH_DLS2_PARAM_MOD_EG_TO_FILTER_CUTOFF */
  { RELP_N12800CENTS, RELP_12800CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod Env to Cutoff") },
  /* IPATCH_DLS2_PARAM_VELOCITY_TO_FILTER_CUTOFF */
  { RELP_N12800CENTS, RELP_12800CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Velocity to Cutoff") },
  /* IPATCH_DLS2_PARAM_NOTE_TO_FILTER_CUTOFF */
  { RELP_N12800CENTS, RELP_12800CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Note number to Cutoff") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_TO_GAIN */
  { GAIN_0DB, GAIN_12DB, GAIN_0DB, IPATCH_UNIT_TYPE_DLS_GAIN, N_("Mod LFO to Gain") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_CC1_TO_GAIN */
  { GAIN_0DB, GAIN_12DB, GAIN_0DB, IPATCH_UNIT_TYPE_DLS_GAIN, N_("Mod LFO CC1 to Gain") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_CHANNEL_PRESS_TO_GAIN */
  { GAIN_0DB, GAIN_12DB, GAIN_0DB, IPATCH_UNIT_TYPE_DLS_GAIN, N_("Mod LFO Channel Press. to Gain") },
  /* IPATCH_DLS2_PARAM_VELOCITY_TO_GAIN */
  { GAIN_0DB, GAIN_12DB, GAIN_0DB, IPATCH_UNIT_TYPE_DLS_GAIN, N_("Velocity to Gain") },
  /* IPATCH_DLS2_PARAM_CC7_TO_GAIN */
  { GAIN_0DB, GAIN_12DB, GAIN_0DB, IPATCH_UNIT_TYPE_DLS_GAIN, N_("CC7 to Gain") },
  /* IPATCH_DLS2_PARAM_CC11_TO_GAIN */
  { GAIN_0DB, GAIN_12DB, GAIN_0DB, IPATCH_UNIT_TYPE_DLS_GAIN, N_("CC11 to Gain") },
  /* IPATCH_DLS2_PARAM_TUNE */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Tune") },
  /* IPATCH_DLS2_PARAM_PITCH_WHEEL_RPN0_TO_PITCH */
  { RELP_12800CENTS, RELP_12800CENTS, RELP_12800CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Pitch Wheel RPN0 to Pitch") },
  /* IPATCH_DLS2_PARAM_NOTE_TO_PITCH */
  { RELP_0CENTS, RELP_12800CENTS, RELP_12800CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Note to Pitch") },
  /* IPATCH_DLS2_PARAM_RPN1_TO_PITCH */
  { RELP_0CENTS, RELP_100CENTS, RELP_100CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("RPN1 to Pitch") },
  /* IPATCH_DLS2_PARAM_VIB_LFO_TO_PITCH */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Vib LFO to Pitch") },
  /* IPATCH_DLS2_PARAM_VIB_LFO_CC1_TO_PITCH */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Vib LFO CC1 to Pitch") },
  /* IPATCH_DLS2_PARAM_VIB_LFO_CHANNEL_PRESS_TO_PITCH */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Vib LFO Channel Press. to Pitch") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_TO_PITCH */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod LFO to Pitch") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_CC1_TO_PITCH */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod LFO CC1 to Pitch") },
  /* IPATCH_DLS2_PARAM_MOD_LFO_CHANNEL_PRESS_TO_PITCH */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod LFO Channel Press. to Pitch") },
  /* IPATCH_DLS2_PARAM_MOD_EG_TO_PITCH */
  { RELP_N1200CENTS, RELP_1200CENTS, RELP_0CENTS, IPATCH_UNIT_TYPE_DLS_REL_PITCH, N_("Mod Envelope to Pitch") },
  /* IPATCH_DLS2_PARAM_PAN */
  { PERCENT_N50, PERCENT_50, PERCENT_0, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("Pan") },
  /* IPATCH_DLS2_PARAM_CC10_TO_PAN */
  { PERCENT_N50P8, PERCENT_50P8, PERCENT_50P8, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("CC10 to Pan") },
  /* IPATCH_DLS2_PARAM_CC91_TO_REVERB_SEND */
  { PERCENT_0, PERCENT_100, PERCENT_100, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("CC91 to Reverb") },
  /* IPATCH_DLS2_PARAM_REVERB_SEND */
  { PERCENT_0, PERCENT_100, PERCENT_0, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("Reverb") },
  /* IPATCH_DLS2_PARAM_CC93_TO_CHORUS_SEND */
  { PERCENT_0, PERCENT_100, PERCENT_100, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("CC93 to Chorus") },
  /* IPATCH_DLS2_PARAM_CHORUS_SEND */
  { PERCENT_0, PERCENT_100, PERCENT_0, IPATCH_UNIT_TYPE_DLS_PERCENT, N_("Chorus") },
};
