Summary:          Thread pool based event framework wrapper
Name:             nunc-stans
Version:          0.1.8
Release:          1%{?dist}
License:          GPLv3+
URL:              http://fedorahosted.org/nunc-stans
Group:            Development/Libraries
BuildRoot:        %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:    nspr-devel
BuildRequires:    libtevent-devel
BuildRequires:    libtalloc-devel
BuildRequires:    libevent-devel

Source0:          https://git.fedorahosted.org/cgit/nunc-stans.git/snapshot/%{name}-%{version}.tar.xz
#Source0:          http://fedorahosted.org/sources/%{name}-%{version}.tar.xz

%description
%{name} is an event framework wrapper that provides a thread pool for event
callback execution.  It provides thread safety to event frameworks by isolating
and protecting the thread safe parts from the non-thread safe parts, and allows
multi-threaded applications to use event frameworks that are not thread safe.
It has been primarily developed using [libevent](http://libevent.org "libevent
home page") , but has also been tested with [tevent](https://tevent.samba.org
"tevent home page").   %{name} uses lock free data structures where possible,
to avoid mutex contention. The ​[liblfds](http://liblfds.org "Lock Free Data Structure")
library is used. 

%package devel
Summary:  Development and header files for %{name}
Group:    Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig
Requires: nspr-devel

%description devel
Development files and header files necessary to build applications
that use %{name}.

%prep
%setup -q

%build

%configure
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf $RPM_BUILD_ROOT

%{__make} install DESTDIR=$RPM_BUILD_ROOT INSTALL="%{__install} -p"
%{__rm} -f $RPM_BUILD_ROOT%{_libdir}/lib*.a
%{__rm} -f $RPM_BUILD_ROOT%{_libdir}/lib*.la

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING COPYING.openssl COPYING.liblfds LICENSE.md
%{_libdir}/*.so.*

%files devel
%defattr(-,root,root,-)
%{_libdir}/pkgconfig/%{name}.pc
%{_libdir}/*.so
%{_includedir}/nunc-stans
%{_pkgdocdir}
%{_mandir}

%changelog
* Mon May  4 2015 Rich Megginson <rmeggins@redhat.com> - 0.1.1-1
- Initial commit
