.\"
.\" Copyright 1996 Hewlett-Packard Company
.\" Copyright 1996 International Business Machines Corp.
.\" Copyright 1996, 1999, 2004, Oracle and/or its affiliates. All rights reserved.
.\" Copyright 1996 Novell, Inc.
.\" Copyright 1996 Digital Equipment Corp.
.\" Copyright 1996 Fujitsu Limited
.\" Copyright 1996 Hitachi, Ltd.
.\" Copyright 1996 X Consortium, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute,
.\" sublicense, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, subject to the following
.\" conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the names of the copyright holders
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" from said copyright holders.
.\"
.TH XpDestroyContext 3Xp __xorgversion__ "XPRINT FUNCTIONS"
.SH NAME
XpDestroyContext \- Gets the current print context-id for a display connection.
.SH SYNOPSIS
.br
      cc [ flag... ] file... -lXp [ library... ]
.br
      #include <X11/extensions/Print.h>
.LP
.B void XpDestroyContext
(
.I display,
.I print_context
)
.br
      Display *\fIdisplay\fP\^;
.br
      XPContext \fIprint_context\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
Specifies a pointer to the Display structure; returned from XOpenDisplay.
.TP
.I print_context
Specifies the print context to destroy.
.SH DESCRIPTION
.LP
XpDestroyContext closes any outstanding associations between the print context
and
any display connections, and then destroys the print context. All display
connections using the print context will no longer be able to access the print
context.

Destroying a print context will cause any in-progress pages, documents and jobs
to
be canceled within the
.I X Print Server.
.SH DIAGNOSTICS
.TP 15
.SM XPBadContext
A valid print context-id has not been set prior to making this call.
