/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ParseException;

class ExprTokenizer {
    static final int TOK_EOF = 0;
    static final int TOK_QNAME = 1;
    static final int TOK_STAR = 2;
    static final int TOK_NAME_COLON_STAR = 3;
    static final int TOK_AT = 4;
    static final int TOK_DOT = 5;
    static final int TOK_DOT_DOT = 6;
    static final int TOK_COMMENT_LPAR = 7;
    static final int TOK_PROCESSING_INSTRUCTION_LPAR = 8;
    static final int TOK_TEXT_LPAR = 9;
    static final int TOK_NODE_LPAR = 10;
    static final int TOK_MULTIPLY = 11;
    static final int TOK_LPAR = 12;
    static final int TOK_RPAR = 13;
    static final int TOK_LSQB = 14;
    static final int TOK_RSQB = 15;
    static final int TOK_LITERAL = 16;
    static final int TOK_NUMBER = 17;
    static final int TOK_AXIS = 18;
    static final int TOK_FUNCTION_LPAR = 19;
    static final int TOK_CNAME_LPAR = 20;
    static final int TOK_VARIABLE_REF = 21;
    static final int TOK_SLASH = 22;
    static final int TOK_SLASH_SLASH = 23;
    static final int TOK_VBAR = 24;
    static final int TOK_COMMA = 25;
    static final int TOK_PLUS = 26;
    static final int TOK_MINUS = 27;
    static final int TOK_EQUALS = 28;
    static final int TOK_NOT_EQUALS = 29;
    static final int TOK_GT = 30;
    static final int TOK_LT = 31;
    static final int TOK_GTE = 32;
    static final int TOK_LTE = 33;
    static final int TOK_AND = 34;
    static final int TOK_OR = 35;
    static final int TOK_MOD = 36;
    static final int TOK_DIV = 37;
    int currentToken = 0;
    String currentTokenValue = null;
    private int currentTokenStartIndex = 0;
    private final String expr;
    private int exprIndex = 0;
    private int exprLength;
    private boolean recognizeOperator = false;
    private static final String nameStartChars = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String nameChars = ".-0123456789";
    private static final String digits = "0123456789";

    ExprTokenizer(String s) {
        this.expr = s;
        this.exprLength = s.length();
    }

    void next() throws ParseException {
        this.currentTokenValue = null;
        this.currentTokenStartIndex = this.exprIndex;
        boolean currentMaybeOperator = this.recognizeOperator;
        this.recognizeOperator = true;
        block22: while (true) {
            if (this.exprIndex >= this.exprLength) {
                this.currentToken = 0;
                return;
            }
            char c = this.expr.charAt(this.exprIndex++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.currentTokenStartIndex = this.exprIndex;
                    continue block22;
                }
                case '<': {
                    this.recognizeOperator = false;
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '=') {
                        ++this.exprIndex;
                        this.currentToken = 33;
                    } else {
                        this.currentToken = 31;
                    }
                    return;
                }
                case '>': {
                    this.recognizeOperator = false;
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '=') {
                        ++this.exprIndex;
                        this.currentToken = 32;
                    } else {
                        this.currentToken = 30;
                    }
                    return;
                }
                case '/': {
                    this.recognizeOperator = false;
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '/') {
                        ++this.exprIndex;
                        this.currentToken = 23;
                    } else {
                        this.currentToken = 22;
                    }
                    return;
                }
                case '=': {
                    this.recognizeOperator = false;
                    this.currentToken = 28;
                    return;
                }
                case '!': {
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '=') {
                        ++this.exprIndex;
                        this.currentToken = 29;
                        this.recognizeOperator = false;
                        return;
                    }
                    throw new ParseException("illegal character");
                }
                case ',': {
                    this.recognizeOperator = false;
                    this.currentToken = 25;
                    return;
                }
                case '|': {
                    this.recognizeOperator = false;
                    this.currentToken = 24;
                    return;
                }
                case '+': {
                    this.recognizeOperator = false;
                    this.currentToken = 26;
                    return;
                }
                case '-': {
                    this.recognizeOperator = false;
                    this.currentToken = 27;
                    return;
                }
                case '(': {
                    this.currentToken = 12;
                    this.recognizeOperator = false;
                    return;
                }
                case ')': {
                    this.currentToken = 13;
                    return;
                }
                case '[': {
                    this.currentToken = 14;
                    this.recognizeOperator = false;
                    return;
                }
                case ']': {
                    this.currentToken = 15;
                    return;
                }
                case '\"': 
                case '\'': {
                    this.exprIndex = this.expr.indexOf(c, this.exprIndex);
                    if (this.exprIndex < 0) {
                        this.exprIndex = this.currentTokenStartIndex + 1;
                        throw new ParseException("missing quote");
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex + 1, this.exprIndex++);
                    this.currentToken = 16;
                    return;
                }
                case '$': {
                    this.scanName();
                    if (this.exprIndex == this.currentTokenStartIndex + 1) {
                        throw new ParseException("illegal character");
                    }
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == ':') {
                        ++this.exprIndex;
                        this.scanName();
                        if (this.expr.charAt(this.exprIndex - 1) == ':') {
                            throw new ParseException("bad character after :");
                        }
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex + 1, this.exprIndex);
                    this.currentToken = 21;
                    return;
                }
                case '*': {
                    if (currentMaybeOperator) {
                        this.recognizeOperator = false;
                        this.currentToken = 11;
                    } else {
                        this.currentToken = 2;
                    }
                    return;
                }
                case '@': {
                    this.currentToken = 4;
                    this.recognizeOperator = false;
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanDigits();
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '.') {
                        ++this.exprIndex;
                        if (this.exprIndex < this.exprLength && ExprTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
                            ++this.exprIndex;
                            this.scanDigits();
                        }
                    }
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                    this.currentToken = 17;
                    return;
                }
                case '.': {
                    if (this.exprIndex < this.exprLength && ExprTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
                        ++this.exprIndex;
                        this.scanDigits();
                        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                        this.currentToken = 17;
                        return;
                    }
                    if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '.') {
                        ++this.exprIndex;
                        this.currentToken = 6;
                    } else {
                        this.currentToken = 5;
                    }
                    this.recognizeOperator = false;
                    return;
                }
            }
            break;
        }
        --this.exprIndex;
        this.scanName();
        if (this.exprIndex == this.currentTokenStartIndex) {
            throw new ParseException("illegal character");
        }
        if (this.isAxis()) {
            this.recognizeOperator = false;
            this.currentToken = 18;
            return;
        }
        if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == ':') {
            ++this.exprIndex;
            if (this.exprIndex < this.exprLength && this.expr.charAt(this.exprIndex) == '*') {
                this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex++ - 1);
                this.currentToken = 3;
                return;
            }
            this.scanName();
            if (this.expr.charAt(this.exprIndex - 1) == ':') {
                throw new ParseException("bad character after :");
            }
            this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
            if (this.followingParen()) {
                this.recognizeOperator = false;
                this.currentToken = 20;
            } else {
                this.currentToken = 1;
            }
            return;
        }
        this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
        if (currentMaybeOperator) {
            if (this.currentTokenValue.equals("and")) {
                this.currentToken = 34;
            } else if (this.currentTokenValue.equals("or")) {
                this.currentToken = 35;
            } else if (this.currentTokenValue.equals("mod")) {
                this.currentToken = 36;
            } else if (this.currentTokenValue.equals("div")) {
                this.currentToken = 37;
            } else {
                throw new ParseException("unrecognized operator name");
            }
            this.recognizeOperator = false;
            return;
        }
        if (this.followingParen()) {
            this.currentToken = this.currentTokenValue.equals("processing-instruction") ? 8 : (this.currentTokenValue.equals("comment") ? 7 : (this.currentTokenValue.equals("node") ? 10 : (this.currentTokenValue.equals("text") ? 9 : 19)));
            this.recognizeOperator = false;
        } else {
            this.currentToken = 1;
        }
    }

    private void scanName() {
        if (this.exprIndex < this.exprLength && ExprTokenizer.isNameStartChar(this.expr.charAt(this.exprIndex))) {
            while (++this.exprIndex < this.exprLength && ExprTokenizer.isNameChar(this.expr.charAt(this.exprIndex))) {
            }
        }
    }

    private void scanDigits() {
        while (this.exprIndex < this.exprLength && ExprTokenizer.isDigit(this.expr.charAt(this.exprIndex))) {
            ++this.exprIndex;
        }
    }

    private boolean followingParen() {
        block4: for (int i = this.exprIndex; i < this.exprLength; ++i) {
            switch (this.expr.charAt(i)) {
                case '(': {
                    this.exprIndex = i + 1;
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isAxis() {
        block4: for (int i = this.exprIndex; i < this.exprLength; ++i) {
            switch (this.expr.charAt(i)) {
                case ':': {
                    if (i + 1 >= this.exprLength || this.expr.charAt(i + 1) != ':') continue block4;
                    this.currentTokenValue = this.expr.substring(this.currentTokenStartIndex, this.exprIndex);
                    this.exprIndex = i + 2;
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private static final boolean isDigit(char c) {
        return digits.indexOf(c) >= 0;
    }

    private static final boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static final boolean isNameStartChar(char c) {
        return nameStartChars.indexOf(c) >= 0 || c >= '\u0080';
    }

    private static final boolean isNameChar(char c) {
        return nameStartChars.indexOf(c) >= 0 || nameChars.indexOf(c) >= 0 || c >= '\u0080';
    }
}

