/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax2.OutputContentHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class NXMLOutputHandler
implements OutputContentHandler {
    private Writer writer;
    private boolean keepOpen;
    private final char[] chBuf = new char[1];
    private final String lineSeparator = System.getProperty("line.separator");
    private String[] escapes = new String[128];
    private final EscapeCharacterHandler escapeCharacterHandler = new EscapeCharacterHandler();
    private final CharacterHandler ignoreCharacterHandler = new CharacterHandler();
    private final CharacterHandler dataCharacterHandler = new DataCharacterHandler();
    private CharacterHandler controlCharacterHandler;
    private CharacterHandler characterHandler;
    private int depth = 0;
    private CharacterHandler[] characterHandlers = new CharacterHandler[1];

    public NXMLOutputHandler() {
        this.characterHandler = this.ignoreCharacterHandler;
        if (!this.lineSeparator.equals("\n")) {
            this.escapes[10] = this.lineSeparator;
            this.controlCharacterHandler = new LineControlCharacterHandler();
        } else {
            this.controlCharacterHandler = new ControlCharacterHandler();
        }
    }

    public ContentHandler init(Destination dest, Properties props) throws IOException {
        String mediaType = props.getProperty("media-type");
        if (mediaType == null) {
            mediaType = "text/plain";
        }
        this.writer = new BufferedWriter(dest.getWriter(mediaType, props.getProperty("encoding")));
        this.keepOpen = dest.keepOpen();
        return this;
    }

    public void startDocument() {
    }

    public void characters(char[] ch, int off, int len) throws SAXException {
        try {
            this.characterHandler.characters(ch, off, len);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int off, int len) throws SAXException {
        this.characters(ch, off, len);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String num;
        if (qName.equals("control")) {
            this.push(this.controlCharacterHandler);
        } else if (qName.equals("data")) {
            this.push(this.dataCharacterHandler);
        } else if (qName.equals("escape")) {
            this.escapeCharacterHandler.setChar(atts.getValue("char"));
            this.push(this.escapeCharacterHandler);
        } else if (qName.equals("char") && (num = atts.getValue("number")) != null) {
            try {
                int c = Integer.parseInt(num);
                if (c >= 0 && c < 65536) {
                    this.chBuf[0] = (char)c;
                    this.characters(this.chBuf, 0, 1);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("control") || qName.equals("data")) {
            this.pop();
        } else if (qName.equals("escape")) {
            this.escapeCharacterHandler.endChar();
            this.pop();
        }
    }

    public void pop() {
        this.characterHandler = this.characterHandlers[--this.depth];
    }

    public void push(CharacterHandler handler) {
        if (this.depth >= this.characterHandlers.length) {
            CharacterHandler[] oldHandlers = this.characterHandlers;
            this.characterHandlers = new CharacterHandler[oldHandlers.length * 2];
            System.arraycopy(oldHandlers, 0, this.characterHandlers, 0, oldHandlers.length);
        }
        this.characterHandlers[this.depth++] = this.characterHandler;
        this.characterHandler = handler;
    }

    public void processingInstruction(String target, String data) {
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                if (this.keepOpen) {
                    this.writer.flush();
                } else {
                    this.writer.close();
                }
                this.writer = null;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String entityName) {
    }

    public void setDocumentLocator(Locator loc) {
    }

    static /* synthetic */ String[] access$102(NXMLOutputHandler x0, String[] x1) {
        x0.escapes = x1;
        return x1;
    }

    class LineControlCharacterHandler
    extends CharacterHandler {
        LineControlCharacterHandler() {
        }

        void characters(char[] ch, int off, int len) throws IOException {
            int start = off;
            while (len > 0) {
                if (ch[off] == '\n') {
                    if (start != off) {
                        NXMLOutputHandler.this.writer.write(ch, start, off - start);
                    }
                    NXMLOutputHandler.this.writer.write(NXMLOutputHandler.this.lineSeparator);
                    start = off + 1;
                }
                ++off;
                --len;
            }
            if (start != off) {
                NXMLOutputHandler.this.writer.write(ch, start, off - start);
            }
        }
    }

    class ControlCharacterHandler
    extends CharacterHandler {
        ControlCharacterHandler() {
        }

        void characters(char[] ch, int off, int len) throws IOException {
            NXMLOutputHandler.this.writer.write(ch, off, len);
        }
    }

    class DataCharacterHandler
    extends CharacterHandler {
        DataCharacterHandler() {
        }

        void characters(char[] ch, int off, int len) throws IOException {
            String[] escapes = NXMLOutputHandler.this.escapes;
            int start = off;
            while (len > 0) {
                String escaped;
                char c = ch[off];
                if (c < escapes.length && (escaped = escapes[c]) != null) {
                    if (start != off) {
                        NXMLOutputHandler.this.writer.write(ch, start, off - start);
                    }
                    NXMLOutputHandler.this.writer.write(escaped);
                    start = off + 1;
                }
                ++off;
                --len;
            }
            if (start != off) {
                NXMLOutputHandler.this.writer.write(ch, start, off - start);
            }
        }
    }

    class EscapeCharacterHandler
    extends CharacterHandler {
        private int c;
        private StringBuffer buf = new StringBuffer();

        EscapeCharacterHandler() {
        }

        void characters(char[] ch, int off, int len) {
            while (len > 0) {
                if (ch[off] == '\n') {
                    this.buf.append(NXMLOutputHandler.this.lineSeparator);
                } else {
                    this.buf.append(ch[off]);
                }
                ++off;
                --len;
            }
        }

        void setChar(String str) {
            this.buf.setLength(0);
            this.c = str.length() == 0 ? -1 : (int)str.charAt(0);
        }

        void endChar() {
            if (this.c >= 0) {
                if (this.c >= NXMLOutputHandler.this.escapes.length) {
                    int newLen = NXMLOutputHandler.this.escapes.length;
                    while ((newLen *= 2) <= this.c) {
                    }
                    String[] oldEscapes = NXMLOutputHandler.this.escapes;
                    NXMLOutputHandler.access$102(NXMLOutputHandler.this, new String[newLen]);
                    System.arraycopy(oldEscapes, 0, NXMLOutputHandler.this.escapes, 0, oldEscapes.length);
                }
                ((NXMLOutputHandler)NXMLOutputHandler.this).escapes[this.c] = this.buf.toString();
            }
        }
    }

    class CharacterHandler {
        CharacterHandler() {
        }

        void characters(char[] ch, int off, int len) throws IOException {
        }
    }
}

