/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;
import com.jclark.xsl.tr.ResultFragmentVariant;

class CopyOfAction
implements Action {
    private final VariantExpr expr;

    CopyOfAction(VariantExpr expr) {
        this.expr = expr;
    }

    public void invoke(ProcessContext context, Node sourceNode, Result result) throws XSLException {
        Variant value = this.expr.eval(sourceNode, context);
        if (value instanceof ResultFragmentVariant) {
            ((ResultFragmentVariant)value).append(result);
        } else if (value.isNodeSet()) {
            CopyOfAction.copyNodes(context, value.convertToNodeSet(), result);
        } else {
            result.characters(value.convertToString());
        }
    }

    private static void copyNodes(ProcessContext context, NodeIterator iter, Result result) throws XSLException {
        Node node;
        while ((node = iter.next()) != null) {
            switch (node.getType()) {
                case 3: {
                    CopyOfAction.copyNodes(context, node.getChildren(), result);
                    break;
                }
                case 1: {
                    result.characters(node.getData());
                    break;
                }
                case 2: {
                    result.attribute(node.getName(), node.getData());
                    break;
                }
                case 4: {
                    result.processingInstruction(node.getName().toString(), node.getData());
                    break;
                }
                case 5: {
                    result.comment(node.getData());
                    break;
                }
                case 0: {
                    result.startElement(node.getName(), node.getNamespacePrefixMap());
                    CopyOfAction.copyNodes(context, node.getAttributes(), result);
                    CopyOfAction.copyNodes(context, node.getChildren(), result);
                    result.endElement(node.getName());
                }
            }
        }
    }
}

