/***************************** LICENSE START ***********************************

 Copyright 2017 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef PythonHelper_H
#define PythonHelper_H

// --------------------------------------------------
// class PythonHelper
// A language helper specific to the Python language
// --------------------------------------------------

class PythonHelper : public LanguageHelper
{
public:
    PythonHelper();
    virtual ~PythonHelper();

    Highlighter *createHighlighter(QTextDocument *parent = 0);
    bool canCheckSyntax() {return false;}
    bool canDebug()       {return false;}
    bool canRun()         {return true;}
    bool runAsService()   {return false;}
    bool isHelpAvailableForFunction(const QString &/*function*/) {return false;}
    bool isHeaderLine(const QString &text);       // is the text a header line (e.g. "# Metview Macro")?
    QString autoHeaderText();
};




#endif
