val string_is_prefix : string -> ?offset:int -> string -> bool
val string_split :
  ?collapse:bool -> ?max_elem:int -> char -> string -> string list
val string_slice : ?s:int -> ?e:int -> string -> string (** @raise Invalid_argument if slice isn't valid *)
val string_contains : string -> string -> bool

val option_of_list : 'a list -> 'a option
val list_uniq : 'a list -> 'a list
val list_assoc_all : 'a -> ('a * 'b) list -> 'b list
val list_rassoc : 'b -> ('a * 'b) list -> 'a (** @raise Not_found *)
val list_filter_map : ('a -> bool) -> ('a -> 'b) -> 'a list -> 'b list
val array_index : 'a array -> 'a -> int (** @raise Not_found *)

val some : 'a option -> 'a
val may : ('a -> unit) -> 'a option -> unit
val maybe : ('a -> 'b) -> 'a option -> 'b option
val default : 'a -> 'a option -> 'a
val may_assoc : 'a -> ('a * 'b) list -> 'b option
val may_cons : 'a option -> 'a list -> 'a list

val bracket : before:('a -> 'b) -> action:('b -> 'c) -> after:('b -> unit) -> 'a -> 'c

val with_file_in  : (in_channel -> 'a) -> string -> 'a (** @raise Sys_error *)
val with_file_out : (out_channel -> 'a) -> string -> 'a (** @raise Sys_error *)
val input_lines : in_channel -> string list (** @raise Sys_error *)
val input_channel : in_channel -> string (** @raise Sys_error *)

val get_home_dir : unit -> string

val debug : string -> bool
val log   : string -> ('a, unit, string, unit) format4 -> 'a

module Signal :
  sig
    type 'a t

    val make : unit -> 'a t
    val emit : 'a t -> 'a -> unit
    val connect : 'a t -> ('a -> unit) -> unit
  end

val hex_enc : string -> string

val make_cache : ('a -> 'b) -> 'a -> 'b

val hashtbl_of_list : ('a * 'b) list -> ('a, 'b) Hashtbl.t
