/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */



#pragma once


/////////////////////// Qt includes
#include <QString>
#include <QObject>
#include <QScriptable>
#include <QScriptValue>
#include <QScriptString>
#include <QScriptClass>


/////////////////////// Local includes
#include <libmass/Trace.hpp>


namespace msXpSlibmass
{
	class Trace;

	class TraceJsPrototype
		:
			public QObject,
			public QScriptable
	{
		Q_OBJECT

		private:

			Trace *thisTrace() const;

		public:

			TraceJsPrototype(QObject *parent = 0);
			~TraceJsPrototype();

			public slots:

				int initialize();

				int initializeOneArgument();
				int initializeTwoArguments();
				int initializeFourArguments();

			QList<double> keyArray() const;
			QList<double> valArray() const;

			QString asText();

			bool exportToFile(const QString &fileName);

			double valSum() const;

			int combine();
			int subtract();

			QScriptValue valueOf() const;
	};

} // namespace msXpSlibmass

