/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */




#ifndef OLIGOMER_PAIR_HPP
#define OLIGOMER_PAIR_HPP


/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include <globals/globals.hpp>
#include <massxpert/nongui/PropListHolder.hpp>

namespace msXpSmassXpert
{


  class Oligomer;


  class OligomerPair : public PropListHolder
  {
    protected:
    const Oligomer *mp_oligomer1;
    const Oligomer *mp_oligomer2;
		msXpS::MassType        m_massType;
    double          m_error;
    bool            m_isMatching;
    QString         m_name;

    public:
    OligomerPair(const Oligomer *, const Oligomer *, msXpS::MassType, double = 0,
                 bool isMatching = false, const QString & = QString());

    OligomerPair(const OligomerPair &);

    virtual ~OligomerPair();

    QString name();

    const Oligomer *oligomer1() const;
    const Oligomer *oligomer2() const;

    void     setMassType(msXpS::MassType);
    msXpS::MassType massType() const;

    void   setError(double);
    double error() const;

    void setMatching(bool);
    bool isMatching() const;

    double mass1();
    int    charge1();

    double mass2();
    int    charge2();
  };

} // namespace msXpSmassXpert


#endif // OLIGOMER_PAIR_HPP
