#!/usr/bin/perl -w

# install.pl - Install script for NagiosGrapher
# Copyright (C) 2004, NETWAYS GmbH, Gerd Mueller, Marius Hein
# $Id: install.pl 605 2005-12-06 16:14:41Z mhein $
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use vars qw($testdeps $tool $state);
use subs qw (
	getExitState
);

$testdeps = './testdeps.pl';
$tool = './nginstall.pl';

print " - Checking your installed modules:\n";
$state = getExitState( system($testdeps, 'fix') );
if ($state > 0) {
	print "Please install the missing modules first ...\n";
	exit (1);
}
print " - OK, seems to be all there. Run the installer:\n\n";
$state = getExitState ( system($tool, @ARGV) );
exit (0);

sub getExitState {
	my ($input) = @_;
	return $input/256;
}