/*===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
*/

#pragma once

#include "columnblob-base.h"

#include "colfmt.h"
#include "wcoldata.h"

typedef struct KWColumn KWColumn;

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------------
 * KColumnBlob
 *  one or more rows of column data
 */

typedef struct KWColumnBlob KWColumnBlob;
struct KWColumnBlob
{
    KColumnBlob dad;

    /* holds either an existing blob loc
       or new blob index range */
    KColBlobLoc loc;

    /* holds old and new page maps */
    KWColumnPageMap pmorig;
    KWColumnPageMap pmnew;

    /* owning column */
    KWColumn *col;

    /* number of bytes written to blob */
    uint32_t num_writ;

    /* checksums */
    uint32_t crc32;
    MD5State md5;

    /* open mode */
    uint8_t read_only;

    /* for validation */
    bool bswap;
};

rc_t KWColumnBlobMake ( KWColumnBlob **blobp, bool bswap );
rc_t KWColumnBlobOpenRead ( KWColumnBlob *self, const KWColumn *col, int64_t id );
rc_t KWColumnBlobOpenUpdate ( KWColumnBlob *self, KWColumn *col, int64_t id );
rc_t KWColumnBlobCreate ( KWColumnBlob *bself, KWColumn *col );

#ifdef __cplusplus
}
#endif

