<!--
title: "Average or Mean"
sidebar_label: "Average or Mean"
custom_edit_url: https://github.com/netdata/netdata/edit/master/web/api/queries/average/README.md
learn_status: "Published"
learn_topic_type: "References"
learn_rel_path: "Developers/Web/Api/Queries"
-->

# Average or Mean

> This query is available as `average` and `mean`.

An average is a single number taken as representative of a list of numbers.

It is calculated as:

```
average = sum(numbers) / count(numbers)
```

## how to use

Use it in alerts like this:

```
 alarm: my_alert
    on: my_chart
lookup: average -1m unaligned of my_dimension
  warn: $this > 1000
```

`average` does not change the units. For example, if the chart units is `requests/sec`, the result
will be again expressed in the same units. 

It can also be used in APIs and badges as `&group=average` in the URL.

## Examples

Examining last 1 minute `successful` web server responses:

-   ![](https://registry.my-netdata.io/api/v1/badge.svg?chart=web_log_nginx.response_statuses&options=unaligned&dimensions=success&group=min&after=-60&label=min)
-   ![](https://registry.my-netdata.io/api/v1/badge.svg?chart=web_log_nginx.response_statuses&options=unaligned&dimensions=success&group=average&after=-60&label=average&value_color=orange)
-   ![](https://registry.my-netdata.io/api/v1/badge.svg?chart=web_log_nginx.response_statuses&options=unaligned&dimensions=success&group=max&after=-60&label=max)

## References

-   <https://en.wikipedia.org/wiki/Average>.


