## Usage

```js
var toRegex = require('{%= name %}');

console.log(toRegex('foo'));
//=> /^(?:foo)$/

console.log(toRegex('foo', {negate: true}));
//=> /^(?:(?:(?!^(?:foo)$).)*)$/

console.log(toRegex('foo', {contains: true}));
//=> /(?:foo)/

console.log(toRegex(['foo', 'bar'], {negate: true}));
//=> /^(?:(?:(?!^(?:(?:foo)|(?:bar))$).)*)$/

console.log(toRegex(['foo', 'bar'], {negate: true, contains: true}));
//=> /^(?:(?:(?!(?:(?:foo)|(?:bar))).)*)$/
```

## Options

### options.contains

**Type**: `Boolean`

**Default**: `undefined`

Generate a regex that will match any string that _contains_ the given pattern. By default, regex is strict will only return true for exact matches.

```js
var toRegex = require('{%= name %}');
console.log(toRegex('foo', {contains: true}));
//=> /(?:foo)/
```

### options.negate

**Type**: `Boolean`

**Default**: `undefined`

Create a regex that will match everything except the given pattern.

```js
var toRegex = require('{%= name %}');
console.log(toRegex('foo', {negate: true}));
//=> /^(?:(?:(?!^(?:foo)$).)*)$/
```

### options.nocase

**Type**: `Boolean`

**Default**: `undefined`

Adds the `i` flag, to enable case-insensitive matching.

```js
var toRegex = require('{%= name %}');
console.log(toRegex('foo', {nocase: true}));
//=> /^(?:foo)$/i
```

Alternatively you can pass the flags you want directly on [options.flags](#options.flags).

### options.flags

**Type**: `String`

**Default**: `undefined`

Define the flags you want to use on the generated regex.

```js
var toRegex = require('{%= name %}');
console.log(toRegex('foo', {flags: 'gm'}));
//=> /^(?:foo)$/gm
console.log(toRegex('foo', {flags: 'gmi', nocase: true})); //<= handles redundancy
//=> /^(?:foo)$/gmi
```

### options.cache

**Type**: `Boolean`

**Default**: `true`

Generated regex is cached based on the provided string and options. As a result, runtime compilation only happens once per pattern (as long as options are also the same), which can result in dramatic speed improvements. 

This also helps with debugging, since adding options and pattern are added to the generated regex. 

**Disable caching**

```js
toRegex('foo', {cache: false});
```

### options.safe

**Type**: `Boolean`

**Default**: `undefined`

Check the generated regular expression with [safe-regex][] and throw an error if the regex is potentially unsafe.


**Examples**

```js
console.log(toRegex('(x+x+)+y'));
//=> /^(?:(x+x+)+y)$/

// The following would throw an error
toRegex('(x+x+)+y', {safe: true});
```
