"""
Copyright(C) 2007 INL
Written by Pierre Chifflier <p.chifflier AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

$Id: cron.py 10427 2007-10-23 13:44:51Z romain $
"""

from twisted.internet import reactor
from twisted.internet import task

def scheduleOnce(delay, callback, *args, **kwargs):
	""" Schedule execution of callback once.
	Callback is executed after waited "delay" seconds

	"""
	reactor.callLater(when, callback, *args, **kwargs)

def scheduleRepeat(period, callback, *args, **kwargs):
	""" Schedule execution of callback periodically.
	Callback is executed immediately, then every "period" seconds
	"""
	t = task.LoopingCall(callback, *args, **kwargs)
	t.start(period)
