/*
 * (C) Copyright 1996-2012 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

#ifndef odb_api_ECMLTool_H
#define odb_api_ECMLTool_H

#include "ecml/core/ExecutionContext.h"

#include "Tool.h"

namespace odb {

namespace tool {

class ECMLTool : public Tool {

public:
	ECMLTool(int argc, char **argv);
	~ECMLTool();

	virtual void run();

	static void help(std::ostream &o) { o << "Executes ECML script(s) with ODB module imported"; }
	static void usage(const std::string& name, std::ostream &o)
	{
		o << name << " <script-file> ..." << std::endl;
	}

    static void executeRC(ecml::ExecutionContext&);
};

} // namespace tool 
} // namespace odb 

#endif

