/*
 * Copyright (c) 2013, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8008164 8169819 8183037 8182765 8196202 8184205
 * @summary Test styles on HTML tables generated by javadoc.
 * @author Bhavesh Patel
 * @library ../lib
 * @modules jdk.javadoc/jdk.javadoc.internal.tool
 * @build JavadocTester
 * @run main TestHtmlTableStyles
 */

public class TestHtmlTableStyles extends JavadocTester {

    public static void main(String... args) throws Exception {
        TestHtmlTableStyles tester = new TestHtmlTableStyles();
        tester.runTests();
    }

    @Test
    void test() {
        javadoc("-d", "out",
                "-sourcepath", testSrc,
                "-use",
                "--frames",
                "pkg1", "pkg2");
        checkExit(Exit.ERROR);
        checkOutput(Output.OUT, true,
                "attribute not supported in HTML5: summary",
                "attribute border for table only accepts \"\" or \"1\", use CSS instead: BORDER",
                "attribute not supported in HTML5: cellpadding",
                "attribute not supported in HTML5: cellspacing",
                "attribute not supported in HTML5: align");

        checkOutput("pkg1/TestTable.html", true,
                "<table summary=\"Summary\" border cellpadding=3 cellspacing=1>",
                "<div class=\"memberSummary\">\n<table>",
                "<div class=\"memberSummary\">\n<table>",
                "<div class=\"memberSummary\">\n<table>");

        checkOutput("pkg1/package-summary.html", true,
                "<div class=\"typeSummary\">\n<table>");

        checkOutput("pkg1/class-use/TestTable.html", true,
                "<div class=\"useSummary\">\n<table>");

        checkOutput("overview-summary.html", true,
                "<div class=\"overviewSummary\">\n<table>");

        checkOutput("deprecated-list.html", true,
            "<div class=\"deprecatedSummary\">\n<table>");

        checkOutput("constant-values.html", true,
            "<div class=\"constantsSummary\">\n<table>");
    }

    @Test
    void test_html4() {
        javadoc("-d", "out-html4",
                "-html4",
                "-sourcepath", testSrc,
                "-use",
                "--frames",
                "pkg1", "pkg2");
        checkExit(Exit.OK);

        checkOutput("pkg1/TestTable.html", true,
                "<table summary=\"Summary\" border cellpadding=3 cellspacing=1>",
                "<div class=\"memberSummary\">\n"
                + "<table summary=\"Field Summary table, listing fields, "
                + "and an explanation\">",
                "<div class=\"memberSummary\">\n"
                + "<table summary=\"Constructor Summary table, listing "
                + "constructors, and an explanation\">",
                "<div class=\"memberSummary\">\n",
                "<table summary=\"Method Summary table, listing methods, "
                + "and an explanation\" aria-labelledby=\"t0\">");

        checkOutput("pkg1/package-summary.html", true,
                "<div class=\"typeSummary\">\n"
                + "<table summary=\"Class Summary table, listing classes, "
                + "and an explanation\">");

        checkOutput("pkg1/class-use/TestTable.html", true,
                "<div class=\"useSummary\">\n"
                + "<table summary=\"Use table, listing fields, and an explanation\">");

        checkOutput("overview-summary.html", true,
                "<div class=\"overviewSummary\">\n"
                + "<table summary=\"Package Summary table, listing packages, and an explanation\">");

        checkOutput("deprecated-list.html", true,
            "<div class=\"deprecatedSummary\">\n"
            + "<table summary=\"Methods table, listing methods, and an explanation\">");

        checkOutput("constant-values.html", true,
            "<div class=\"constantsSummary\">\n"
            + "<table summary=\"Constant Field Values table, listing constant fields, and values\">");
    }
}
