/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package testpackage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Main {

    private static final int MAIN_VERSION = 8;

    public static void main(String[] args) {
        System.out.println("Main version: " + getMainVersion());
        System.out.println("Helpers version: " + getHelperVersion());
        System.out.println("Resource version: " + getResourceVersion());
    }

    public static int getMainVersion() {
        return MAIN_VERSION;
    }

    public static int getHelperVersion() {
        return testpackage.Helper.getHelperVersion();
    }

    public static int getResourceVersion() {
        ClassLoader cl = Main.class.getClassLoader();
        InputStream ris = cl.getResourceAsStream("versionResource");
        if (ris == null) {
            throw new Error("Test issue: resource versionResource"
                    + " cannot be loaded!");
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(ris))) {
            return Integer.parseInt(br.readLine());
        } catch (IOException ioe) {
            throw new Error("Unexpected issue", ioe);
        }
    }
}
