/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;

import javax.swing.table.*;
import javax.swing.*;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Component;
import javax.swing.JTable;
import java.awt.Color; 
import java.util.ArrayList;


/***
 * MySymbolTableRenderer inherits from DefaultTableCellRenderer and manage the design of the SymbolGroupTable
 * 
 */

public class MySymbolTableRenderer extends DefaultTableCellRenderer{
	   
	/**
	 * generated serialVersionUID
	 */
	private static final long serialVersionUID = -5279942824838554675L;
		private int view = 0;
		public boolean[] avail = {false,false,false};
		public ArrayList<String> hiddenExecs = new ArrayList<String>();
		public ArrayList<String> hiddenLibs = new ArrayList<String>();
		public ArrayList<String> hiddenGrps = new ArrayList<String>();
		private String search = ""; 
	
		private boolean isEditable = true;
		
		public void setDisabled(){
			isEditable = false;
		}
		public void setEnabled(){
			isEditable = true;
		}
		
	/***
	* set the rendering of the current component
	*/
	   public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, 
               boolean hasFocus, int row, int column) {
		   Component comp = this;
		   setText((value != null)?value.toString():"");
		   
		   setEnabled(isEditable);
		   if(value == null)
			   return this;
		   
		   
			if(isSelected)
				setBackground(Color.YELLOW);
			else
				setBackground(Color.WHITE);
		   if(view == SymbolGroupTable.GENERAL_VIEW)
				getTableCellRendererComponent_General( table, value, isSelected, hasFocus, row, column);			
		   if(view == SymbolGroupTable.GROUP_VIEW)
			   comp = getTableCellRendererComponent_Group( table, value, isSelected, hasFocus, row, column);
		
		   if(view == SymbolGroupTable.FILTER_VIEW)
			   comp = getTableCellRendererComponent_Filter( table, value, isSelected, hasFocus, row, column);
		   
		//      if(search.length() >= 1 && column == 0)
		//    	  comp = markSearch(this.getText(),this);

		   return comp;
	   }
	
	
		/***
		* set the rendering of the current component if the view is General
		*/
	public Component getTableCellRendererComponent_General(JTable table, Object value, boolean isSelected, 
	                                                  boolean hasFocus, int row, int column) {
			

		  if(table.getRowSorter() == null)
			  return this;
		  @SuppressWarnings("unused")
		boolean isValue = false;
		  DefaultTableModel model = (DefaultTableModel) table.getRowSorter().getModel();
	      setFont(getFont().deriveFont(Font.PLAIN));

	    //libs anzeigen:
	      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 0).toString().toLowerCase().trim().endsWith("lib") && column == 0)
	      {
	    	  String type = model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 2).toString().trim();
	    	  if(type.endsWith("ABC9998"))
	    	  {
	    		  setFont(getFont().deriveFont(Font.BOLD));
					setBackground(Color.WHITE);
	    		  if(hiddenLibs.contains(type.substring(0, type.length()-7)))
	    			setText("+ "+getText());
	    		  else
	    			setText("- "+getText());
	    	  }
	    	  else
	    	  {
	    		  setText("     "+getText());
	    	  }
	    	  
	      }
	      
	      
	      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 0).toString().toLowerCase().trim().endsWith("exec") && column == 0)
	      {
	    	  String type = model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 2).toString().trim();
	    	  if(type.endsWith("ABC9998"))
	    	  {
	    		  setFont(getFont().deriveFont(Font.BOLD));
					setBackground(Color.WHITE);
	    		  if(hiddenExecs.contains(type.substring(0, type.length()-7)))
	    			setText("+ "+getText());
	    		  else
	    			setText("- "+getText());
	    	  }
	    	  else
	    	  {
	    		  setText("     "+getText());
	    	  }
	    	  
	      }
	      
	      //System anzeigen:
	      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 0).toString().toLowerCase().trim().endsWith("system") && column == 0)
	      {
			  setBackground(Color.WHITE);
	    	  setFont(getFont().deriveFont(Font.BOLD));
	    	  if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 1).toString().toLowerCase().trim().equals("executable"))
	    	  {
	    		  	if(avail[0])
	    		  		setText("+ "+getText());
	    		  	else
	    		  		setText("- "+getText());
	    	  }
	    	  if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 1).toString().toLowerCase().trim().startsWith("lib"))
	    	  {
	    		  	if(avail[1])
	    		  		setText("+ "+getText());
	    		  	else
	    		  		setText("- "+getText());
	    	  }
	    	  
	    	  if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 1).toString().toLowerCase().trim().equals("extra symbols"))
	    	  {
	    		  	if(avail[2])
	    		  		setText("+ "+getText());
	    		  	else
	    		  		setText("- "+getText());
	    	  }
	      }
	      else
	      {
	    	  isValue=true;
	    	  setText("     "+getText());
	      }

	      
	      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 0).toString().toLowerCase().trim().endsWith("system_add"))
	      {
	    	  setFont(getFont().deriveFont(Font.ITALIC));
				setBackground(Color.WHITE);
	    	  
	      }
	      
	      return this;
	   }
	
	/***
	* set the rendering of the current component if the view is Filtering
	*/
	public Component getTableCellRendererComponent_Filter(JTable table, Object value, boolean isSelected, 
            										boolean hasFocus, int row, int column) {
		
		if(getText().trim().equals("no Group"))
				setText(getText()+" ( Application )");
		TableModel model = table.getModel();
			if(table.getRowSorter() != null)
				model = table.getRowSorter().getModel();
			setFont(getFont().deriveFont(Font.PLAIN));				
			

		    //libs anzeigen: unlimited 
		      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 0).toString().toLowerCase().trim().endsWith("grp") && column == 0)
		      {
		    	  setFont(getFont().deriveFont(Font.BOLD));
		    	  if(hiddenGrps.contains(value))
		    		  setText("+ "+getText());
		    	  else
		    		  setText("- "+getText());
		      }
		      else
		      {
		    	  if(column == 0)
		    		  setText("     "+getText());
		      }
		      
		      
		      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 3) == null)
		    	  model.setValueAt("",table.getRowSorter().convertRowIndexToModel(row), 3);
		      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 3).toString().toLowerCase().trim().equals("-1") && column == 1)
		      {
		    	  setText("unlimited");
		      }
		      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 3).toString().toLowerCase().trim().equals("0") && column == 1)
		      {
		    	  setText("not traced");
		      }
		      if(!(getText().equals("unlimited")  || getText().equals("not traced")) && column == 1)
		    	  setText(getText()+" times traced");
		      if(model.getValueAt(table.getRowSorter().convertRowIndexToModel(row), 3).toString().toLowerCase().trim().equals("") && column == 1)
		      {
		    	  setText("");
		      }
		      
		      
			return this;
		}
	
	/***
	* set the rendering of the current component if the view is Group
	*/
	public Component getTableCellRendererComponent_Group(JTable table, Object value, boolean isSelected, 
													boolean hasFocus, int row, int column) {

			setFont(getFont().deriveFont(Font.PLAIN));
			return this;
		}
	
	/***
	 * set the view of the Renderer 
	 * @param view use 
	 */
	public void setView(int view)
	{
	   this.view = view;
	}
	
	/***
	 * set the search attribute for this class
	 * @param search is a string, that is marked in the Table
	 */
	public void setSearch(String search)
	{
		this.search = search;
	}
	
	/***
	 * method that divide a Entry in parts and mark the part that is searched for
	 * @param value content of the  cell
	 * @param comp current Cell component
	 * @return Component with the marked searchkey
	 */
	@SuppressWarnings("unused")
	private Component markSearch(String value,Component comp)
	{
		JPanel output = new JPanel();
		String search = this.search;
		
		
		String[] val = value.split("(?i)"+search,2);	
		if(val.length <2)
			return comp;
		int start = value.indexOf(val[0])+val[0].length();
		int end = value.indexOf(val[1]);
		if(end == 0)
			end = value.length();
		search = value.subSequence(start,end ).toString();
		JLabel firstpart = new JLabel(val[0]);
		JLabel secondpart = new JLabel(search);
		JLabel thirdpart = new JLabel(val[1]);
		
		firstpart.setFont(comp.getFont());
		secondpart.setFont(getFont().deriveFont(Font.BOLD));
		thirdpart.setFont(comp.getFont());
		
		firstpart.setAlignmentX(LEFT_ALIGNMENT);
		secondpart.setAlignmentX(LEFT_ALIGNMENT);
		thirdpart.setAlignmentX(LEFT_ALIGNMENT);
		
		FlowLayout layout = new FlowLayout(FlowLayout.LEFT);
		layout.setHgap(0);
		layout.setVgap(0);
		output.setLayout(layout);
		output.setBackground(getBackground());

		
		secondpart.setBackground(Color.YELLOW);
		secondpart.setOpaque(true);
		
		output.add(firstpart);
		output.add(secondpart);
		output.add(thirdpart);
		
		return output;
	}
	
	/***
	 * returns the string that is searched for
	 * @return string that is searched for
	 */
	public String getSearchString()
	{
		return search;
	}
	   
	   
}