/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Locale;

import grpFilt.GrpFiltWidget;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;


import xmlObjects.*;


/***
 * Class to generate scripts.
 */
public class GenerateScript {
	private ArrayList<Item> items = null;
	private String Filename = null;
	private String FilenameFilt = null;
	private String FilenameGrp = null;
	private int script = 0;
	
	public final static int SHELL = 0;
	public final static int CSHELL = 1;
	public final static int BATCH = 2;
	public final static int APPLE = 3;
	public final static int ALL = 4;
		
	
	/***
	 * initialize class
	 * @param items list of all Items that are in the script
	 */
	public GenerateScript(ArrayList<Item> items)
	{
		this.items = items;
	}

	
	/***
	 * Method to set the filename of the new script
	 * @param filterregel number of the script-type use SHELL, CSHELL, BATCH or APPLE 
	 * @return true if filename was set otherwise false
	 */
	public boolean setFilename(int filterregel)
	{
		JFileChooser chooser = new JFileChooser();
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setLocale(Locale.ENGLISH);
		chooser.setMultiSelectionEnabled(false);
		ArrayList<FileNameExtensionFilter> filter = new ArrayList<FileNameExtensionFilter>();
		
		filter.add(new FileNameExtensionFilter("bash/shell script  .sh","sh"));
		filter.add(new FileNameExtensionFilter("c-shell script .csh","csh"));
		filter.add(new FileNameExtensionFilter("batch script .bat","bat"));
		chooser.setFileFilter(filter.get(0));
		
		
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		
		switch(filterregel)
		{
		case 0: chooser.addChoosableFileFilter(filter.get(0)); break; // shell
		case 1: chooser.addChoosableFileFilter(filter.get(1)); break; // c-shell
		case 2: chooser.addChoosableFileFilter(filter.get(2)); break; // batch
		case 3: chooser.addChoosableFileFilter(filter.get(3)); break; // apple script
		default: 
			for(int i = 0; i < filter.size();i++)
			    chooser.addChoosableFileFilter(filter.get(i));
		   
		}
		
		 
	    File f = null;
	    try{
	    	f = new File(new File(".").getCanonicalPath());
	    	chooser.setCurrentDirectory(f);
	    }catch(Exception ex)
	    {
	    	Config.errorHandler(ex);
	    }
	    
	    chooser.showSaveDialog(null);
	    
	    if(chooser.getSelectedFile() != null)
	    {
	    	try{
	    		this.Filename = chooser.getSelectedFile().getCanonicalPath();
	    		createFilenameGroupFilt();
	    		int filetype = filter.lastIndexOf(chooser.getFileFilter());
	    		if(filterregel >= ALL)
	    		{
	    			this.script = filetype;
	    		}
	    		else
	    			this.script = filterregel;
	    		
	    		return true;
	    	}catch(Exception e)
	    	{
	    		Config.errorHandler(e);
	    	}
	    	
	    	
	    }
	    
	    return false;
	    
	}
	
	
	private void createFilenameGroupFilt()
	{
		String GrpFile = "";
		String FiltFile = "";
		for(int i=0; i<items.size();i++)
		{
			if(items.get(i).getEnvname().equals("VT_FILTER_SPEC"))
				FiltFile = valString(items.get(i).getValue());
			if(items.get(i).getEnvname().equals("VT_GROUPS_SPEC"))
				GrpFile = valString(items.get(i).getValue());
			if(!FiltFile.equals("") && !GrpFile.equals(""))
				break;
		}
		
		if( !GrpFile.contains("/") && Filename.contains("/"))
			GrpFile = Filename.substring(0,Filename.lastIndexOf("/"))+"/"+GrpFile;
		if( !GrpFile.contains("\\") && Filename.contains("\\"))
			GrpFile = Filename.substring(0,Filename.lastIndexOf("\\"))+"\\"+GrpFile;
		
		if( !FiltFile.contains("/") && Filename.contains("/"))
			FiltFile = Filename.substring(0,Filename.lastIndexOf("/"))+"/"+FiltFile;
		if( !FiltFile.contains("\\") && Filename.contains("\\"))
			FiltFile = Filename.substring(0,Filename.lastIndexOf("\\"))+"\\"+FiltFile;
		
		FilenameFilt = FiltFile;
		FilenameGrp = GrpFile;
	}
	/***
	 * Return the filename
	 * @return filename that was set by setFilename
	 */
	public String getGrpFileName()
	{
		return this.FilenameGrp;
	}
	/***
	 * Return the filename
	 * @return filename that was set by setFilename
	 */
	public String getFiltFileName()
	{
		return this.FilenameFilt;
	}
	/***
	 * Return the filename
	 * @return filename that was set by setFilename
	 */
	public String getFileName()
	{
		return this.Filename;
	}
	/***
	 * set filename
	 * @param filename path to file that should be generated
	 */
	public void setFilename(String filename)
	{
		
		this.Filename = filename;
		createFilenameGroupFilt();
	}
	
	/****
	 * Generate script and write it to the filename
	 */
	public void generate(GrpFiltWidget groupFilt)
	{
		String[] header = {"#! /bin/sh","#! /bin/csh","",""};
		String[] command = {"export ","set ","set ","property "};
		String[] allocation = {"=\"","=\"","="," : \""};
		String[] suffix = {"\"","\"","","\""};
		String[] comment = {"# ","# ","REM ","-- "};
		
		ArrayList<String> set = new ArrayList<String>();
		ArrayList<String> def = new ArrayList<String>();
		
		BufferedWriter out = null;
		
		try{
			out = new BufferedWriter(
	                new OutputStreamWriter(
	                        new FileOutputStream( getValidFileName() ) 
	                        ) 
	        );	
		
			String ausgabe = "";
			
			out.write( header[this.script], 0 ,header[this.script].length() );
			out.newLine();
			ausgabe = comment[this.script]+"This script should be sourced!";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			ausgabe = comment[this.script]+"";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			ausgabe = comment[this.script]+"This script was generated by VTSetup";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			ausgabe = comment[this.script]+"and sets enviroment variables for vampirtrace";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			out.newLine();

			for(int i = 0; i<this.items.size();i++)
			{
				ausgabe = command[this.script]+items.get(i).getEnvname();
				ausgabe = ausgabe + allocation[this.script]+valString(items.get(i).getValue())+ suffix[this.script];
				
				if(items.get(i).isDefault())
					def.add(ausgabe);
				else
					set.add(ausgabe);
				ausgabe = "";
				
			}
			out.newLine();
			ausgabe = comment[this.script]+"variables set by user";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			for(int i=0;i<set.size();i++)
			{
					out.write( set.get(i), 0 ,set.get(i).length() );
					out.newLine();
			}
			out.newLine();
			out.newLine();
			
			ausgabe = comment[this.script]+"variables set by default";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			for(int i=0;i<def.size();i++)
			{
					out.write( def.get(i), 0 ,def.get(i).length() );
					out.newLine();
			}
			
			ausgabe = "if [ $# -gt 0 ] ";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			ausgabe = "   then $@";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			ausgabe = "fi";
			out.write( ausgabe, 0 ,ausgabe.length() );
			out.newLine();
			groupFilt.generateFilterFile(FilenameGrp,FilenameFilt);
			
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}
		
		try
		{
			if(out != null)
				out.close();
		}catch(Exception ex)
		{
			Config.errorHandler(ex);
		}

	}
	
	/****
	 * combines ValDesc to one value
	 * @param desc List of value descriptions
	 * @return value of the value descriptions
	 */
	private String valString(ArrayList<ValDesc> desc)
	{
		String output = "";
		for(int i = 0; i < desc.size(); i++)
		{
			output = output + desc.get(i).getCurrent();
		}
		
		return output;
	}
	
	/***
	 * method that append the right suffix to the filename.
	 * @return returns a valid filename
	 */
	private String getValidFileName()
	{
		String[][] suffix ={ 
					{".sh"},
					{".csh", ".tcsh"},
					{".bat"},
					{".scpt"}
				};
		boolean noending = true;
		
		String output = this.Filename.trim();
		
		for(int i = 0; i < suffix[this.script].length; i++)
		{
			if(output.toLowerCase().endsWith(suffix[this.script][i]))
			{
				noending = false;
				break;
			}
		}	
		
		if(noending)
			output = output +suffix[this.script][0];
		
		return output;
	}
}
