/***************************************************************************
 *   Copyright (C) 2007 by Matvey Kozhev                                   *
 *   sikon@lucidfox.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "envmap.h"

EnvMap::EnvMap(QProcess *process)
 : QObject(0), _process(process)
{
    reload();
}


EnvMap::~EnvMap()
{
}


/*!
    \fn EnvMap::reload()
 */
void EnvMap::reload()
{
    _map.clear();
    
    QStringList env = _process ? _process->environment() : QProcess::systemEnvironment();
    
    for(int i = 0; i < env.size(); i++)
    {
        QStringList list = env.at(i).split('=');
        
        _map.insert(list.at(0), list.at(1));
    }
}


/*!
    \fn EnvMap::at(const QString& key, const QString& def)
 */
QString EnvMap::at(const QString& key, const QString& def) const
{
    QString result = _map[key];
    return result.isEmpty() ? def : result;
}
