# -*- coding: utf-8 -*-
"""
    :codeauthor: Rahul Handay <rahulha@saltstack.com>
"""
# Import Python libs
from __future__ import absolute_import, print_function, unicode_literals

# Import Salt Libs
import salt.states.event as event

# Import Salt Testing Libs
from tests.support.mixins import LoaderModuleMockMixin
from tests.support.mock import MagicMock, patch
from tests.support.unit import TestCase


class EventTestCase(TestCase, LoaderModuleMockMixin):
    """
        Validate the event state
    """

    def setup_loader_modules(self):
        return {event: {}}

    def test_send(self):
        """
            Test to send an event to the Salt Master
        """
        with patch.dict(event.__opts__, {"test": True}):
            self.assertDictEqual(
                event.send("salt"),
                {
                    "changes": {"data": None, "tag": "salt"},
                    "comment": "Event would have been fired",
                    "name": "salt",
                    "result": None,
                },
            )

        with patch.dict(event.__opts__, {"test": False}):
            mock = MagicMock(return_value=True)
            with patch.dict(event.__salt__, {"event.send": mock}):
                self.assertDictEqual(
                    event.send("salt"),
                    {
                        "changes": {"data": None, "tag": "salt"},
                        "comment": "Event fired",
                        "name": "salt",
                        "result": True,
                    },
                )

    def test_wait(self):
        """
            Test to fire an event on the Salt master
        """
        self.assertDictEqual(
            event.wait("salt"),
            {"changes": {}, "comment": "", "name": "salt", "result": True},
        )
