#include <sci_mysql.h>

#include <string.h>

#if SCI_VERSION_MAJOR >=5 && SCI_VERSION_MINOR >=3
#else
SciErr getAllocatedSingleString(void* _pvCtx, int* _piAddress, char** _pstStrings)
{
  SciErr _SciErr;
  int i;
  int iRows = 0;
  int iCols = 0;
  int * _piLength = NULL;
  char ** _pstTemp = NULL;

  _SciErr = getMatrixOfString(_pvCtx, _piAddress, &iRows, &iCols, NULL, NULL);
  if (_SciErr.iErr) return _SciErr;
  
  _piLength = (int *)MALLOC(sizeof(int)*iRows*iCols);
  if (!_piLength) 
    {
      addErrorMessage(&_SciErr, API_ERROR_CREATE_STRING, _("%s: can't allocate memory"), "getAllocatedSingleString");
      return _SciErr;
    }
  _pstTemp = (char **)MALLOC(sizeof(char *)*iRows*iCols);
  if (!_pstTemp) 
    {
      addErrorMessage(&_SciErr, API_ERROR_CREATE_STRING, _("%s: can't allocate memory"), "getAllocatedSingleString");
      FREE(_piLength);
      return _SciErr;
    }
  _SciErr = getMatrixOfString(_pvCtx, _piAddress, &iRows, &iCols, _piLength, NULL);
  for(i=0;i<iRows*iCols;i++)
    {
      _pstTemp[i] = (char *)MALLOC(sizeof(char)*(_piLength[i]+1));
    }
  _SciErr = getMatrixOfString(_pvCtx, _piAddress, &iRows, &iCols, _piLength, _pstTemp);

  _pstStrings[0] = strdup(_pstTemp[0]);

  return _SciErr;
}

int createSingleString(void* _pvCtx, int _iVar, char* _pstStrings)
{
  SciErr _SciErr;

  _SciErr = createMatrixOfString(_pvCtx, _iVar, 1, 1, _pstStrings);

  return _SciErr.iErr;
}

int isEmptyMatrix(void* _pvCtx, int* _piAddress)
{
  int var_type;
  int nb_rows, nb_cols;
  SciErr _SciErr;

  _SciErr = getVarType(_pvCtx, _piAddress, &var_type);
  if (var_type == sci_matrix)
    {
      _SciErr = getVarDimension(_pvCtx, _piAddress, &nb_rows, &nb_cols);
      return ((nb_cols==0)&&(nb_rows==0));
    }
  return 0;
}

int getScalarDouble(void* _pvCtx, int* _piAddress, double* _pdblReal)
{
  SciErr _SciErr;
  int nb_cols, nb_rows;
  double * _pdblRealTemp;

  _SciErr = getMatrixOfDouble(_pvCtx, _piAddress, &nb_rows, &nb_cols, &_pdblRealTemp);
  
  if (_SciErr.iErr) return _SciErr.iErr;

  _pdblReal[0] = _pdblRealTemp[0];

  return 0;
}

int createScalarDouble(void* _pvCtx, int _iVar, double _dblReal)
{
  SciErr _SciErr;

  _SciErr = createMatrixOfDouble(_pvCtx, _iVar, 1, 1, &_dblReal);

  return _SciErr.iErr;
}

int createEmptyMatrix(void* _pvCtx, int _iVar)
{
  SciErr _SciErr;

  _SciErr = createMatrixOfDouble(_pvCtx, _iVar, 0, 0, NULL);

  return _SciErr.iErr;
}
#endif
