#include "bwadm.hpp"
#include <new>
#include <list>
#include <string.h>

using namespace std;

bwadm::bwadm()
{
	n_classes = 0;
	v_classes = 0;
}

bwadm::~bwadm()
{
	for( int i = 0 ; i<n_classes ; i++ ) {
		delete v_classes[i];
	}
	delete[] v_classes;
}

int bwadm::add_class(int id, int bw=0)
{
	classinfo **new_v, *new_classinfo;

	// temporary stuff. avoid!!!
	if( n_classes!=id ) return -1;

	new_v = new(nothrow) (classinfo*)[n_classes+1];
	if( new_v==0 ) goto __err_newv;

	new_classinfo = new(nothrow) classinfo;
	if( new_classinfo==0 ) goto __err_newclassinfo;

	if( n_classes>0 ) {
		memcpy(new_v, v_classes, n_classes*sizeof(classinfo*));
		delete[] v_classes;
	}
	v_classes = new_v;
	v_classes[n_classes] = new_classinfo;
	
	v_classes[n_classes]->cbw = bw;
	v_classes[n_classes]->eff_bw = 0;
	v_classes[n_classes]->borrowed = 0;
	v_classes[n_classes]->t_lend_exp = 0;
	v_classes[n_classes]->t_borrow_exp = 0;
	v_classes[n_classes]->t_lasttx = 0;
	v_classes[n_classes]->id = id;
	n_classes++;
	return 0;
	__err_newclassinfo:
		delete[] new_v;
	__err_newv:
		return -1;
}

int bwadm::add_lender(int classid, int lenderid)
{
	if( classid<0 || classid>n_classes ) return -1;
	if( lenderid<0 || lenderid>n_classes ) return -1;

	classinfo *my_classinfo = v_classes[classid];
	list<int> *list = &my_classinfo->lenders;
	list->push_back(lenderid);

	return 0;
}

void bwadm::update_classinfo(classinfo *pc)
{
	if( pc->borrowed ) {
		u_int64_t now = ck();
		if( now >= pc->t_borrow_exp ) {
			pc->borrowed = 0;
		}
	}
}

// sacar esto ya !!!
const u_int64_t __lend_dt__ = (1LL<<32)/5;

// 0 -> ok
// 1 -> no bandwidth available
int bwadm::getbw(int classid, int bytes, u_int64_t *dt)
{
	u_int64_t now = ck();
	classinfo *my_class = v_classes[classid];

	my_class->t_lasttx = now;

	if( my_class->t_lend_exp > now ) {
		// *t = bytes / my_class->eff_bw
		*dt = (u_int64_t)(bytes);
		*dt <<= 32;
		*dt /= my_class->eff_bw;

		return 0;
	}

	update_classinfo(my_class);
	if( my_class->borrowed ) {
		u_int64_t dt_pckt;

		// dt_pckt = bytes / my_class->cbw
		dt_pckt = (u_int64_t)(bytes);
		dt_pckt <<= 32;
		dt_pckt /= my_class->cbw;

		*dt = my_class->t_borrow_exp - now;
		*dt += dt_pckt;

		my_class->t_borrow_exp += dt_pckt;
		
		return 0;
	} else {
		my_class->eff_bw = my_class->cbw;

		// walk thru lenders list and see
		// who can borrow us some bw
		// 
		list<int>::iterator iter;
		list<int> *list = &my_class->lenders;
		for( iter = list->begin() ; iter!=list->end() ; iter++ ) {
			classinfo *p_lender = v_classes[*iter];
			update_classinfo(p_lender);
			if( p_lender->borrowed || p_lender->cbw==0 ) {
				continue;
			}

			u_int64_t tmp_dt = 1LL<<32;
			tmp_dt += p_lender->t_lasttx;
			if( now < tmp_dt ) {
				continue;
			}

			// 1 - no presto su bw
			// 2 - inactivo desde hace rato
			// -> tomamos su bw
			my_class->eff_bw += p_lender->cbw;
			p_lender->borrowed = 1;
			p_lender->t_borrow_exp = now + __lend_dt__;
		}
		if( my_class->eff_bw > 0 ) {
			my_class->t_lend_exp  = now + __lend_dt__;

			// *dt = bytes / my_class->eff_bw
			*dt = (u_int64_t)(bytes);
			*dt <<= 32;
			*dt /= my_class->eff_bw;

			return 0;
		} else {
			return 1;
		}
	}
}
