#ifndef _CLASSIFIER_HPP_
#define _CLASSIFIER_HPP_

#include "packet.hpp"

extern "C" {
	#include <sys/types.h>
}

class packet_classifier {
	public:
		virtual int check(generic_packet *pckt)=0;
		virtual int get_user_prio()=0;
		virtual int get_real_prio()=0;
		virtual int set_user_prio(int pr)=0;
		virtual int set_real_prio(int pr)=0;
		virtual char *log() =0;
		packet_classifier() {}
		virtual ~packet_classifier() {}
};

class ipv4_packet_classifier : public packet_classifier {
	struct port_range { int low, high; };
	int proto;
	int real_prio;
	int user_prio;

	struct port_range *sport_list;
	struct port_range *dport_list;
	int n_sports, n_dports;

	u_int32_t saddr, smask;
	u_int32_t daddr, dmask;

	char *inp_if, *out_if;
	int n_inp_if, n_out_if;

	int check_port(int port, port_range *list, int n);

	public: 
		ipv4_packet_classifier();
		~ipv4_packet_classifier();
		int set_saddr(const char *addr, const char *mask);
		int set_daddr(const char *addr, const char *mask);
		int set_proto(int n);
		int get_user_prio();
		int get_real_prio();
		int set_user_prio(int pr);
		int set_real_prio(int pr);
		int set_inp_if(char *str);
		int set_out_if(char *str);
		int add_src_port(int lo, int hi);
		int add_dst_port(int lo, int hi);
		virtual char *log();
		virtual char *log_attr(char *p, int n);
		virtual int check(generic_packet *pckt);
};

#ifdef WITH_IPQ
class nf_packet_classifier : public ipv4_packet_classifier {
	public:
	unsigned long fwmark, fwmask;

	public:
		int check(generic_packet *pckt);
		char *log();
		char *log_attr(char *p, int n);
		nf_packet_classifier();
		~nf_packet_classifier();
};
#endif

#endif
