/* ====================================================================
 * Copyright (c) 2006-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEWVIEWSTATE_H
#define _SC_WCVIEWVIEWSTATE_H

// sc
#include "TextStatusFilter.h"
#include "util/String.h"
class Bookmark;

// sys
#include <map>
#include <vector>

// qt
#include <QtCore/QObject>


/** a WcViewTree can be configured as tree view or as a flat view. */
enum WcViewType {
    WcViewTypeNone,  ///< uninitialized
    WcViewTypeFlat,  ///< view is a flat view
    WcViewTypeTree   ///< view as a tree view
};


typedef std::map< sc::String, bool >  WcViewExpandedItems;
typedef std::map< sc::String, bool >  WcViewSelectedItems;
typedef std::vector< sc::String >     PathHistory;

/** store wc view configuration. */
class WcViewViewState : public QObject
{
  typedef QObject super;
  Q_OBJECT

public:
  WcViewViewState( Bookmark* );

  void clearExpanded();
  void setExpanded( const sc::String& name, bool );
  bool isExpanded( const sc::String& name );

  void clearSelected();
  void setSelected( const sc::String& name, bool );
  bool isSelected( const sc::String& name );

  void getPrevPathHistory( PathHistory& );
  void getNextPathHistory( PathHistory& );

  const sc::String& getPath();
  void setPath( const sc::String& path );
  void addPath( const sc::String& path );

  bool getViewAll();
  bool getViewUpdates();
  WcViewType getType();
  bool isFlat() const;
  bool isTree() const;

  /** layout info. */
  void setViewHeader( const sc::String& header );
  sc::String getViewHeader();

  TextStatusFilter getTextStatusFilter() const;
  void setTextStatusFilter( const TextStatusFilter& filter );

public slots:
  void prevPath();
  void nextPath();
  void prevPath( int cnt );
  void nextPath( int cnt );
  void setViewAll( bool on );
  void setViewUpdates( bool on );
  void setType( WcViewType type );

signals:
  void historyChanged();
  void currentChanged( const sc::String& );
  void optionsChanged();

private:
  Bookmark*            _bm;

  bool                 _all;
  bool                 _updates;

  WcViewExpandedItems  _itemExpanded;
  WcViewSelectedItems  _itemSelected;

  PathHistory          _pathHistory;
  unsigned int         _pathPos;

  WcViewType           _type;
  TextStatusFilter     _filter;
};


#endif // _SC_WCVIEWVIEWSTATE_H
