/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXTMODEL_TESTREMOVE_H
#define _TEXTMODEL_TESTREMOVE_H

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>
class TextModel;

class TextModelTestRemove : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( TextModelTestRemove );
  CPPUNIT_TEST( testRemoveLeft );
  CPPUNIT_TEST( testRemoveRight );
  CPPUNIT_TEST( testRemoveLeftLineEnd );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void testRemoveLeft();
  void testRemoveRight();
  
  void testRemoveLeftLineEnd();

private:
  TextModel* _text1; // LF
  TextModel* _text2; // CRLF
};

#endif // _TEXTMODEL_TESTREMOVE_H
