/* legacy-config.c generated by valac 0.42.2, the Vala compiler
 * generated from legacy-config.vala, do not modify */

/*
 * Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */
/* Compatibility with old (gnome-config) configuration files. */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "paths.h"
#include <gio/gio.h>
#include "uuid.h"

#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GSList* tg_read_files (void);
static void _g_key_file_unref0_ (gpointer var);
static inline void _g_slist_free__g_key_file_unref0_ (GSList* self);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
gchar* tg_get_value (GSList* keyfiles,
                     const gchar* group,
                     const gchar* key);
void tg_legacy_convert (GSettings* settings);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static void
_g_key_file_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL));
}


static inline void
_g_slist_free__g_key_file_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_key_file_unref0_);
}


static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}


static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}


GSList*
tg_read_files (void)
{
	GSList* result = NULL;
	GSList* names = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GSList* keyfiles = NULL;
	GSList* _tmp6_;
	GError * _inner_error_ = NULL;
	names = NULL;
	_tmp0_ = tg_get_sysconf_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome", "config-override", "telegnome", NULL);
	names = g_slist_append (names, _tmp1_);
	_tmp2_ = g_get_home_dir ();
	_tmp3_ = g_build_filename (_tmp2_, ".gnome2", "telegnome", NULL);
	names = g_slist_append (names, _tmp3_);
	_tmp4_ = tg_get_sysconf_dir ();
	_tmp5_ = g_build_filename (_tmp4_, "gnome", "config", "telegnome", NULL);
	names = g_slist_append (names, _tmp5_);
	keyfiles = NULL;
	_tmp6_ = names;
	{
		GSList* name_collection = NULL;
		GSList* name_it = NULL;
		name_collection = _tmp6_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp7_;
			gchar* name = NULL;
			_tmp7_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp7_;
			{
				GKeyFile* keyfile = NULL;
				GKeyFile* _tmp8_;
				_tmp8_ = g_key_file_new ();
				keyfile = _tmp8_;
				{
					GKeyFile* _tmp9_;
					const gchar* _tmp10_;
					GKeyFile* _tmp11_;
					_tmp9_ = keyfile;
					_tmp10_ = name;
					g_key_file_load_from_file (_tmp9_, _tmp10_, G_KEY_FILE_NONE, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch10_g_file_error;
						}
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch10_g_key_file_error;
						}
						_g_key_file_unref0 (keyfile);
						_g_free0 (name);
						(keyfiles == NULL) ? NULL : (keyfiles = (_g_slist_free__g_key_file_unref0_ (keyfiles), NULL));
						(names == NULL) ? NULL : (names = (_g_slist_free__g_free0_ (names), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp11_ = keyfile;
					keyfile = NULL;
					keyfiles = g_slist_append (keyfiles, _tmp11_);
				}
				goto __finally10;
				__catch10_g_file_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				goto __finally10;
				__catch10_g_key_file_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally10:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_key_file_unref0 (keyfile);
					_g_free0 (name);
					(keyfiles == NULL) ? NULL : (keyfiles = (_g_slist_free__g_key_file_unref0_ (keyfiles), NULL));
					(names == NULL) ? NULL : (names = (_g_slist_free__g_free0_ (names), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_key_file_unref0 (keyfile);
				_g_free0 (name);
			}
		}
	}
	result = keyfiles;
	(names == NULL) ? NULL : (names = (_g_slist_free__g_free0_ (names), NULL));
	return result;
}


gchar*
tg_get_value (GSList* keyfiles,
              const gchar* group,
              const gchar* key)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GSList* keyfile_collection = NULL;
		GSList* keyfile_it = NULL;
		keyfile_collection = keyfiles;
		for (keyfile_it = keyfile_collection; keyfile_it != NULL; keyfile_it = keyfile_it->next) {
			GKeyFile* keyfile = NULL;
			keyfile = (GKeyFile*) keyfile_it->data;
			{
				{
					gchar* _tmp0_ = NULL;
					GKeyFile* _tmp1_;
					gchar* _tmp2_;
					gchar* _tmp3_;
					_tmp1_ = keyfile;
					_tmp2_ = g_key_file_get_string (_tmp1_, group, key, &_inner_error_);
					_tmp0_ = _tmp2_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch11_g_key_file_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp3_ = _tmp0_;
					_tmp0_ = NULL;
					result = _tmp3_;
					_g_free0 (_tmp0_);
					return result;
				}
				goto __finally11;
				__catch11_g_key_file_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally11:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void
tg_legacy_convert (GSettings* settings)
{
	GSList* keyfiles = NULL;
	GSList* _tmp0_;
	gchar* val = NULL;
	gint channel_count = 0;
	gint current_channel = 0;
	GSList* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GSList* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GSList* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GSList* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GSList* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	GSList* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	GSList* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar** children = NULL;
	gint _tmp35_;
	gchar** _tmp36_;
	gint children_length1;
	gint _children_size_;
	gchar** _tmp96_;
	gint _tmp96__length1;
	g_return_if_fail (settings != NULL);
	if (g_settings_get_boolean (settings, "legacy-migration-complete")) {
		return;
	}
	_tmp0_ = tg_read_files ();
	keyfiles = _tmp0_;
	channel_count = 0;
	current_channel = -1;
	_tmp1_ = keyfiles;
	_tmp2_ = tg_get_value (_tmp1_, "Channels", "count");
	_g_free0 (val);
	val = _tmp2_;
	_tmp3_ = val;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = val;
		channel_count = atoi (_tmp4_);
	}
	_tmp5_ = keyfiles;
	_tmp6_ = tg_get_value (_tmp5_, "Default", "server");
	_g_free0 (val);
	val = _tmp6_;
	_tmp7_ = val;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = val;
		current_channel = atoi (_tmp8_);
	}
	_tmp9_ = keyfiles;
	_tmp10_ = tg_get_value (_tmp9_, "Zooming", "factor");
	_g_free0 (val);
	val = _tmp10_;
	_tmp11_ = val;
	if (_tmp11_ != NULL) {
		gint _tmp12_ = 0;
		const gchar* _tmp13_;
		_tmp13_ = val;
		if (atoi (_tmp13_) == 1) {
			_tmp12_ = 1;
		} else {
			_tmp12_ = 2;
		}
		g_settings_set_int (settings, "zoom-factor", _tmp12_);
	}
	_tmp14_ = keyfiles;
	_tmp15_ = tg_get_value (_tmp14_, "Paging", "enabled");
	_g_free0 (val);
	val = _tmp15_;
	_tmp16_ = val;
	if (_tmp16_ != NULL) {
		gboolean paging_enabled = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		gboolean _tmp22_;
		_tmp19_ = val;
		if (g_ascii_tolower (string_get (_tmp19_, (glong) 0)) == 't') {
			_tmp18_ = TRUE;
		} else {
			const gchar* _tmp20_;
			_tmp20_ = val;
			_tmp18_ = g_ascii_tolower (string_get (_tmp20_, (glong) 0)) == 'y';
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			const gchar* _tmp21_;
			_tmp21_ = val;
			_tmp17_ = atoi (_tmp21_) != 0;
		}
		if (_tmp17_) {
			paging_enabled = TRUE;
		} else {
			paging_enabled = FALSE;
		}
		_tmp22_ = paging_enabled;
		g_settings_set_boolean (settings, "paging-enabled", _tmp22_);
	}
	_tmp23_ = keyfiles;
	_tmp24_ = tg_get_value (_tmp23_, "Paging", "interval");
	_g_free0 (val);
	val = _tmp24_;
	_tmp25_ = val;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = val;
		g_settings_set_int (settings, "paging-interval", atoi (_tmp26_));
	}
	_tmp27_ = keyfiles;
	_tmp28_ = tg_get_value (_tmp27_, "Paging", "page_nr");
	_g_free0 (val);
	val = _tmp28_;
	_tmp29_ = val;
	if (_tmp29_ != NULL) {
		const gchar* _tmp30_;
		_tmp30_ = val;
		g_settings_set_int (settings, "current-page-number", atoi (_tmp30_));
	}
	_tmp31_ = keyfiles;
	_tmp32_ = tg_get_value (_tmp31_, "Paging", "subpage_nr");
	_g_free0 (val);
	val = _tmp32_;
	_tmp33_ = val;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_;
		_tmp34_ = val;
		g_settings_set_int (settings, "current-subpage-number", atoi (_tmp34_));
	}
	_tmp35_ = channel_count;
	_tmp36_ = g_new0 (gchar*, (_tmp35_ + 1) + 1);
	children = _tmp36_;
	children_length1 = _tmp35_ + 1;
	_children_size_ = children_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				gint _tmp39_;
				gint _tmp40_;
				gchar* channel_group = NULL;
				gint _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				guint8* uu = NULL;
				guint8* _tmp46_;
				gint uu_length1;
				gint _uu_size_;
				guint8* _tmp47_;
				gint _tmp47__length1;
				gchar* uuid_bytes = NULL;
				gchar* _tmp48_;
				gint uuid_bytes_length1;
				gint _uuid_bytes_size_;
				guint8* _tmp49_;
				gint _tmp49__length1;
				gchar* _tmp50_;
				gint _tmp50__length1;
				gchar* uuid = NULL;
				gchar* _tmp51_;
				gint _tmp51__length1;
				gchar* _tmp52_;
				gchar* child_path = NULL;
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar** _tmp56_;
				gint _tmp56__length1;
				gint _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				GSettings* channel_settings = NULL;
				const gchar* _tmp61_;
				GSettings* _tmp62_;
				GSList* _tmp63_;
				const gchar* _tmp64_;
				gchar* _tmp65_;
				const gchar* _tmp66_;
				GSList* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				const gchar* _tmp72_;
				GSList* _tmp75_;
				const gchar* _tmp76_;
				gchar* _tmp77_;
				const gchar* _tmp78_;
				GSList* _tmp81_;
				const gchar* _tmp82_;
				gchar* _tmp83_;
				const gchar* _tmp84_;
				GSList* _tmp87_;
				const gchar* _tmp88_;
				gchar* _tmp89_;
				const gchar* _tmp90_;
				gint _tmp93_;
				gint _tmp94_;
				if (!_tmp37_) {
					gint _tmp38_;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp37_ = FALSE;
				_tmp39_ = i;
				_tmp40_ = channel_count;
				if (!(_tmp39_ < _tmp40_)) {
					break;
				}
				_tmp41_ = i;
				_tmp42_ = g_strdup_printf ("%i", _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat ("Channel", _tmp43_, NULL);
				_tmp45_ = _tmp44_;
				_g_free0 (_tmp43_);
				channel_group = _tmp45_;
				_tmp46_ = g_new0 (guint8, 16);
				uu = _tmp46_;
				uu_length1 = 16;
				_uu_size_ = uu_length1;
				_tmp47_ = uu;
				_tmp47__length1 = uu_length1;
				uuid_generate (_tmp47_);
				_tmp48_ = g_new0 (gchar, 37);
				uuid_bytes = _tmp48_;
				uuid_bytes_length1 = 37;
				_uuid_bytes_size_ = uuid_bytes_length1;
				_tmp49_ = uu;
				_tmp49__length1 = uu_length1;
				_tmp50_ = uuid_bytes;
				_tmp50__length1 = uuid_bytes_length1;
				uuid_unparse (_tmp49_, _tmp50_);
				_tmp51_ = uuid_bytes;
				_tmp51__length1 = uuid_bytes_length1;
				_tmp52_ = g_strdup ((const gchar*) _tmp51_);
				uuid = _tmp52_;
				_tmp53_ = uuid;
				_tmp54_ = string_to_string (_tmp53_);
				_tmp55_ = g_strconcat ("/org/gnome/telegnome/channel/", _tmp54_, "/", NULL);
				child_path = _tmp55_;
				_tmp56_ = children;
				_tmp56__length1 = children_length1;
				_tmp57_ = i;
				_tmp58_ = uuid;
				_tmp59_ = g_strdup (_tmp58_);
				_g_free0 (_tmp56_[_tmp57_]);
				_tmp56_[_tmp57_] = _tmp59_;
				_tmp60_ = _tmp56_[_tmp57_];
				_tmp61_ = child_path;
				_tmp62_ = g_settings_new_with_path ("org.gnome.telegnome.channel", _tmp61_);
				channel_settings = _tmp62_;
				_tmp63_ = keyfiles;
				_tmp64_ = channel_group;
				_tmp65_ = tg_get_value (_tmp63_, _tmp64_, "name");
				_g_free0 (val);
				val = _tmp65_;
				_tmp66_ = val;
				if (_tmp66_ != NULL) {
					GSettings* _tmp67_;
					const gchar* _tmp68_;
					_tmp67_ = channel_settings;
					_tmp68_ = val;
					g_settings_set_string (_tmp67_, "name", _tmp68_);
				}
				_tmp69_ = keyfiles;
				_tmp70_ = channel_group;
				_tmp71_ = tg_get_value (_tmp69_, _tmp70_, "desc");
				_g_free0 (val);
				val = _tmp71_;
				_tmp72_ = val;
				if (_tmp72_ != NULL) {
					GSettings* _tmp73_;
					const gchar* _tmp74_;
					_tmp73_ = channel_settings;
					_tmp74_ = val;
					g_settings_set_string (_tmp73_, "description", _tmp74_);
				}
				_tmp75_ = keyfiles;
				_tmp76_ = channel_group;
				_tmp77_ = tg_get_value (_tmp75_, _tmp76_, "page_url");
				_g_free0 (val);
				val = _tmp77_;
				_tmp78_ = val;
				if (_tmp78_ != NULL) {
					GSettings* _tmp79_;
					const gchar* _tmp80_;
					_tmp79_ = channel_settings;
					_tmp80_ = val;
					g_settings_set_string (_tmp79_, "page-url", _tmp80_);
				}
				_tmp81_ = keyfiles;
				_tmp82_ = channel_group;
				_tmp83_ = tg_get_value (_tmp81_, _tmp82_, "subpage_url");
				_g_free0 (val);
				val = _tmp83_;
				_tmp84_ = val;
				if (_tmp84_ != NULL) {
					GSettings* _tmp85_;
					const gchar* _tmp86_;
					_tmp85_ = channel_settings;
					_tmp86_ = val;
					g_settings_set_string (_tmp85_, "subpage-url", _tmp86_);
				}
				_tmp87_ = keyfiles;
				_tmp88_ = channel_group;
				_tmp89_ = tg_get_value (_tmp87_, _tmp88_, "country");
				_g_free0 (val);
				val = _tmp89_;
				_tmp90_ = val;
				if (_tmp90_ != NULL) {
					GSettings* _tmp91_;
					const gchar* _tmp92_;
					_tmp91_ = channel_settings;
					_tmp92_ = val;
					g_settings_set_string (_tmp91_, "country", _tmp92_);
				}
				_tmp93_ = i;
				_tmp94_ = current_channel;
				if (_tmp93_ == _tmp94_) {
					const gchar* _tmp95_;
					_tmp95_ = uuid;
					g_settings_set_string (settings, "current-channel", _tmp95_);
				}
				_g_object_unref0 (channel_settings);
				_g_free0 (child_path);
				_g_free0 (uuid);
				uuid_bytes = (g_free (uuid_bytes), NULL);
				uu = (g_free (uu), NULL);
				_g_free0 (channel_group);
			}
		}
	}
	_tmp96_ = children;
	_tmp96__length1 = children_length1;
	g_settings_set_strv (settings, "channel-children", _tmp96_);
	g_settings_set_boolean (settings, "legacy-migration-complete", TRUE);
	g_settings_sync ();
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (val);
	(keyfiles == NULL) ? NULL : (keyfiles = (_g_slist_free__g_key_file_unref0_ (keyfiles), NULL));
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



