/*
    chart - chart compare of points progress
    Copyright (C) 2011-2012 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

	Not Y2K1 compliant, date_str is taken without century
*/

#include "header.h"


#define TOP 20
#define BOTTOM (FONT_H + 4)
#define LEFT 20
#define RIGHT 20

static void chart_import_edi(void *xxx, char *filename){
    sw_chart_load_file(gses->ontop, filename);
    sw_chart_recalc_extremes(gses->ontop);
}


int sw_chart_kbd_func(struct subwin *sw, struct event *ev, int fw){
    char *pwd;
    struct menu_item *mi = NULL;
    int max = 0, i;
    
//    if (!sdl) return 0;

    switch (kbd_action(KM_MAIN, ev)){
        case ACT_INSERT:
            pwd=getcwd(NULL, 0);
            input_field(NULL, VTEXT(T_IMPORT_EDI), VTEXT(T_FILENAME), 
                       VTEXT(T_OK), VTEXT(T_CANCEL), gses, 
                       NULL, 150, pwd, 0, 0, NULL,
                       chart_import_edi, NULL, 1);
            if (pwd) free(pwd);
            return 1;
        case ACT_DELETE:
            mi = NULL;
            for (i = 0; i < sw->chbands->len; i++){
                cba_t cba2;
                struct chband *b;
                gchar *c;

                if (!mi) mi = new_menu(3);
                if (!mi) break;

                b = (struct chband*)g_ptr_array_index(sw->chbands, i);
                c = g_strdup_printf("%-12s %-20s %-7s", b->pcall, b->tname, b->pband);
                if (strlen(c) > max) max = strlen(c);
                SETCBA(cba2, chband, b);
                add_to_menu(&mi, 
                        stracpy(c), 
                        "", "", 
                        sw_chart_delete_band, cba2, 0);    
                g_free(c);
            }
            set_window_ptr(gses->win, (term->x-6-max)/2,(term->y-2-i)/2);
            if (mi) do_menu(mi, CBA0);
            return 1;
    }
    

    
    return 0;
}


int sw_chart_mouse_func(struct subwin *sw, struct event *ev, int fw){
#ifdef HAVE_SDL
    //int lmx, lmy;

    if (!sdl) return 0;
        
    sw->mx = ev->mx - sw->x * FONT_W;
    sw->my = ev->my - sw->y * FONT_H;

//    int t = sw->mint + ((lmx - sw->ch_left) * (sw->maxt - sw->mint)) / (sw->ch_right - sw->ch_left);
//    int v = sw->minv + ((sw->ch_bottom - lmy) * (sw->maxv - sw->minv)) / (sw->ch_bottom - sw->ch_top);
    sw->gdirty = 1;
    redraw_later();
#endif
    return 0;
}



void sw_chart_redraw(struct subwin *sw, int flags){
    int x, y;
    gchar *cc;
    int i;
#ifdef HAVE_SDL
    int j, ox, ox2, oy, oy2, t, v, bt = 0, tajm;
    SDL_Rect area;
    char s[100];
    time_t now;
    struct tm utc;
    unsigned nowd, nowt;

    if (sdl){
        time(&now);
        gmtime_r(&now, &utc);
        nowd = utc.tm_mday + 100 * (utc.tm_mon + 1 + 100 * (utc.tm_year - 100)); // no century, was + 1900
        nowt = utc.tm_min + 60 * utc.tm_hour;
		bt = nowd;
        

        if (!sdl) return;
    //    dbg("sw_chart_redraw(%d) t=%d..%d v=%d..%d\n", sw->gdirty, sw->mint, sw->maxt, sw->minv, sw->maxv);
        sw->ch_top = TOP;
        sw->ch_bottom = sw->screen->h - BOTTOM;
        sprintf(s, "%dk", sw->maxv / 1000);
        sw->ch_left = LEFT + strlen(s) * FONT_W;
        sw->ch_right = sw->screen->w - RIGHT;
        if (sw->ch_top >= sw->ch_bottom) return;
        if (sw->ch_left >= sw->ch_right) return;
        if (sw->maxt <= sw->mint) return;
        if (sw->maxv <= sw->minv) return;
        
        if (flags & HTML_FOR_PHOTO){
            sw->mx = sw->ch_right;
            sw->my = sw->ch_top;
        }

        fill_area(sw->x, sw->y, sw->w, sw->h, 0);

        area.x = 0;
        area.y = 0;
        area.w = sw->screen->w;
        area.h = sw->screen->h;
        SDL_FillRect(sw->screen, &area, makecol(0, 0, 0));

        line(sw->screen, sw->ch_left, sw->ch_top, sw->ch_left, sw->ch_bottom, sdl->gr[13]);
        line(sw->screen, sw->ch_left, sw->ch_bottom, sw->ch_right, sw->ch_bottom, sdl->gr[13]);
        
        ox = -10000;
        ox2 = -10000;
        i = ((sw->mint + 59) / 60) * 60;
        for (; i <= sw->maxt; i+= 60){
            x = sw->ch_left + ( (i - sw->mint) * (sw->ch_right - sw->ch_left) ) / (sw->maxt - sw->mint);
            if (x > ox + 10){
                ox = x;
                line(sw->screen, x, sw->ch_bottom + 1, x, sw->ch_bottom + 4, sdl->gr[13]);
            }
            if (x > ox2 + FONT_W * 4){
                ox2 = x;
                sprintf(s, "%02d", (i / 60) % 24);
                fontout(sw->screen, x - FONT_W + 1, sw->ch_bottom + 4, sdl->gr[13], 0, s); 
            }
        }
        
        oy = 10000;
        oy2 = 10000;
        i = ((sw->minv + 999) / 1000) * 1000;
        for (; i <= sw->maxv; i+= 1000){
            y = sw->ch_bottom - ( (i - sw->minv) * (sw->ch_bottom - sw->ch_top) ) / (sw->maxv - sw->minv);
            if (y < oy - 10){
                oy = y;
                line(sw->screen, sw->ch_left - 1, y, sw->ch_left - 4, y, sdl->gr[13]);
            }
            if (y < oy2 - FONT_H * 2){
                oy2 = y;
                sprintf(s, "%dk", (i / 1000));
                fontout(sw->screen, sw->ch_left - 4 - strlen(s) * FONT_W, y - FONT_H / 2, sdl->gr[13], 0, s); 
            }
        }


        for (i = 0; i < sw->chbands->len; i++){
            struct chband *b = (struct chband *)g_ptr_array_index(sw->chbands, i);
            ox = sw->ch_left;
            oy = sw->ch_bottom;
            b->mouse_value = 0;
            for (j = 0; j < b->chqsos->len; j++){
                struct chqso *q = (struct chqso *)g_ptr_array_index(b->chqsos, j);
                //dbg("time=%d value=%d\n", q->time, q->value);
                x = sw->ch_left + ( (q->time - sw->mint) * (sw->ch_right - sw->ch_left) ) / (sw->maxt - sw->mint);
                y = sw->ch_bottom - ( (q->value - sw->minv) * (sw->ch_bottom - sw->ch_top) ) / (sw->maxv - sw->minv);
                if (x < sw->mx) b->mouse_value = q->value;
                line(sw->screen, ox, oy, x, oy, b->color);
                line(sw->screen, x, oy, x, y, b->color);
                ox = x;
                oy = y;
            }
            line(sw->screen, ox, oy, sw->ch_right, oy, b->color);
        }

        if (aband){ 
            ox = sw->ch_left;
            oy = sw->ch_bottom;
            v = 0;
            sw->ch_mouse_value = 0;
            for (i = 0; i < aband->qsos->len; i++){
                struct qso *q = (struct qso *)g_ptr_array_index(aband->qsos, i);

                if (i == 0) bt = atoi(q->date_str + 2);
                if (q->error || q->dupe) continue;
                tajm = atoi(q->time_str);
                t = (atoi(q->date_str + 2) - bt) * 1440 + (tajm / 100) * 60 + tajm % 100;
                v += q->qsop;
                //dbg("time=%d value=%d\n", t, v);
                x = sw->ch_left + ( (t - sw->mint) * (sw->ch_right - sw->ch_left) ) / (sw->maxt - sw->mint);
                y = sw->ch_bottom - ( (v - sw->minv) * (sw->ch_bottom - sw->ch_top) ) / (sw->maxv - sw->minv);
                if (x < sw->mx) sw->ch_mouse_value = v;
                line(sw->screen, ox, oy, x, oy, sdl->gr[15]);
                line(sw->screen, x, oy, x, y, sdl->gr[15]);
                ox = x;
                oy = y;
            }

            t = (nowd - bt) * 1440 + nowt;
			x = (int)((double)sw->ch_left + ( (t - sw->mint) * (double)(sw->ch_right - sw->ch_left) ) / (double)(sw->maxt - sw->mint));
			if (x < ox || x >= sw->screen->w) x = sw->screen->w - 1;
            line(sw->screen, ox, oy, x, oy, sdl->gr[15]);
        }

        x = sw->ch_left + 10;
        y = sw->ch_top;
        if (aband){
            cc = g_strndup(ctest->tname, 20);
            fontoutf(sw->screen, x, y, sdl->gr[13], FONT_TRANSP, "%-12s %-20s %-7s  %d pts", ctest->pcall, cc, aband->pband, sw->ch_mouse_value); 
            g_free(cc);
            y += FONT_H;
        }
        for (i = 0; i < sw->chbands->len; i++){
            struct chband *b = (struct chband *)g_ptr_array_index(sw->chbands, i);
            fontoutf(sw->screen, x, y, b->color, FONT_TRANSP, "%-12s %-20s %-7s  %d pts", b->pcall, b->tname, b->pband, b->mouse_value);
            y += FONT_H;
        }
        t = sw->mint + ((sw->mx - sw->ch_left) * (sw->maxt - sw->mint)) / (sw->ch_right - sw->ch_left);
        v = sw->minv + ((sw->ch_bottom - sw->my) * (sw->maxv - sw->minv)) / (sw->ch_bottom - sw->ch_top);
        fontoutf(sw->screen, x, y, sdl->gr[13], FONT_TRANSP, "%02d:%02d  %d pts", (t / 60) % 24, t % 60, v);
    }
    else
#endif
    {
        x = 1;
        y = 0;
        if (aband){
            cc = g_strndup(ctest->tname, 20);
            clip_printf(sw, x, y, COL_NORM, "%-12s %-20s %-7s", ctest->pcall, cc, aband->pband); 
            g_free(cc);
            y++;
        }
        for (i = 0; i < sw->chbands->len; i++){
            struct chband *b = (struct chband *)g_ptr_array_index(sw->chbands, i);
            clip_printf(sw, x, y, COL(i % 7 + 0x41), "%-12s %-20s %-7s", b->pcall, b->tname, b->pband);
            y++;
        }
    }
}


void sw_chart_check_bounds(struct subwin *sw){
#ifdef HAVE_SDL
    if (!sdl) return;
#endif
}

void sw_chart_raise(struct subwin *sw){
#ifdef HAVE_SDL
    sw->gdirty=1;      
#endif
}

void sw_chart_free_band(struct chband *b){
    int i;
    for (i = 0; i < b->chqsos->len; i++){
        struct chqso *q = (struct chqso *)g_ptr_array_index(b->chqsos, i);
        CONDGFREE(q->call);
        g_free(q);
    }
    g_ptr_array_free(b->chqsos, TRUE);
    CONDGFREE(b->pcall);
    CONDGFREE(b->pwwlo);
    CONDGFREE(b->tname);
    CONDGFREE(b->pband);
    CONDGFREE(b->filename);
    g_free(b);
}

void sw_chart_free(struct subwin *sw){
    int i;
    if (!sw->chbands) return;
    for (i = 0; i < sw->chbands->len; i++){
        struct chband *b = (struct chband*)g_ptr_array_index(sw->chbands, i);
        sw_chart_free_band(b);
    }
    g_ptr_array_free(sw->chbands, TRUE);
}

void sw_chart_delete_band(cba_t chb, cba_t unused){

	struct chband *b = (struct chband*)GETCBA(chb, chband);
    g_ptr_array_remove(gses->ontop->chbands, b);
    sw_chart_free_band(b);
    redraw_later();
}


int sw_chart_load_file(struct subwin *sw, char *filename){
    int j, v;
    struct chband *b;
    FILE *f;
    GString *gs;
    char *val;
    gchar **items;
    int firstdate = -1;
    int tajm;

//    if (!sdl) return;
    
    f = fopen(filename, "rt");
    if (!f){
        log_addf(VTEXT(T_CANT_READ_S), filename);
        return -1;
    }
    gs = g_string_sized_new(100);
    
    b = g_new0(struct chband, 1);
    g_ptr_array_add(sw->chbands, b);
    b->chqsos = g_ptr_array_new();
    b->filename = g_strdup(filename);
#ifdef HAVE_SDL
    if (sdl) b->color = sdl->termcol[(sw->chbands->len % 6) + 8];
#endif

    safe_fgets(gs, f, 0);
    while(safe_fgets(gs, f, 0) != NULL){
        if (gs->str[0]=='[') break;
        val = strchr(gs->str, '=');
        *val='\0';
        val++;
//        dbg("key='%s'\n", gs->str);
        if (strcasecmp(gs->str, "pcall")==0){
            CONDGFREE(b->pcall);
            b->pcall = g_strdup(val);
        }else if (strcasecmp(gs->str, "pwwlo")==0){
            CONDGFREE(b->pwwlo);
            b->pwwlo = g_strdup(val);
        }else if (strcasecmp(gs->str, "tname")==0){
            CONDGFREE(b->tname);
            b->tname = g_strndup(val, 20);
        }else if (strcasecmp(gs->str, "pband")==0){
            CONDGFREE(b->pband);
            b->pband = g_strndup(val, 7);
        }
    }
    while(strncasecmp(gs->str, "[qsorecords", 11)!=0){
        if (safe_fgets(gs, f, 0) == NULL) goto x;
    }
    v = 0;
    while(safe_fgets(gs, f, 0) != NULL){
        struct chqso *q;
        if (gs->str[0]=='[') break;
//        dbg("qso='%s'\n", gs->str);
        items = g_strsplit(gs->str, ";", 0);
        for (j = 0; j <= 11; j++) if (!items[j]) goto badq;

        if (firstdate < 0) firstdate = atoi(items[0]);
        if (!strcasecmp(items[2], "ERROR")) continue;

        q = g_new0(struct chqso, 1);
        q->call = g_strdup(items[2]);
        tajm = atoi(items[1]);
        q->time = (atoi(items[0]) - firstdate) * 1440 + (tajm / 100) * 60 + tajm % 100;
        q->pts = atoi(items[10]);
        v += q->pts;
        q->value = v;
        g_ptr_array_add(b->chqsos, q);
        //dbg("%d %d %d\n", q->time, q->pts, q->value);
badq:;
    }
    fclose(f);

x:;
    g_string_free(gs, TRUE);
    return 0;


/*    v = 0;
    for (i = 1400; i < 2400+1400; i += 20){
        struct chqso *q = g_new0(struct chqso, 1);
        q->time = i;
        q->value = v;
        v += rand() % 300;
        g_ptr_array_add(b->chqsos, q);
    } */
}

int sw_chart_recalc_extremes(struct subwin *sw){
#ifdef HAVE_SDL
    int i, bt = 0, t, v, j, tajm;
    
    sw->mint = 1000000000;
    sw->maxt = 0;
    sw->minv = 0;
    sw->maxv = 0;

    if (aband){
        v = 0;
        for (i = 0; i < aband->qsos->len; i++){
            struct qso *q = (struct qso *)g_ptr_array_index(aband->qsos, i);

            if (i == 0) bt = atoi(q->date_str + 2);
            if (q->error || q->dupe) continue;
            tajm = atoi(q->time_str);
            t = (atoi(q->date_str + 2) - bt) * 1440 + (tajm / 100) * 60 + tajm % 100;
            v += q->qsop;
            if (t < sw->mint) sw->mint = t;
            if (t > sw->maxt) sw->maxt = t;
            if (v < sw->minv) sw->minv = v;
            if (v > sw->maxv) sw->maxv = v;
        }
    }
    for (i = 0; i < sw->chbands->len; i++){
        struct chband *b = (struct chband *)g_ptr_array_index(sw->chbands, i);
        for (j = 0; j < b->chqsos->len; j++){
            struct chqso *q = (struct chqso *)g_ptr_array_index(b->chqsos, j);
            if (q->time < sw->mint) sw->mint = q->time;
            if (q->time > sw->maxt) sw->maxt = q->time;
            if (q->value < sw->minv) sw->minv = q->value;
            if (q->value > sw->maxv) sw->maxv = q->value;
        }
    }
#endif
    return 0;
}

int chart_reload(void){
#ifdef HAVE_SDL
    int i;
    struct subwin *sw=NULL;
    if (!sdl) return 0;
    /*dbg("maps_reload\n");*/
    
    for (i=0;i<gses->subwins->len;i++){
        sw=(struct subwin *)g_ptr_array_index(gses->subwins, i);
        if (sw->type!=SWT_CHART) continue;
        sw_chart_recalc_extremes(sw);
    }
    if (gses && gses->ontop && gses->ontop->type==SWT_CHART) sw_chart_redraw(gses->ontop, 0);
#endif
    return 0;
}


int save_chart_to_file(char *filename){
    int i, j, k;
    int ret = 0;
    struct subwin *subwin;
    struct chband *chband;
    FILE *f;

    f = fopen(filename, "wt");
    if (!f){
        log_addf(VTEXT(T_CANT_WRITE_S), filename);
        return errno;
    }

    j = 0;
    for (i = 0; i < gses->subwins->len; i++){
        subwin = (struct subwin *) g_ptr_array_index(gses->subwins, i);
        if (subwin->type != SWT_CHART) continue;
        for (k = 0; k < subwin->chbands->len; k++){
            chband = (struct chband*)g_ptr_array_index(subwin->chbands, k);
            fprintf(f, "%d;%s\r\n", j, chband->filename);
        }
        j++;
    }
    fclose(f);
    
    return ret;
}

int load_chart_from_file(gchar *filename){
    FILE *f;
    char s[402];
    struct zstring *zs;
    int i, j, k;
    char *c;
    struct subwin *subwin;

    f = fopen(filename, "rt");
    if (!f){
        return -1;
    }

    while((fgets(s, 400, f))!=NULL){
        chomp(s);

        zs = zstrdup(s);
        k = atoi(ztokenize(zs, 1));
        c = ztokenize(zs, 0);
        j = 0;
        for (i = 0; i < gses->subwins->len; i++){
            subwin = (struct subwin *) g_ptr_array_index(gses->subwins, i);
            if (subwin->type != SWT_CHART) continue;
            if (j == k){
                sw_chart_load_file(subwin, c);
            }
            j++;
        }

        zfree(zs);

    }
    fclose(f);
    g_index_array_qsort(qrvdb->qrvs, qrvdb->sort);
    return 0;
}

#define zg_ptr_array_foreach(ctrlvar, type, var, array) \
    int ctrlvar; \
    type var; \
    for (ctrlvar = 0, var = ctrlvar < (array)->len ? (type)g_ptr_array_index(array, ctrlvar) : NULL;  ctrlvar < (array)->len;  ctrlvar++, var = (type)g_ptr_array_index(array, ctrlvar))

#define zg_ptr_array_foreachback(ctrlvar, type, var, array) \
    int ctrlvar; \
    type var; \
    for (ctrlvar = array->len - 1, var = ctrlvar >= 0 ? (type)g_ptr_array_index(array, ctrlvar) : NULL;  ctrlvar >= 0;  ctrlvar--, var = (type)g_ptr_array_index(array, ctrlvar))

void chart_clear_all(){
    zg_ptr_array_foreach(i, struct subwin *, subwin, gses->subwins){
        dbg("title=%s\n", subwin->title);
        if (subwin->chbands)
        {
			zg_ptr_array_foreachback(j, struct chband*, chband, subwin->chbands)
			{
				dbg("free\n");
				sw_chart_free_band(chband);
				g_ptr_array_remove_index(subwin->chbands, j);
			}
		}
    }
    redraw_later();
}
