---------------------------------------------------------------------------------------
-- Title          : Wishbone slave core for WR Switch PPS generator and RTC
---------------------------------------------------------------------------------------
-- File           : pps_gen_wb.vhd
-- Author         : auto-generated by wbgen2 from pps_gen_wb.wb
-- Created        : Wed Aug 16 22:41:09 2017
-- Standard       : VHDL'87
---------------------------------------------------------------------------------------
-- THIS FILE WAS GENERATED BY wbgen2 FROM SOURCE FILE pps_gen_wb.wb
-- DO NOT HAND-EDIT UNLESS IT'S ABSOLUTELY NECESSARY!
---------------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity pps_gen_wb is
  port (
    rst_n_i                                  : in     std_logic;
    clk_sys_i                                : in     std_logic;
    wb_adr_i                                 : in     std_logic_vector(2 downto 0);
    wb_dat_i                                 : in     std_logic_vector(31 downto 0);
    wb_dat_o                                 : out    std_logic_vector(31 downto 0);
    wb_cyc_i                                 : in     std_logic;
    wb_sel_i                                 : in     std_logic_vector(3 downto 0);
    wb_stb_i                                 : in     std_logic;
    wb_we_i                                  : in     std_logic;
    wb_ack_o                                 : out    std_logic;
    wb_stall_o                               : out    std_logic;
    refclk_i                                 : in     std_logic;
-- Port for asynchronous (clock: refclk_i) MONOSTABLE field: 'Reset counter' in reg: 'Control Register'
    ppsg_cr_cnt_rst_o                        : out    std_logic;
-- Port for asynchronous (clock: refclk_i) BIT field: 'Enable counter' in reg: 'Control Register'
    ppsg_cr_cnt_en_o                         : out    std_logic;
-- Ports for asynchronous (clock: refclk_i) RW/RW BIT field: 'Adjust offset' in reg: 'Control Register'
    ppsg_cr_cnt_adj_o                        : out    std_logic;
    ppsg_cr_cnt_adj_i                        : in     std_logic;
    ppsg_cr_cnt_adj_load_o                   : out    std_logic;
-- Port for asynchronous (clock: refclk_i) MONOSTABLE field: 'Set time' in reg: 'Control Register'
    ppsg_cr_cnt_set_o                        : out    std_logic;
-- Port for asynchronous (clock: refclk_i) std_logic_vector field: 'PPS Pulse width' in reg: 'Control Register'
    ppsg_cr_pwidth_o                         : out    std_logic_vector(27 downto 0);
-- Port for asynchronous (clock: refclk_i) std_logic_vector field: 'Nanosecond counter' in reg: 'Nanosecond counter register'
    ppsg_cntr_nsec_i                         : in     std_logic_vector(27 downto 0);
-- Port for asynchronous (clock: refclk_i) std_logic_vector field: 'UTC Counter' in reg: 'UTC Counter register (least-significant part)'
    ppsg_cntr_utclo_i                        : in     std_logic_vector(31 downto 0);
-- Port for asynchronous (clock: refclk_i) std_logic_vector field: 'UTC Counter' in reg: 'UTC Counter register (most-significant part)'
    ppsg_cntr_utchi_i                        : in     std_logic_vector(7 downto 0);
-- Ports for PASS_THROUGH field: 'Nanosecond adjustment' in reg: 'Nanosecond adjustment register'
    ppsg_adj_nsec_o                          : out    std_logic_vector(27 downto 0);
    ppsg_adj_nsec_wr_o                       : out    std_logic;
-- Ports for PASS_THROUGH field: 'UTC Counter adjustment' in reg: 'UTC Adjustment register (least-significant part)'
    ppsg_adj_utclo_o                         : out    std_logic_vector(31 downto 0);
    ppsg_adj_utclo_wr_o                      : out    std_logic;
-- Ports for PASS_THROUGH field: 'UTC Counter adjustment' in reg: 'UTC Adjustment register (most-significant part)'
    ppsg_adj_utchi_o                         : out    std_logic_vector(7 downto 0);
    ppsg_adj_utchi_wr_o                      : out    std_logic;
-- Ports for asynchronous (clock: refclk_i) RW/RW BIT field: 'Sync to external PPS input' in reg: 'External sync control register'
    ppsg_escr_sync_o                         : out    std_logic;
    ppsg_escr_sync_i                         : in     std_logic;
    ppsg_escr_sync_load_o                    : out    std_logic;
-- Port for asynchronous (clock: refclk_i) BIT field: 'PPS unmask output' in reg: 'External sync control register'
    ppsg_escr_pps_unmask_o                   : out    std_logic;
-- Port for asynchronous (clock: refclk_i) BIT field: 'PPS output valid' in reg: 'External sync control register'
    ppsg_escr_pps_valid_o                    : out    std_logic;
-- Port for asynchronous (clock: refclk_i) BIT field: 'Timecode output(UTC+cycles) valid' in reg: 'External sync control register'
    ppsg_escr_tm_valid_o                     : out    std_logic;
-- Port for asynchronous (clock: refclk_i) MONOSTABLE field: 'Set seconds counter' in reg: 'External sync control register'
    ppsg_escr_sec_set_o                      : out    std_logic;
-- Port for asynchronous (clock: refclk_i) MONOSTABLE field: 'Set nanoseconds counter' in reg: 'External sync control register'
    ppsg_escr_nsec_set_o                     : out    std_logic
  );
end pps_gen_wb;

architecture syn of pps_gen_wb is

signal ppsg_cr_cnt_rst_int                      : std_logic      ;
signal ppsg_cr_cnt_rst_int_delay                : std_logic      ;
signal ppsg_cr_cnt_rst_sync0                    : std_logic      ;
signal ppsg_cr_cnt_rst_sync1                    : std_logic      ;
signal ppsg_cr_cnt_rst_sync2                    : std_logic      ;
signal ppsg_cr_cnt_en_int                       : std_logic      ;
signal ppsg_cr_cnt_en_sync0                     : std_logic      ;
signal ppsg_cr_cnt_en_sync1                     : std_logic      ;
signal ppsg_cr_cnt_adj_int_read                 : std_logic      ;
signal ppsg_cr_cnt_adj_int_write                : std_logic      ;
signal ppsg_cr_cnt_adj_lw                       : std_logic      ;
signal ppsg_cr_cnt_adj_lw_delay                 : std_logic      ;
signal ppsg_cr_cnt_adj_lw_read_in_progress      : std_logic      ;
signal ppsg_cr_cnt_adj_lw_s0                    : std_logic      ;
signal ppsg_cr_cnt_adj_lw_s1                    : std_logic      ;
signal ppsg_cr_cnt_adj_lw_s2                    : std_logic      ;
signal ppsg_cr_cnt_adj_rwsel                    : std_logic      ;
signal ppsg_cr_cnt_set_int                      : std_logic      ;
signal ppsg_cr_cnt_set_int_delay                : std_logic      ;
signal ppsg_cr_cnt_set_sync0                    : std_logic      ;
signal ppsg_cr_cnt_set_sync1                    : std_logic      ;
signal ppsg_cr_cnt_set_sync2                    : std_logic      ;
signal ppsg_cr_pwidth_int                       : std_logic_vector(27 downto 0);
signal ppsg_cr_pwidth_swb                       : std_logic      ;
signal ppsg_cr_pwidth_swb_delay                 : std_logic      ;
signal ppsg_cr_pwidth_swb_s0                    : std_logic      ;
signal ppsg_cr_pwidth_swb_s1                    : std_logic      ;
signal ppsg_cr_pwidth_swb_s2                    : std_logic      ;
signal ppsg_cntr_nsec_int                       : std_logic_vector(27 downto 0);
signal ppsg_cntr_nsec_lwb                       : std_logic      ;
signal ppsg_cntr_nsec_lwb_delay                 : std_logic      ;
signal ppsg_cntr_nsec_lwb_in_progress           : std_logic      ;
signal ppsg_cntr_nsec_lwb_s0                    : std_logic      ;
signal ppsg_cntr_nsec_lwb_s1                    : std_logic      ;
signal ppsg_cntr_nsec_lwb_s2                    : std_logic      ;
signal ppsg_cntr_utclo_int                      : std_logic_vector(31 downto 0);
signal ppsg_cntr_utclo_lwb                      : std_logic      ;
signal ppsg_cntr_utclo_lwb_delay                : std_logic      ;
signal ppsg_cntr_utclo_lwb_in_progress          : std_logic      ;
signal ppsg_cntr_utclo_lwb_s0                   : std_logic      ;
signal ppsg_cntr_utclo_lwb_s1                   : std_logic      ;
signal ppsg_cntr_utclo_lwb_s2                   : std_logic      ;
signal ppsg_cntr_utchi_int                      : std_logic_vector(7 downto 0);
signal ppsg_cntr_utchi_lwb                      : std_logic      ;
signal ppsg_cntr_utchi_lwb_delay                : std_logic      ;
signal ppsg_cntr_utchi_lwb_in_progress          : std_logic      ;
signal ppsg_cntr_utchi_lwb_s0                   : std_logic      ;
signal ppsg_cntr_utchi_lwb_s1                   : std_logic      ;
signal ppsg_cntr_utchi_lwb_s2                   : std_logic      ;
signal ppsg_escr_sync_int_read                  : std_logic      ;
signal ppsg_escr_sync_int_write                 : std_logic      ;
signal ppsg_escr_sync_lw                        : std_logic      ;
signal ppsg_escr_sync_lw_delay                  : std_logic      ;
signal ppsg_escr_sync_lw_read_in_progress       : std_logic      ;
signal ppsg_escr_sync_lw_s0                     : std_logic      ;
signal ppsg_escr_sync_lw_s1                     : std_logic      ;
signal ppsg_escr_sync_lw_s2                     : std_logic      ;
signal ppsg_escr_sync_rwsel                     : std_logic      ;
signal ppsg_escr_pps_unmask_int                 : std_logic      ;
signal ppsg_escr_pps_unmask_sync0               : std_logic      ;
signal ppsg_escr_pps_unmask_sync1               : std_logic      ;
signal ppsg_escr_pps_valid_int                  : std_logic      ;
signal ppsg_escr_pps_valid_sync0                : std_logic      ;
signal ppsg_escr_pps_valid_sync1                : std_logic      ;
signal ppsg_escr_tm_valid_int                   : std_logic      ;
signal ppsg_escr_tm_valid_sync0                 : std_logic      ;
signal ppsg_escr_tm_valid_sync1                 : std_logic      ;
signal ppsg_escr_sec_set_int                    : std_logic      ;
signal ppsg_escr_sec_set_int_delay              : std_logic      ;
signal ppsg_escr_sec_set_sync0                  : std_logic      ;
signal ppsg_escr_sec_set_sync1                  : std_logic      ;
signal ppsg_escr_sec_set_sync2                  : std_logic      ;
signal ppsg_escr_nsec_set_int                   : std_logic      ;
signal ppsg_escr_nsec_set_int_delay             : std_logic      ;
signal ppsg_escr_nsec_set_sync0                 : std_logic      ;
signal ppsg_escr_nsec_set_sync1                 : std_logic      ;
signal ppsg_escr_nsec_set_sync2                 : std_logic      ;
signal ack_sreg                                 : std_logic_vector(9 downto 0);
signal rddata_reg                               : std_logic_vector(31 downto 0);
signal wrdata_reg                               : std_logic_vector(31 downto 0);
signal rwaddr_reg                               : std_logic_vector(2 downto 0);
signal ack_in_progress                          : std_logic      ;

begin
-- Some internal signals assignments
  wrdata_reg <= wb_dat_i;
-- 
-- Main register bank access process.
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ack_sreg <= "0000000000";
      ack_in_progress <= '0';
      rddata_reg <= "00000000000000000000000000000000";
      ppsg_cr_cnt_rst_int <= '0';
      ppsg_cr_cnt_rst_int_delay <= '0';
      ppsg_cr_cnt_en_int <= '0';
      ppsg_cr_cnt_adj_lw <= '0';
      ppsg_cr_cnt_adj_lw_delay <= '0';
      ppsg_cr_cnt_adj_lw_read_in_progress <= '0';
      ppsg_cr_cnt_adj_rwsel <= '0';
      ppsg_cr_cnt_adj_int_write <= '0';
      ppsg_cr_cnt_set_int <= '0';
      ppsg_cr_cnt_set_int_delay <= '0';
      ppsg_cr_pwidth_int <= "0000000000000000000000000000";
      ppsg_cr_pwidth_swb <= '0';
      ppsg_cr_pwidth_swb_delay <= '0';
      ppsg_cntr_nsec_lwb <= '0';
      ppsg_cntr_nsec_lwb_delay <= '0';
      ppsg_cntr_nsec_lwb_in_progress <= '0';
      ppsg_cntr_utclo_lwb <= '0';
      ppsg_cntr_utclo_lwb_delay <= '0';
      ppsg_cntr_utclo_lwb_in_progress <= '0';
      ppsg_cntr_utchi_lwb <= '0';
      ppsg_cntr_utchi_lwb_delay <= '0';
      ppsg_cntr_utchi_lwb_in_progress <= '0';
      ppsg_adj_nsec_wr_o <= '0';
      ppsg_adj_utclo_wr_o <= '0';
      ppsg_adj_utchi_wr_o <= '0';
      ppsg_escr_sync_lw <= '0';
      ppsg_escr_sync_lw_delay <= '0';
      ppsg_escr_sync_lw_read_in_progress <= '0';
      ppsg_escr_sync_rwsel <= '0';
      ppsg_escr_sync_int_write <= '0';
      ppsg_escr_pps_unmask_int <= '0';
      ppsg_escr_pps_valid_int <= '0';
      ppsg_escr_tm_valid_int <= '0';
      ppsg_escr_sec_set_int <= '0';
      ppsg_escr_sec_set_int_delay <= '0';
      ppsg_escr_nsec_set_int <= '0';
      ppsg_escr_nsec_set_int_delay <= '0';
    elsif rising_edge(clk_sys_i) then
-- advance the ACK generator shift register
      ack_sreg(8 downto 0) <= ack_sreg(9 downto 1);
      ack_sreg(9) <= '0';
      if (ack_in_progress = '1') then
        if (ack_sreg(0) = '1') then
          ppsg_adj_nsec_wr_o <= '0';
          ppsg_adj_utclo_wr_o <= '0';
          ppsg_adj_utchi_wr_o <= '0';
          ack_in_progress <= '0';
        else
          ppsg_cr_cnt_rst_int <= ppsg_cr_cnt_rst_int_delay;
          ppsg_cr_cnt_rst_int_delay <= '0';
          ppsg_cr_cnt_adj_lw <= ppsg_cr_cnt_adj_lw_delay;
          ppsg_cr_cnt_adj_lw_delay <= '0';
          if ((ack_sreg(1) = '1') and (ppsg_cr_cnt_adj_lw_read_in_progress = '1')) then
            rddata_reg(2) <= ppsg_cr_cnt_adj_int_read;
            ppsg_cr_cnt_adj_lw_read_in_progress <= '0';
          end if;
          ppsg_cr_cnt_set_int <= ppsg_cr_cnt_set_int_delay;
          ppsg_cr_cnt_set_int_delay <= '0';
          ppsg_cr_pwidth_swb <= ppsg_cr_pwidth_swb_delay;
          ppsg_cr_pwidth_swb_delay <= '0';
          ppsg_cntr_nsec_lwb <= ppsg_cntr_nsec_lwb_delay;
          ppsg_cntr_nsec_lwb_delay <= '0';
          if ((ack_sreg(1) = '1') and (ppsg_cntr_nsec_lwb_in_progress = '1')) then
            rddata_reg(27 downto 0) <= ppsg_cntr_nsec_int;
            ppsg_cntr_nsec_lwb_in_progress <= '0';
          end if;
          ppsg_cntr_utclo_lwb <= ppsg_cntr_utclo_lwb_delay;
          ppsg_cntr_utclo_lwb_delay <= '0';
          if ((ack_sreg(1) = '1') and (ppsg_cntr_utclo_lwb_in_progress = '1')) then
            rddata_reg(31 downto 0) <= ppsg_cntr_utclo_int;
            ppsg_cntr_utclo_lwb_in_progress <= '0';
          end if;
          ppsg_cntr_utchi_lwb <= ppsg_cntr_utchi_lwb_delay;
          ppsg_cntr_utchi_lwb_delay <= '0';
          if ((ack_sreg(1) = '1') and (ppsg_cntr_utchi_lwb_in_progress = '1')) then
            rddata_reg(7 downto 0) <= ppsg_cntr_utchi_int;
            ppsg_cntr_utchi_lwb_in_progress <= '0';
          end if;
          ppsg_adj_nsec_wr_o <= '0';
          ppsg_adj_utclo_wr_o <= '0';
          ppsg_adj_utchi_wr_o <= '0';
          ppsg_escr_sync_lw <= ppsg_escr_sync_lw_delay;
          ppsg_escr_sync_lw_delay <= '0';
          if ((ack_sreg(1) = '1') and (ppsg_escr_sync_lw_read_in_progress = '1')) then
            rddata_reg(0) <= ppsg_escr_sync_int_read;
            ppsg_escr_sync_lw_read_in_progress <= '0';
          end if;
          ppsg_escr_sec_set_int <= ppsg_escr_sec_set_int_delay;
          ppsg_escr_sec_set_int_delay <= '0';
          ppsg_escr_nsec_set_int <= ppsg_escr_nsec_set_int_delay;
          ppsg_escr_nsec_set_int_delay <= '0';
        end if;
      else
        if ((wb_cyc_i = '1') and (wb_stb_i = '1')) then
          case rwaddr_reg(2 downto 0) is
          when "000" => 
            if (wb_we_i = '1') then
              ppsg_cr_cnt_rst_int <= wrdata_reg(0);
              ppsg_cr_cnt_rst_int_delay <= wrdata_reg(0);
              ppsg_cr_cnt_en_int <= wrdata_reg(1);
              ppsg_cr_cnt_adj_int_write <= wrdata_reg(2);
              ppsg_cr_cnt_adj_lw <= '1';
              ppsg_cr_cnt_adj_lw_delay <= '1';
              ppsg_cr_cnt_adj_lw_read_in_progress <= '0';
              ppsg_cr_cnt_adj_rwsel <= '1';
              ppsg_cr_cnt_set_int <= wrdata_reg(3);
              ppsg_cr_cnt_set_int_delay <= wrdata_reg(3);
              ppsg_cr_pwidth_int <= wrdata_reg(31 downto 4);
              ppsg_cr_pwidth_swb <= '1';
              ppsg_cr_pwidth_swb_delay <= '1';
            end if;
            rddata_reg(0) <= '0';
            rddata_reg(1) <= ppsg_cr_cnt_en_int;
            if (wb_we_i = '0') then
              rddata_reg(2) <= 'X';
              ppsg_cr_cnt_adj_lw <= '1';
              ppsg_cr_cnt_adj_lw_delay <= '1';
              ppsg_cr_cnt_adj_lw_read_in_progress <= '1';
              ppsg_cr_cnt_adj_rwsel <= '0';
            end if;
            rddata_reg(3) <= '0';
            rddata_reg(31 downto 4) <= ppsg_cr_pwidth_int;
            ack_sreg(5) <= '1';
            ack_in_progress <= '1';
          when "001" => 
            if (wb_we_i = '1') then
            end if;
            if (wb_we_i = '0') then
              ppsg_cntr_nsec_lwb <= '1';
              ppsg_cntr_nsec_lwb_delay <= '1';
              ppsg_cntr_nsec_lwb_in_progress <= '1';
            end if;
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(5) <= '1';
            ack_in_progress <= '1';
          when "010" => 
            if (wb_we_i = '1') then
            end if;
            if (wb_we_i = '0') then
              ppsg_cntr_utclo_lwb <= '1';
              ppsg_cntr_utclo_lwb_delay <= '1';
              ppsg_cntr_utclo_lwb_in_progress <= '1';
            end if;
            ack_sreg(5) <= '1';
            ack_in_progress <= '1';
          when "011" => 
            if (wb_we_i = '1') then
            end if;
            if (wb_we_i = '0') then
              ppsg_cntr_utchi_lwb <= '1';
              ppsg_cntr_utchi_lwb_delay <= '1';
              ppsg_cntr_utchi_lwb_in_progress <= '1';
            end if;
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(5) <= '1';
            ack_in_progress <= '1';
          when "100" => 
            if (wb_we_i = '1') then
              ppsg_adj_nsec_wr_o <= '1';
            end if;
            rddata_reg(0) <= 'X';
            rddata_reg(1) <= 'X';
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "101" => 
            if (wb_we_i = '1') then
              ppsg_adj_utclo_wr_o <= '1';
            end if;
            rddata_reg(0) <= 'X';
            rddata_reg(1) <= 'X';
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "110" => 
            if (wb_we_i = '1') then
              ppsg_adj_utchi_wr_o <= '1';
            end if;
            rddata_reg(0) <= 'X';
            rddata_reg(1) <= 'X';
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "111" => 
            if (wb_we_i = '1') then
              ppsg_escr_sync_int_write <= wrdata_reg(0);
              ppsg_escr_sync_lw <= '1';
              ppsg_escr_sync_lw_delay <= '1';
              ppsg_escr_sync_lw_read_in_progress <= '0';
              ppsg_escr_sync_rwsel <= '1';
              ppsg_escr_pps_unmask_int <= wrdata_reg(1);
              ppsg_escr_pps_valid_int <= wrdata_reg(2);
              ppsg_escr_tm_valid_int <= wrdata_reg(3);
              ppsg_escr_sec_set_int <= wrdata_reg(4);
              ppsg_escr_sec_set_int_delay <= wrdata_reg(4);
              ppsg_escr_nsec_set_int <= wrdata_reg(5);
              ppsg_escr_nsec_set_int_delay <= wrdata_reg(5);
            end if;
            if (wb_we_i = '0') then
              rddata_reg(0) <= 'X';
              ppsg_escr_sync_lw <= '1';
              ppsg_escr_sync_lw_delay <= '1';
              ppsg_escr_sync_lw_read_in_progress <= '1';
              ppsg_escr_sync_rwsel <= '0';
            end if;
            rddata_reg(1) <= ppsg_escr_pps_unmask_int;
            rddata_reg(2) <= ppsg_escr_pps_valid_int;
            rddata_reg(3) <= ppsg_escr_tm_valid_int;
            rddata_reg(4) <= '0';
            rddata_reg(5) <= '0';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(5) <= '1';
            ack_in_progress <= '1';
          when others =>
-- prevent the slave from hanging the bus on invalid address
            ack_in_progress <= '1';
            ack_sreg(0) <= '1';
          end case;
        end if;
      end if;
    end if;
  end process;
  
  
-- Drive the data output bus
  wb_dat_o <= rddata_reg;
-- Reset counter
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cr_cnt_rst_o <= '0';
      ppsg_cr_cnt_rst_sync0 <= '0';
      ppsg_cr_cnt_rst_sync1 <= '0';
      ppsg_cr_cnt_rst_sync2 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_cr_cnt_rst_sync0 <= ppsg_cr_cnt_rst_int;
      ppsg_cr_cnt_rst_sync1 <= ppsg_cr_cnt_rst_sync0;
      ppsg_cr_cnt_rst_sync2 <= ppsg_cr_cnt_rst_sync1;
      ppsg_cr_cnt_rst_o <= ppsg_cr_cnt_rst_sync2 and (not ppsg_cr_cnt_rst_sync1);
    end if;
  end process;
  
  
-- Enable counter
-- synchronizer chain for field : Enable counter (type RW/RO, clk_sys_i <-> refclk_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cr_cnt_en_o <= '0';
      ppsg_cr_cnt_en_sync0 <= '0';
      ppsg_cr_cnt_en_sync1 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_cr_cnt_en_sync0 <= ppsg_cr_cnt_en_int;
      ppsg_cr_cnt_en_sync1 <= ppsg_cr_cnt_en_sync0;
      ppsg_cr_cnt_en_o <= ppsg_cr_cnt_en_sync1;
    end if;
  end process;
  
  
-- Adjust offset
-- asynchronous BIT register : Adjust offset (type RW/WO, refclk_i <-> clk_sys_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cr_cnt_adj_lw_s0 <= '0';
      ppsg_cr_cnt_adj_lw_s1 <= '0';
      ppsg_cr_cnt_adj_lw_s2 <= '0';
      ppsg_cr_cnt_adj_int_read <= '0';
      ppsg_cr_cnt_adj_load_o <= '0';
      ppsg_cr_cnt_adj_o <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_cr_cnt_adj_lw_s0 <= ppsg_cr_cnt_adj_lw;
      ppsg_cr_cnt_adj_lw_s1 <= ppsg_cr_cnt_adj_lw_s0;
      ppsg_cr_cnt_adj_lw_s2 <= ppsg_cr_cnt_adj_lw_s1;
      if ((ppsg_cr_cnt_adj_lw_s2 = '0') and (ppsg_cr_cnt_adj_lw_s1 = '1')) then
        if (ppsg_cr_cnt_adj_rwsel = '1') then
          ppsg_cr_cnt_adj_o <= ppsg_cr_cnt_adj_int_write;
          ppsg_cr_cnt_adj_load_o <= '1';
        else
          ppsg_cr_cnt_adj_load_o <= '0';
          ppsg_cr_cnt_adj_int_read <= ppsg_cr_cnt_adj_i;
        end if;
      else
        ppsg_cr_cnt_adj_load_o <= '0';
      end if;
    end if;
  end process;
  
  
-- Set time
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cr_cnt_set_o <= '0';
      ppsg_cr_cnt_set_sync0 <= '0';
      ppsg_cr_cnt_set_sync1 <= '0';
      ppsg_cr_cnt_set_sync2 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_cr_cnt_set_sync0 <= ppsg_cr_cnt_set_int;
      ppsg_cr_cnt_set_sync1 <= ppsg_cr_cnt_set_sync0;
      ppsg_cr_cnt_set_sync2 <= ppsg_cr_cnt_set_sync1;
      ppsg_cr_cnt_set_o <= ppsg_cr_cnt_set_sync2 and (not ppsg_cr_cnt_set_sync1);
    end if;
  end process;
  
  
-- PPS Pulse width
-- asynchronous std_logic_vector register : PPS Pulse width (type RW/RO, refclk_i <-> clk_sys_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cr_pwidth_swb_s0 <= '0';
      ppsg_cr_pwidth_swb_s1 <= '0';
      ppsg_cr_pwidth_swb_s2 <= '0';
      ppsg_cr_pwidth_o <= "0000000000000000000000000000";
    elsif rising_edge(refclk_i) then
      ppsg_cr_pwidth_swb_s0 <= ppsg_cr_pwidth_swb;
      ppsg_cr_pwidth_swb_s1 <= ppsg_cr_pwidth_swb_s0;
      ppsg_cr_pwidth_swb_s2 <= ppsg_cr_pwidth_swb_s1;
      if ((ppsg_cr_pwidth_swb_s2 = '0') and (ppsg_cr_pwidth_swb_s1 = '1')) then
        ppsg_cr_pwidth_o <= ppsg_cr_pwidth_int;
      end if;
    end if;
  end process;
  
  
-- Nanosecond counter
-- asynchronous std_logic_vector register : Nanosecond counter (type RO/WO, refclk_i <-> clk_sys_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cntr_nsec_lwb_s0 <= '0';
      ppsg_cntr_nsec_lwb_s1 <= '0';
      ppsg_cntr_nsec_lwb_s2 <= '0';
      ppsg_cntr_nsec_int <= "0000000000000000000000000000";
    elsif rising_edge(refclk_i) then
      ppsg_cntr_nsec_lwb_s0 <= ppsg_cntr_nsec_lwb;
      ppsg_cntr_nsec_lwb_s1 <= ppsg_cntr_nsec_lwb_s0;
      ppsg_cntr_nsec_lwb_s2 <= ppsg_cntr_nsec_lwb_s1;
      if ((ppsg_cntr_nsec_lwb_s1 = '1') and (ppsg_cntr_nsec_lwb_s2 = '0')) then
        ppsg_cntr_nsec_int <= ppsg_cntr_nsec_i;
      end if;
    end if;
  end process;
  
  
-- UTC Counter
-- asynchronous std_logic_vector register : UTC Counter (type RO/WO, refclk_i <-> clk_sys_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cntr_utclo_lwb_s0 <= '0';
      ppsg_cntr_utclo_lwb_s1 <= '0';
      ppsg_cntr_utclo_lwb_s2 <= '0';
      ppsg_cntr_utclo_int <= "00000000000000000000000000000000";
    elsif rising_edge(refclk_i) then
      ppsg_cntr_utclo_lwb_s0 <= ppsg_cntr_utclo_lwb;
      ppsg_cntr_utclo_lwb_s1 <= ppsg_cntr_utclo_lwb_s0;
      ppsg_cntr_utclo_lwb_s2 <= ppsg_cntr_utclo_lwb_s1;
      if ((ppsg_cntr_utclo_lwb_s1 = '1') and (ppsg_cntr_utclo_lwb_s2 = '0')) then
        ppsg_cntr_utclo_int <= ppsg_cntr_utclo_i;
      end if;
    end if;
  end process;
  
  
-- UTC Counter
-- asynchronous std_logic_vector register : UTC Counter (type RO/WO, refclk_i <-> clk_sys_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_cntr_utchi_lwb_s0 <= '0';
      ppsg_cntr_utchi_lwb_s1 <= '0';
      ppsg_cntr_utchi_lwb_s2 <= '0';
      ppsg_cntr_utchi_int <= "00000000";
    elsif rising_edge(refclk_i) then
      ppsg_cntr_utchi_lwb_s0 <= ppsg_cntr_utchi_lwb;
      ppsg_cntr_utchi_lwb_s1 <= ppsg_cntr_utchi_lwb_s0;
      ppsg_cntr_utchi_lwb_s2 <= ppsg_cntr_utchi_lwb_s1;
      if ((ppsg_cntr_utchi_lwb_s1 = '1') and (ppsg_cntr_utchi_lwb_s2 = '0')) then
        ppsg_cntr_utchi_int <= ppsg_cntr_utchi_i;
      end if;
    end if;
  end process;
  
  
-- Nanosecond adjustment
-- pass-through field: Nanosecond adjustment in register: Nanosecond adjustment register
  ppsg_adj_nsec_o <= wrdata_reg(27 downto 0);
-- UTC Counter adjustment
-- pass-through field: UTC Counter adjustment in register: UTC Adjustment register (least-significant part)
  ppsg_adj_utclo_o <= wrdata_reg(31 downto 0);
-- UTC Counter adjustment
-- pass-through field: UTC Counter adjustment in register: UTC Adjustment register (most-significant part)
  ppsg_adj_utchi_o <= wrdata_reg(7 downto 0);
-- Sync to external PPS input
-- asynchronous BIT register : Sync to external PPS input (type RW/WO, refclk_i <-> clk_sys_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_escr_sync_lw_s0 <= '0';
      ppsg_escr_sync_lw_s1 <= '0';
      ppsg_escr_sync_lw_s2 <= '0';
      ppsg_escr_sync_int_read <= '0';
      ppsg_escr_sync_load_o <= '0';
      ppsg_escr_sync_o <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_escr_sync_lw_s0 <= ppsg_escr_sync_lw;
      ppsg_escr_sync_lw_s1 <= ppsg_escr_sync_lw_s0;
      ppsg_escr_sync_lw_s2 <= ppsg_escr_sync_lw_s1;
      if ((ppsg_escr_sync_lw_s2 = '0') and (ppsg_escr_sync_lw_s1 = '1')) then
        if (ppsg_escr_sync_rwsel = '1') then
          ppsg_escr_sync_o <= ppsg_escr_sync_int_write;
          ppsg_escr_sync_load_o <= '1';
        else
          ppsg_escr_sync_load_o <= '0';
          ppsg_escr_sync_int_read <= ppsg_escr_sync_i;
        end if;
      else
        ppsg_escr_sync_load_o <= '0';
      end if;
    end if;
  end process;
  
  
-- PPS unmask output
-- synchronizer chain for field : PPS unmask output (type RW/RO, clk_sys_i <-> refclk_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_escr_pps_unmask_o <= '0';
      ppsg_escr_pps_unmask_sync0 <= '0';
      ppsg_escr_pps_unmask_sync1 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_escr_pps_unmask_sync0 <= ppsg_escr_pps_unmask_int;
      ppsg_escr_pps_unmask_sync1 <= ppsg_escr_pps_unmask_sync0;
      ppsg_escr_pps_unmask_o <= ppsg_escr_pps_unmask_sync1;
    end if;
  end process;
  
  
-- PPS output valid
-- synchronizer chain for field : PPS output valid (type RW/RO, clk_sys_i <-> refclk_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_escr_pps_valid_o <= '0';
      ppsg_escr_pps_valid_sync0 <= '0';
      ppsg_escr_pps_valid_sync1 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_escr_pps_valid_sync0 <= ppsg_escr_pps_valid_int;
      ppsg_escr_pps_valid_sync1 <= ppsg_escr_pps_valid_sync0;
      ppsg_escr_pps_valid_o <= ppsg_escr_pps_valid_sync1;
    end if;
  end process;
  
  
-- Timecode output(UTC+cycles) valid
-- synchronizer chain for field : Timecode output(UTC+cycles) valid (type RW/RO, clk_sys_i <-> refclk_i)
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_escr_tm_valid_o <= '0';
      ppsg_escr_tm_valid_sync0 <= '0';
      ppsg_escr_tm_valid_sync1 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_escr_tm_valid_sync0 <= ppsg_escr_tm_valid_int;
      ppsg_escr_tm_valid_sync1 <= ppsg_escr_tm_valid_sync0;
      ppsg_escr_tm_valid_o <= ppsg_escr_tm_valid_sync1;
    end if;
  end process;
  
  
-- Set seconds counter
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_escr_sec_set_o <= '0';
      ppsg_escr_sec_set_sync0 <= '0';
      ppsg_escr_sec_set_sync1 <= '0';
      ppsg_escr_sec_set_sync2 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_escr_sec_set_sync0 <= ppsg_escr_sec_set_int;
      ppsg_escr_sec_set_sync1 <= ppsg_escr_sec_set_sync0;
      ppsg_escr_sec_set_sync2 <= ppsg_escr_sec_set_sync1;
      ppsg_escr_sec_set_o <= ppsg_escr_sec_set_sync2 and (not ppsg_escr_sec_set_sync1);
    end if;
  end process;
  
  
-- Set nanoseconds counter
  process (refclk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ppsg_escr_nsec_set_o <= '0';
      ppsg_escr_nsec_set_sync0 <= '0';
      ppsg_escr_nsec_set_sync1 <= '0';
      ppsg_escr_nsec_set_sync2 <= '0';
    elsif rising_edge(refclk_i) then
      ppsg_escr_nsec_set_sync0 <= ppsg_escr_nsec_set_int;
      ppsg_escr_nsec_set_sync1 <= ppsg_escr_nsec_set_sync0;
      ppsg_escr_nsec_set_sync2 <= ppsg_escr_nsec_set_sync1;
      ppsg_escr_nsec_set_o <= ppsg_escr_nsec_set_sync2 and (not ppsg_escr_nsec_set_sync1);
    end if;
  end process;
  
  
  rwaddr_reg <= wb_adr_i;
  wb_stall_o <= (not ack_sreg(0)) and (wb_stb_i and wb_cyc_i);
-- ACK signal generation. Just pass the LSB of ACK counter.
  wb_ack_o <= ack_sreg(0);
end syn;
