/* valagdbusmodule.c generated by valac, the Vala compiler
 * generated from valagdbusmodule.vala, do not modify */

/* valagdbusmodule.vala
 *
 * Copyright (C) 2010-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

static gpointer vala_gd_bus_module_parent_class = NULL;

static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* edomain);
static gboolean vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self,
                                                ValaDataType* type);
static ValaCCodeExpression* vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self,
                                                             ValaDataType* type,
                                                             ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self,
                                                                     ValaDataType* type,
                                                                     ValaCCodeExpression* expr);
static ValaCCodeExpression* vala_gd_bus_module_get_method_info (ValaGDBusModule* self,
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_signal_info (ValaGDBusModule* self,
                                                         ValaObjectTypeSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_get_property_info (ValaGDBusModule* self,
                                                           ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self,
                                                ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base,
                                          ValaClass* cl);
static void vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self,
                                                  ValaObjectTypeSymbol* sym);
static void vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base,
                                              ValaInterface* iface);
static GType vala_gd_bus_module_get_type_once (void);

gchar*
vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol)
{
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	result = _tmp0_;
	return result;
}

gchar*
vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol)
{
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) symbol, "DBus", "name", NULL);
	dbus_name = _tmp0_;
	_tmp1_ = dbus_name;
	if (_tmp1_ != NULL) {
		result = dbus_name;
		return result;
	}
	_tmp2_ = vala_symbol_get_name (symbol);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_lower_case_to_camel_case (_tmp3_);
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}

gint
vala_gd_bus_module_get_dbus_timeout_for_member (ValaSymbol* symbol)
{
	gint result = 0;
	g_return_val_if_fail (symbol != NULL, 0);
	result = vala_code_node_get_attribute_integer ((ValaCodeNode*) symbol, "DBus", "timeout", -1);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

gboolean
vala_gd_bus_module_is_dbus_visible (ValaCodeNode* node)
{
	ValaAttribute* dbus_attribute = NULL;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaAttribute* _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute (node, "DBus");
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	dbus_attribute = _tmp1_;
	_tmp4_ = dbus_attribute;
	if (_tmp4_ != NULL) {
		ValaAttribute* _tmp5_;
		_tmp5_ = dbus_attribute;
		_tmp3_ = vala_attribute_has_argument (_tmp5_, "visible");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaAttribute* _tmp6_;
		_tmp6_ = dbus_attribute;
		_tmp2_ = !vala_attribute_get_bool (_tmp6_, "visible", FALSE);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		_vala_code_node_unref0 (dbus_attribute);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (dbus_attribute);
	return result;
}

gboolean
vala_gd_bus_module_is_dbus_no_reply (ValaMethod* m)
{
	gboolean result = FALSE;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "no_reply", FALSE);
	return result;
}

gchar*
vala_gd_bus_module_dbus_result_name (ValaMethod* m)
{
	gchar* dbus_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) m, "DBus", "result", NULL);
	dbus_name = _tmp0_;
	_tmp2_ = dbus_name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = dbus_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = dbus_name;
		return result;
	}
	_tmp4_ = g_strdup ("result");
	result = _tmp4_;
	_g_free0 (dbus_name);
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* edomain)
{
	ValaGDBusModule * self;
	gchar* edomain_dbus_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaCCodeFile* _tmp2_;
	ValaCCodeFile* _tmp3_;
	ValaCCodeInitializerList* error_entries = NULL;
	ValaCCodeInitializerList* _tmp6_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp41_;
	ValaCCodeDeclaration* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	ValaCCodeInitializerList* _tmp47_;
	ValaCCodeVariableDeclarator* _tmp48_;
	ValaCCodeVariableDeclarator* _tmp49_;
	ValaCCodeDeclaration* _tmp50_;
	ValaCCodeFile* _tmp51_;
	ValaCCodeDeclaration* _tmp52_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp57_;
	ValaDataType* _tmp58_;
	ValaTypeSymbol* _tmp59_;
	ValaTypeSymbol* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeFunction* _tmp65_;
	gchar* quark_name = NULL;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunction* _tmp71_;
	const gchar* _tmp72_;
	ValaCCodeConstant* _tmp73_;
	ValaCCodeConstant* _tmp74_;
	ValaCCodeVariableDeclarator* _tmp75_;
	ValaCCodeVariableDeclarator* _tmp76_;
	ValaCCodeFunctionCall* register_call = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	ValaCCodeConstant* _tmp88_;
	ValaCCodeConstant* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	const gchar* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeUnaryExpression* _tmp94_;
	ValaCCodeUnaryExpression* _tmp95_;
	ValaCCodeFunctionCall* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* nentries = NULL;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeFunctionCall* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeIdentifier* _tmp113_;
	ValaCCodeFunctionCall* _tmp114_;
	ValaCCodeFunctionCall* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeFunction* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	const gchar* _tmp121_;
	ValaCCodeIdentifier* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeCastExpression* _tmp124_;
	ValaCCodeCastExpression* _tmp125_;
	ValaCCodeFile* _tmp126_;
	ValaCCodeFunction* _tmp127_;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) edomain);
	edomain_dbus_name = _tmp0_;
	_tmp1_ = edomain_dbus_name;
	if (_tmp1_ == NULL) {
		VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_error_domain ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), edomain);
		_g_free0 (edomain_dbus_name);
		return;
	}
	_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp2_, "gio/gio.h", FALSE);
	_tmp3_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp3_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp4_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp4_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp5_;
		_tmp5_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp5_);
	}
	_tmp6_ = vala_ccode_initializer_list_new ();
	error_entries = _tmp6_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		gint _ecode_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _ecode_index = 0;
		_tmp7_ = vala_error_domain_get_codes (edomain);
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_ecode_list = _tmp8_;
		_tmp9_ = _ecode_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_ecode_size = _tmp11_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			gchar* ecode_dbus_name = NULL;
			ValaErrorCode* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			ValaCCodeInitializerList* error_entry = NULL;
			ValaCCodeInitializerList* _tmp25_;
			ValaCCodeInitializerList* _tmp26_;
			ValaErrorCode* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			ValaCCodeIdentifier* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeInitializerList* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			ValaCCodeConstant* _tmp37_;
			ValaCCodeConstant* _tmp38_;
			ValaCCodeInitializerList* _tmp39_;
			ValaCCodeInitializerList* _tmp40_;
			_ecode_index = _ecode_index + 1;
			_tmp12_ = _ecode_index;
			_tmp13_ = _ecode_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _ecode_list;
			_tmp15_ = vala_list_get (_tmp14_, _ecode_index);
			ecode = (ValaErrorCode*) _tmp15_;
			_tmp16_ = ecode;
			_tmp17_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) _tmp16_);
			ecode_dbus_name = _tmp17_;
			_tmp18_ = ecode_dbus_name;
			if (_tmp18_ == NULL) {
				ValaErrorCode* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp19_ = ecode;
				_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_ascii_strdown (_tmp21_, (gssize) -1);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_lower_case_to_camel_case (_tmp23_);
				_g_free0 (ecode_dbus_name);
				ecode_dbus_name = _tmp24_;
				_g_free0 (_tmp23_);
			}
			_tmp25_ = vala_ccode_initializer_list_new ();
			error_entry = _tmp25_;
			_tmp26_ = error_entry;
			_tmp27_ = ecode;
			_tmp28_ = vala_get_ccode_name ((ValaCodeNode*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_ccode_identifier_new (_tmp29_);
			_tmp31_ = _tmp30_;
			vala_ccode_initializer_list_append (_tmp26_, (ValaCCodeExpression*) _tmp31_);
			_vala_ccode_node_unref0 (_tmp31_);
			_g_free0 (_tmp29_);
			_tmp32_ = error_entry;
			_tmp33_ = edomain_dbus_name;
			_tmp34_ = ecode_dbus_name;
			_tmp35_ = g_strdup_printf ("\"%s.%s\"", _tmp33_, _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_ccode_constant_new (_tmp36_);
			_tmp38_ = _tmp37_;
			vala_ccode_initializer_list_append (_tmp32_, (ValaCCodeExpression*) _tmp38_);
			_vala_ccode_node_unref0 (_tmp38_);
			_g_free0 (_tmp36_);
			_tmp39_ = error_entries;
			_tmp40_ = error_entry;
			vala_ccode_initializer_list_append (_tmp39_, (ValaCCodeExpression*) _tmp40_);
			_vala_ccode_node_unref0 (error_entry);
			_g_free0 (ecode_dbus_name);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp41_ = vala_ccode_declaration_new ("const GDBusErrorEntry");
	_cdecl_ = _tmp41_;
	_tmp42_ = _cdecl_;
	_tmp43_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strconcat (_tmp44_, "_entries[]", NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = error_entries;
	_tmp48_ = vala_ccode_variable_declarator_new (_tmp46_, (ValaCCodeExpression*) _tmp47_, NULL);
	_tmp49_ = _tmp48_;
	vala_ccode_declaration_add_declarator (_tmp42_, (ValaCCodeDeclarator*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp44_);
	_tmp50_ = _cdecl_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp50_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp51_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp52_ = _cdecl_;
	vala_ccode_file_add_constant_declaration (_tmp51_, (ValaCCodeNode*) _tmp52_);
	_tmp53_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp54_ = _tmp53_;
	_tmp55_ = g_strconcat (_tmp54_, "quark", NULL);
	_tmp56_ = _tmp55_;
	_g_free0 (_tmp54_);
	quark_fun_name = _tmp56_;
	_tmp57_ = quark_fun_name;
	_tmp58_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp59_ = vala_data_type_get_type_symbol (_tmp58_);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_get_ccode_name ((ValaCodeNode*) _tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_ccode_function_new (_tmp57_, _tmp62_);
	_tmp64_ = _tmp63_;
	_g_free0 (_tmp62_);
	cquark_fun = _tmp64_;
	_tmp65_ = cquark_fun;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp65_);
	_tmp66_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp67_ = _tmp66_;
	_tmp68_ = g_strdup_printf ("%squark_volatile", _tmp67_);
	_tmp69_ = _tmp68_;
	_g_free0 (_tmp67_);
	quark_name = _tmp69_;
	_tmp70_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp71_ = _tmp70_;
	_tmp72_ = quark_name;
	_tmp73_ = vala_ccode_constant_new ("0");
	_tmp74_ = _tmp73_;
	_tmp75_ = vala_ccode_variable_declarator_new (_tmp72_, (ValaCCodeExpression*) _tmp74_, NULL);
	_tmp76_ = _tmp75_;
	vala_ccode_function_add_declaration (_tmp71_, "gsize", (ValaCCodeDeclarator*) _tmp76_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
	_vala_ccode_node_unref0 (_tmp76_);
	_vala_ccode_node_unref0 (_tmp74_);
	_tmp77_ = vala_ccode_identifier_new ("g_dbus_error_register_error_domain");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	register_call = _tmp80_;
	_tmp81_ = register_call;
	_tmp82_ = vala_get_ccode_quark_name (edomain);
	_tmp83_ = _tmp82_;
	_tmp84_ = g_strconcat ("\"", _tmp83_, NULL);
	_tmp85_ = _tmp84_;
	_tmp86_ = g_strconcat (_tmp85_, "\"", NULL);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_ccode_constant_new (_tmp87_);
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_g_free0 (_tmp87_);
	_g_free0 (_tmp85_);
	_g_free0 (_tmp83_);
	_tmp90_ = register_call;
	_tmp91_ = quark_name;
	_tmp92_ = vala_ccode_identifier_new (_tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp93_);
	_tmp95_ = _tmp94_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp95_);
	_vala_ccode_node_unref0 (_tmp95_);
	_vala_ccode_node_unref0 (_tmp93_);
	_tmp96_ = register_call;
	_tmp97_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp98_ = _tmp97_;
	_tmp99_ = g_strconcat (_tmp98_, "_entries", NULL);
	_tmp100_ = _tmp99_;
	_tmp101_ = vala_ccode_identifier_new (_tmp100_);
	_tmp102_ = _tmp101_;
	vala_ccode_function_call_add_argument (_tmp96_, (ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (_tmp102_);
	_g_free0 (_tmp100_);
	_g_free0 (_tmp98_);
	_tmp103_ = vala_ccode_identifier_new ("G_N_ELEMENTS");
	_tmp104_ = _tmp103_;
	_tmp105_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp104_);
	_tmp106_ = _tmp105_;
	_vala_ccode_node_unref0 (_tmp104_);
	nentries = _tmp106_;
	_tmp107_ = nentries;
	_tmp108_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp109_ = _tmp108_;
	_tmp110_ = g_strconcat (_tmp109_, "_entries", NULL);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_ccode_identifier_new (_tmp111_);
	_tmp113_ = _tmp112_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp113_);
	_vala_ccode_node_unref0 (_tmp113_);
	_g_free0 (_tmp111_);
	_g_free0 (_tmp109_);
	_tmp114_ = register_call;
	_tmp115_ = nentries;
	vala_ccode_function_call_add_argument (_tmp114_, (ValaCCodeExpression*) _tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = register_call;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = quark_name;
	_tmp122_ = vala_ccode_identifier_new (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp123_, "GQuark");
	_tmp125_ = _tmp124_;
	vala_ccode_function_add_return (_tmp120_, (ValaCCodeExpression*) _tmp125_);
	_vala_ccode_node_unref0 (_tmp125_);
	_vala_ccode_node_unref0 (_tmp123_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp126_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp127_ = cquark_fun;
	vala_ccode_file_add_function (_tmp126_, _tmp127_);
	_vala_ccode_node_unref0 (nentries);
	_vala_ccode_node_unref0 (register_call);
	_g_free0 (quark_name);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (error_entries);
	_g_free0 (edomain_dbus_name);
}

static gboolean
vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = vala_data_type_get_type_symbol (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp2_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = vala_data_type_get_type_symbol (type);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp2_ = g_strcmp0 (_tmp11_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp11_);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = vala_data_type_get_type_symbol (type);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp1_ = g_strcmp0 (_tmp15_, "GLib.Socket") == 0;
			_g_free0 (_tmp15_);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = vala_data_type_get_type_symbol (type);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp0_ = g_strcmp0 (_tmp19_, "GLib.FileDescriptorBased") == 0;
			_g_free0 (_tmp19_);
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_gd_bus_module_dbus_method_uses_file_descriptor (ValaGDBusModule* self,
                                                     ValaMethod* method)
{
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (method != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) method);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (vala_gd_bus_module_is_file_descriptor (self, _tmp11_)) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp12_ = vala_callable_get_return_type ((ValaCallable*) method);
	_tmp13_ = _tmp12_;
	if (vala_gd_bus_module_is_file_descriptor (self, _tmp13_)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static ValaCCodeExpression*
vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self,
                                        ValaDataType* type,
                                        ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_type_symbol (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_get_fd");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			result = (ValaCCodeExpression*) _result_;
			return result;
		} else {
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_tmp10_ = vala_data_type_get_type_symbol (type);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp15_;
				ValaCCodeIdentifier* _tmp16_;
				ValaCCodeFunctionCall* _tmp17_;
				ValaCCodeFunctionCall* _tmp18_;
				ValaCCodeFunctionCall* _tmp19_;
				_tmp15_ = vala_ccode_identifier_new ("g_unix_output_stream_get_fd");
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp16_);
				_tmp18_ = _tmp17_;
				_vala_ccode_node_unref0 (_tmp16_);
				_result_ = _tmp18_;
				_tmp19_ = _result_;
				vala_ccode_function_call_add_argument (_tmp19_, expr);
				result = (ValaCCodeExpression*) _result_;
				return result;
			} else {
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				_tmp20_ = vala_data_type_get_type_symbol (type);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strcmp0 (_tmp23_, "GLib.Socket") == 0;
				_g_free0 (_tmp23_);
				if (_tmp24_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp25_;
					ValaCCodeIdentifier* _tmp26_;
					ValaCCodeFunctionCall* _tmp27_;
					ValaCCodeFunctionCall* _tmp28_;
					ValaCCodeFunctionCall* _tmp29_;
					_tmp25_ = vala_ccode_identifier_new ("g_socket_get_fd");
					_tmp26_ = _tmp25_;
					_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp26_);
					_tmp28_ = _tmp27_;
					_vala_ccode_node_unref0 (_tmp26_);
					_result_ = _tmp28_;
					_tmp29_ = _result_;
					vala_ccode_function_call_add_argument (_tmp29_, expr);
					result = (ValaCCodeExpression*) _result_;
					return result;
				} else {
					ValaTypeSymbol* _tmp30_;
					ValaTypeSymbol* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gboolean _tmp34_;
					_tmp30_ = vala_data_type_get_type_symbol (type);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strcmp0 (_tmp33_, "GLib.FileDescriptorBased") == 0;
					_g_free0 (_tmp33_);
					if (_tmp34_) {
						ValaCCodeFunctionCall* _result_ = NULL;
						ValaCCodeIdentifier* _tmp35_;
						ValaCCodeIdentifier* _tmp36_;
						ValaCCodeFunctionCall* _tmp37_;
						ValaCCodeFunctionCall* _tmp38_;
						ValaCCodeFunctionCall* _tmp39_;
						_tmp35_ = vala_ccode_identifier_new ("g_file_descriptor_based_get_fd");
						_tmp36_ = _tmp35_;
						_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
						_tmp38_ = _tmp37_;
						_vala_ccode_node_unref0 (_tmp36_);
						_result_ = _tmp38_;
						_tmp39_ = _result_;
						vala_ccode_function_call_add_argument (_tmp39_, expr);
						result = (ValaCCodeExpression*) _result_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
vala_gd_bus_module_send_dbus_value (ValaGDBusModule* self,
                                    ValaDataType* type,
                                    ValaCCodeExpression* builder_expr,
                                    ValaCCodeExpression* expr,
                                    ValaSymbol* sym)
{
	ValaCCodeExpression* fd = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (builder_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_gd_bus_module_get_file_descriptor (self, type, expr);
	fd = _tmp0_;
	_tmp1_ = fd;
	if (_tmp1_ != NULL) {
		ValaCCodeFunctionCall* fd_append = NULL;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		ValaCCodeFunctionCall* _tmp5_;
		ValaCCodeFunctionCall* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeExpression* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeConstant* _tmp12_;
		ValaCCodeConstant* _tmp13_;
		ValaCCodeFunctionCall* builder_add = NULL;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeFunctionCall* _tmp17_;
		ValaCCodeFunctionCall* _tmp18_;
		ValaCCodeUnaryExpression* _tmp19_;
		ValaCCodeUnaryExpression* _tmp20_;
		ValaCCodeFunctionCall* _tmp21_;
		ValaCCodeConstant* _tmp22_;
		ValaCCodeConstant* _tmp23_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeFunctionCall* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeFunctionCall* _tmp28_;
		_tmp2_ = vala_ccode_identifier_new ("g_unix_fd_list_append");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		fd_append = _tmp5_;
		_tmp6_ = fd_append;
		_tmp7_ = vala_ccode_identifier_new ("_fd_list");
		_tmp8_ = _tmp7_;
		vala_ccode_function_call_add_argument (_tmp6_, (ValaCCodeExpression*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
		_tmp9_ = fd_append;
		_tmp10_ = fd;
		vala_ccode_function_call_add_argument (_tmp9_, _tmp10_);
		_tmp11_ = fd_append;
		_tmp12_ = vala_ccode_constant_new ("NULL");
		_tmp13_ = _tmp12_;
		vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_tmp14_ = vala_ccode_identifier_new ("g_variant_builder_add");
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		_vala_ccode_node_unref0 (_tmp15_);
		builder_add = _tmp17_;
		_tmp18_ = builder_add;
		_tmp19_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, builder_expr);
		_tmp20_ = _tmp19_;
		vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp20_);
		_vala_ccode_node_unref0 (_tmp20_);
		_tmp21_ = builder_add;
		_tmp22_ = vala_ccode_constant_new ("\"h\"");
		_tmp23_ = _tmp22_;
		vala_ccode_function_call_add_argument (_tmp21_, (ValaCCodeExpression*) _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = builder_add;
		_tmp25_ = fd_append;
		vala_ccode_function_call_add_argument (_tmp24_, (ValaCCodeExpression*) _tmp25_);
		_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp27_ = _tmp26_;
		_tmp28_ = builder_add;
		vala_ccode_function_add_expression (_tmp27_, (ValaCCodeExpression*) _tmp28_);
		_vala_ccode_node_unref0 (builder_add);
		_vala_ccode_node_unref0 (fd_append);
	} else {
		vala_gvariant_module_write_expression ((ValaGVariantModule*) self, type, builder_expr, expr, sym);
	}
	_vala_ccode_node_unref0 (fd);
}

static ValaCCodeExpression*
vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self,
                                                ValaDataType* type,
                                                ValaCCodeExpression* expr)
{
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_OBJECT_TYPE)) {
		ValaTypeSymbol* _tmp0_;
		ValaTypeSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp0_ = vala_data_type_get_type_symbol (type);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strcmp0 (_tmp3_, "GLib.UnixInputStream") == 0;
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			ValaCCodeFunctionCall* _result_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			ValaCCodeFunctionCall* _tmp10_;
			ValaCCodeConstant* _tmp11_;
			ValaCCodeConstant* _tmp12_;
			ValaCCodeFunctionCall* _tmp13_;
			ValaCCodeCastExpression* _tmp14_;
			_tmp5_ = vala_ccode_identifier_new ("g_unix_input_stream_new");
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
			_tmp8_ = _tmp7_;
			_vala_ccode_node_unref0 (_tmp6_);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			vala_ccode_function_call_add_argument (_tmp9_, expr);
			_tmp10_ = _result_;
			_tmp11_ = vala_ccode_constant_new ("TRUE");
			_tmp12_ = _tmp11_;
			vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp12_);
			_vala_ccode_node_unref0 (_tmp12_);
			_tmp13_ = _result_;
			_tmp14_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp13_, "GUnixInputStream *");
			result = (ValaCCodeExpression*) _tmp14_;
			_vala_ccode_node_unref0 (_result_);
			return result;
		} else {
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp15_ = vala_data_type_get_type_symbol (type);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				ValaCCodeFunctionCall* _result_ = NULL;
				ValaCCodeIdentifier* _tmp20_;
				ValaCCodeIdentifier* _tmp21_;
				ValaCCodeFunctionCall* _tmp22_;
				ValaCCodeFunctionCall* _tmp23_;
				ValaCCodeFunctionCall* _tmp24_;
				ValaCCodeFunctionCall* _tmp25_;
				ValaCCodeConstant* _tmp26_;
				ValaCCodeConstant* _tmp27_;
				ValaCCodeFunctionCall* _tmp28_;
				ValaCCodeCastExpression* _tmp29_;
				_tmp20_ = vala_ccode_identifier_new ("g_unix_output_stream_new");
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
				_tmp23_ = _tmp22_;
				_vala_ccode_node_unref0 (_tmp21_);
				_result_ = _tmp23_;
				_tmp24_ = _result_;
				vala_ccode_function_call_add_argument (_tmp24_, expr);
				_tmp25_ = _result_;
				_tmp26_ = vala_ccode_constant_new ("TRUE");
				_tmp27_ = _tmp26_;
				vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
				_vala_ccode_node_unref0 (_tmp27_);
				_tmp28_ = _result_;
				_tmp29_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp28_, "GUnixOutputStream *");
				result = (ValaCCodeExpression*) _tmp29_;
				_vala_ccode_node_unref0 (_result_);
				return result;
			} else {
				ValaTypeSymbol* _tmp30_;
				ValaTypeSymbol* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gboolean _tmp34_;
				_tmp30_ = vala_data_type_get_type_symbol (type);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strcmp0 (_tmp33_, "GLib.Socket") == 0;
				_g_free0 (_tmp33_);
				if (_tmp34_) {
					ValaCCodeFunctionCall* _result_ = NULL;
					ValaCCodeIdentifier* _tmp35_;
					ValaCCodeIdentifier* _tmp36_;
					ValaCCodeFunctionCall* _tmp37_;
					ValaCCodeFunctionCall* _tmp38_;
					ValaCCodeFunctionCall* _tmp39_;
					ValaCCodeFunctionCall* _tmp40_;
					ValaCCodeConstant* _tmp41_;
					ValaCCodeConstant* _tmp42_;
					_tmp35_ = vala_ccode_identifier_new ("g_socket_new_from_fd");
					_tmp36_ = _tmp35_;
					_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp36_);
					_tmp38_ = _tmp37_;
					_vala_ccode_node_unref0 (_tmp36_);
					_result_ = _tmp38_;
					_tmp39_ = _result_;
					vala_ccode_function_call_add_argument (_tmp39_, expr);
					_tmp40_ = _result_;
					_tmp41_ = vala_ccode_constant_new ("NULL");
					_tmp42_ = _tmp41_;
					vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
					_vala_ccode_node_unref0 (_tmp42_);
					result = (ValaCCodeExpression*) _result_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
vala_gd_bus_module_receive_dbus_value (ValaGDBusModule* self,
                                       ValaDataType* type,
                                       ValaCCodeExpression* message_expr,
                                       ValaCCodeExpression* iter_expr,
                                       ValaCCodeExpression* target_expr,
                                       ValaSymbol* sym,
                                       ValaCCodeExpression* error_expr,
                                       gboolean* may_fail)
{
	gboolean _vala_may_fail = FALSE;
	ValaCCodeFunctionCall* fd_list = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* fd_var = NULL;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeExpression* stream = NULL;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeExpression* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (message_expr != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (target_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_dbus_message_get_unix_fd_list");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	fd_list = _tmp3_;
	_tmp4_ = fd_list;
	vala_ccode_function_call_add_argument (_tmp4_, message_expr);
	_tmp5_ = vala_ccode_identifier_new ("_fd");
	fd_var = _tmp5_;
	_tmp6_ = fd_var;
	_tmp7_ = vala_gd_bus_module_create_from_file_descriptor (self, type, (ValaCCodeExpression*) _tmp6_);
	stream = _tmp7_;
	_tmp8_ = stream;
	if (_tmp8_ != NULL) {
		ValaCCodeIdentifier* fd_list_var = NULL;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeFunctionCall* fd = NULL;
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeIdentifier* _tmp11_;
		ValaCCodeFunctionCall* _tmp12_;
		ValaCCodeFunctionCall* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeFunctionCall* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeFunctionCall* get_fd = NULL;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeFunctionCall* _tmp29_;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeUnaryExpression* _tmp32_;
		ValaCCodeUnaryExpression* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeConstant* _tmp35_;
		ValaCCodeConstant* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeIdentifier* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeUnaryExpression* _tmp40_;
		ValaCCodeUnaryExpression* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunction* _tmp43_;
		ValaCCodeFunctionCall* _tmp44_;
		ValaCCodeFunction* _tmp45_;
		ValaCCodeFunction* _tmp46_;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeFunction* _tmp49_;
		ValaCCodeFunction* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeConstant* _tmp52_;
		ValaCCodeConstant* _tmp53_;
		ValaCCodeBinaryExpression* _tmp54_;
		ValaCCodeBinaryExpression* _tmp55_;
		ValaCCodeFunction* _tmp56_;
		ValaCCodeFunction* _tmp57_;
		ValaCCodeExpression* _tmp58_;
		ValaCCodeFunction* _tmp59_;
		ValaCCodeFunction* _tmp60_;
		ValaCCodeFunction* _tmp61_;
		ValaCCodeFunction* _tmp62_;
		ValaCCodeFunctionCall* set_error = NULL;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunctionCall* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeFunctionCall* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeIdentifier* _tmp70_;
		ValaCCodeFunctionCall* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeConstant* _tmp75_;
		ValaCCodeConstant* _tmp76_;
		ValaCCodeFunction* _tmp77_;
		ValaCCodeFunction* _tmp78_;
		ValaCCodeFunctionCall* _tmp79_;
		ValaCCodeFunction* _tmp80_;
		ValaCCodeFunction* _tmp81_;
		_tmp9_ = vala_ccode_identifier_new ("_fd_list");
		fd_list_var = _tmp9_;
		_tmp10_ = vala_ccode_identifier_new ("g_unix_fd_list_get");
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_ccode_node_unref0 (_tmp11_);
		fd = _tmp13_;
		_tmp14_ = fd;
		_tmp15_ = fd_list_var;
		vala_ccode_function_call_add_argument (_tmp14_, (ValaCCodeExpression*) _tmp15_);
		_tmp16_ = fd;
		_tmp17_ = vala_ccode_identifier_new ("_fd_index");
		_tmp18_ = _tmp17_;
		vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
		_vala_ccode_node_unref0 (_tmp18_);
		_tmp19_ = fd;
		vala_ccode_function_call_add_argument (_tmp19_, error_expr);
		_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = fd_list_var;
		_tmp23_ = fd_list;
		vala_ccode_function_add_assignment (_tmp21_, (ValaCCodeExpression*) _tmp22_, (ValaCCodeExpression*) _tmp23_);
		_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = fd_list_var;
		vala_ccode_function_open_if (_tmp25_, (ValaCCodeExpression*) _tmp26_);
		_tmp27_ = vala_ccode_identifier_new ("g_variant_iter_next");
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp28_);
		_tmp30_ = _tmp29_;
		_vala_ccode_node_unref0 (_tmp28_);
		get_fd = _tmp30_;
		_tmp31_ = get_fd;
		_tmp32_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr);
		_tmp33_ = _tmp32_;
		vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
		_vala_ccode_node_unref0 (_tmp33_);
		_tmp34_ = get_fd;
		_tmp35_ = vala_ccode_constant_new ("\"h\"");
		_tmp36_ = _tmp35_;
		vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = get_fd;
		_tmp38_ = vala_ccode_identifier_new ("_fd_index");
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp39_);
		_tmp41_ = _tmp40_;
		vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (_tmp41_);
		_vala_ccode_node_unref0 (_tmp39_);
		_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = get_fd;
		vala_ccode_function_add_expression (_tmp43_, (ValaCCodeExpression*) _tmp44_);
		_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = fd_var;
		_tmp48_ = fd;
		vala_ccode_function_add_assignment (_tmp46_, (ValaCCodeExpression*) _tmp47_, (ValaCCodeExpression*) _tmp48_);
		_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = fd_var;
		_tmp52_ = vala_ccode_constant_new ("0");
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, (ValaCCodeExpression*) _tmp51_, (ValaCCodeExpression*) _tmp53_);
		_tmp55_ = _tmp54_;
		vala_ccode_function_open_if (_tmp50_, (ValaCCodeExpression*) _tmp55_);
		_vala_ccode_node_unref0 (_tmp55_);
		_vala_ccode_node_unref0 (_tmp53_);
		_tmp56_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp57_ = _tmp56_;
		_tmp58_ = stream;
		vala_ccode_function_add_assignment (_tmp57_, target_expr, _tmp58_);
		_vala_may_fail = TRUE;
		_tmp59_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp60_ = _tmp59_;
		vala_ccode_function_close (_tmp60_);
		_tmp61_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp62_ = _tmp61_;
		vala_ccode_function_add_else (_tmp62_);
		_tmp63_ = vala_ccode_identifier_new ("g_set_error_literal");
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
		_tmp66_ = _tmp65_;
		_vala_ccode_node_unref0 (_tmp64_);
		set_error = _tmp66_;
		_tmp67_ = set_error;
		vala_ccode_function_call_add_argument (_tmp67_, error_expr);
		_tmp68_ = set_error;
		_tmp69_ = vala_ccode_identifier_new ("G_IO_ERROR");
		_tmp70_ = _tmp69_;
		vala_ccode_function_call_add_argument (_tmp68_, (ValaCCodeExpression*) _tmp70_);
		_vala_ccode_node_unref0 (_tmp70_);
		_tmp71_ = set_error;
		_tmp72_ = vala_ccode_identifier_new ("G_IO_ERROR_FAILED");
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_tmp74_ = set_error;
		_tmp75_ = vala_ccode_constant_new ("\"FD List is NULL\"");
		_tmp76_ = _tmp75_;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp76_);
		_vala_ccode_node_unref0 (_tmp76_);
		_tmp77_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp78_ = _tmp77_;
		_tmp79_ = set_error;
		vala_ccode_function_add_expression (_tmp78_, (ValaCCodeExpression*) _tmp79_);
		_tmp80_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp81_ = _tmp80_;
		vala_ccode_function_close (_tmp81_);
		_vala_ccode_node_unref0 (set_error);
		_vala_ccode_node_unref0 (get_fd);
		_vala_ccode_node_unref0 (fd);
		_vala_ccode_node_unref0 (fd_list_var);
	} else {
		gboolean _tmp82_ = FALSE;
		vala_gvariant_module_read_expression ((ValaGVariantModule*) self, type, iter_expr, target_expr, sym, error_expr, &_tmp82_);
		_vala_may_fail = _tmp82_;
	}
	_vala_ccode_node_unref0 (stream);
	_vala_ccode_node_unref0 (fd_var);
	_vala_ccode_node_unref0 (fd_list);
	if (may_fail) {
		*may_fail = _vala_may_fail;
	}
}

static ValaCCodeExpression*
vala_gd_bus_module_get_method_info (ValaGDBusModule* self,
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp365_;
	ValaCCodeConstant* _tmp366_;
	ValaCCodeConstant* _tmp367_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp368_;
	gchar* _tmp369_;
	gchar* _tmp370_;
	gchar* _tmp371_;
	gchar* _tmp372_;
	gchar* _tmp373_;
	gchar* _tmp374_;
	ValaCCodeInitializerList* _tmp375_;
	ValaCCodeVariableDeclarator* _tmp376_;
	ValaCCodeVariableDeclarator* _tmp377_;
	ValaCCodeFile* _tmp378_;
	gchar* _tmp379_;
	gchar* _tmp380_;
	gchar* _tmp381_;
	gchar* _tmp382_;
	gchar* _tmp383_;
	gchar* _tmp384_;
	ValaCCodeIdentifier* _tmp385_;
	ValaCCodeExpression* _tmp386_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _m_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _m_index = 0;
		_tmp1_ = vala_object_type_symbol_get_methods (sym);
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_m_list = _tmp2_;
		_tmp3_ = _m_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_m_size = _tmp5_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaMethod* m = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			ValaMethod* _tmp13_;
			ValaMethod* _tmp23_;
			ValaCCodeInitializerList* in_args_info = NULL;
			ValaCCodeInitializerList* _tmp24_;
			ValaCCodeInitializerList* out_args_info = NULL;
			ValaCCodeInitializerList* _tmp25_;
			ValaMethod* _tmp159_;
			ValaDataType* _tmp160_;
			ValaDataType* _tmp161_;
			ValaCCodeInitializerList* _tmp227_;
			ValaCCodeConstant* _tmp228_;
			ValaCCodeConstant* _tmp229_;
			ValaCCodeInitializerList* _tmp230_;
			ValaCCodeConstant* _tmp231_;
			ValaCCodeConstant* _tmp232_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp233_;
			ValaCCodeDeclaration* _tmp234_;
			gchar* _tmp235_;
			gchar* _tmp236_;
			gchar* _tmp237_;
			gchar* _tmp238_;
			gchar* _tmp239_;
			gchar* _tmp240_;
			ValaMethod* _tmp241_;
			const gchar* _tmp242_;
			const gchar* _tmp243_;
			gchar* _tmp244_;
			gchar* _tmp245_;
			gchar* _tmp246_;
			gchar* _tmp247_;
			ValaCCodeInitializerList* _tmp248_;
			ValaCCodeVariableDeclarator* _tmp249_;
			ValaCCodeVariableDeclarator* _tmp250_;
			ValaCCodeDeclaration* _tmp251_;
			ValaCCodeFile* _tmp252_;
			ValaCCodeDeclaration* _tmp253_;
			ValaCCodeDeclaration* _tmp254_;
			ValaCCodeDeclaration* _tmp255_;
			gchar* _tmp256_;
			gchar* _tmp257_;
			gchar* _tmp258_;
			gchar* _tmp259_;
			gchar* _tmp260_;
			gchar* _tmp261_;
			ValaMethod* _tmp262_;
			const gchar* _tmp263_;
			const gchar* _tmp264_;
			gchar* _tmp265_;
			gchar* _tmp266_;
			gchar* _tmp267_;
			gchar* _tmp268_;
			ValaCCodeInitializerList* _tmp269_;
			ValaCCodeVariableDeclarator* _tmp270_;
			ValaCCodeVariableDeclarator* _tmp271_;
			ValaCCodeDeclaration* _tmp272_;
			ValaCCodeFile* _tmp273_;
			ValaCCodeDeclaration* _tmp274_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp275_;
			ValaCCodeInitializerList* _tmp276_;
			ValaCCodeConstant* _tmp277_;
			ValaCCodeConstant* _tmp278_;
			ValaCCodeInitializerList* _tmp279_;
			ValaMethod* _tmp280_;
			gchar* _tmp281_;
			gchar* _tmp282_;
			gchar* _tmp283_;
			gchar* _tmp284_;
			ValaCCodeConstant* _tmp285_;
			ValaCCodeConstant* _tmp286_;
			ValaCCodeInitializerList* _tmp287_;
			gchar* _tmp288_;
			gchar* _tmp289_;
			gchar* _tmp290_;
			gchar* _tmp291_;
			gchar* _tmp292_;
			gchar* _tmp293_;
			ValaMethod* _tmp294_;
			const gchar* _tmp295_;
			const gchar* _tmp296_;
			gchar* _tmp297_;
			gchar* _tmp298_;
			gchar* _tmp299_;
			gchar* _tmp300_;
			ValaCCodeIdentifier* _tmp301_;
			ValaCCodeIdentifier* _tmp302_;
			ValaCCodeUnaryExpression* _tmp303_;
			ValaCCodeUnaryExpression* _tmp304_;
			ValaCCodeCastExpression* _tmp305_;
			ValaCCodeCastExpression* _tmp306_;
			ValaCCodeInitializerList* _tmp307_;
			gchar* _tmp308_;
			gchar* _tmp309_;
			gchar* _tmp310_;
			gchar* _tmp311_;
			gchar* _tmp312_;
			gchar* _tmp313_;
			ValaMethod* _tmp314_;
			const gchar* _tmp315_;
			const gchar* _tmp316_;
			gchar* _tmp317_;
			gchar* _tmp318_;
			gchar* _tmp319_;
			gchar* _tmp320_;
			ValaCCodeIdentifier* _tmp321_;
			ValaCCodeIdentifier* _tmp322_;
			ValaCCodeUnaryExpression* _tmp323_;
			ValaCCodeUnaryExpression* _tmp324_;
			ValaCCodeCastExpression* _tmp325_;
			ValaCCodeCastExpression* _tmp326_;
			ValaCCodeInitializerList* _tmp327_;
			ValaCCodeConstant* _tmp328_;
			ValaCCodeConstant* _tmp329_;
			ValaCCodeDeclaration* _tmp330_;
			ValaCCodeDeclaration* _tmp331_;
			gchar* _tmp332_;
			gchar* _tmp333_;
			gchar* _tmp334_;
			gchar* _tmp335_;
			gchar* _tmp336_;
			gchar* _tmp337_;
			ValaMethod* _tmp338_;
			const gchar* _tmp339_;
			const gchar* _tmp340_;
			gchar* _tmp341_;
			gchar* _tmp342_;
			ValaCCodeInitializerList* _tmp343_;
			ValaCCodeVariableDeclarator* _tmp344_;
			ValaCCodeVariableDeclarator* _tmp345_;
			ValaCCodeDeclaration* _tmp346_;
			ValaCCodeFile* _tmp347_;
			ValaCCodeDeclaration* _tmp348_;
			ValaCCodeInitializerList* _tmp349_;
			gchar* _tmp350_;
			gchar* _tmp351_;
			gchar* _tmp352_;
			gchar* _tmp353_;
			gchar* _tmp354_;
			gchar* _tmp355_;
			ValaMethod* _tmp356_;
			const gchar* _tmp357_;
			const gchar* _tmp358_;
			gchar* _tmp359_;
			gchar* _tmp360_;
			ValaCCodeIdentifier* _tmp361_;
			ValaCCodeIdentifier* _tmp362_;
			ValaCCodeUnaryExpression* _tmp363_;
			ValaCCodeUnaryExpression* _tmp364_;
			_m_index = _m_index + 1;
			_tmp6_ = _m_index;
			_tmp7_ = _m_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _m_list;
			_tmp9_ = vala_list_get (_tmp8_, _m_index);
			m = (ValaMethod*) _tmp9_;
			_tmp13_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_CREATION_METHOD)) {
				_tmp12_ = TRUE;
			} else {
				ValaMethod* _tmp14_;
				ValaMemberBinding _tmp15_;
				ValaMemberBinding _tmp16_;
				_tmp14_ = m;
				_tmp15_ = vala_method_get_binding (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_ != VALA_MEMBER_BINDING_INSTANCE;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				ValaMethod* _tmp17_;
				gboolean _tmp18_;
				gboolean _tmp19_;
				_tmp17_ = m;
				_tmp18_ = vala_method_get_overrides (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp11_ = _tmp19_;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				ValaMethod* _tmp20_;
				ValaSymbolAccessibility _tmp21_;
				ValaSymbolAccessibility _tmp22_;
				_tmp20_ = m;
				_tmp21_ = vala_symbol_get_access ((ValaSymbol*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp10_ = _tmp22_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp10_) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp23_ = m;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp23_)) {
				_vala_code_node_unref0 (m);
				continue;
			}
			_tmp24_ = vala_ccode_initializer_list_new ();
			in_args_info = _tmp24_;
			_tmp25_ = vala_ccode_initializer_list_new ();
			out_args_info = _tmp25_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp26_;
				ValaList* _tmp27_;
				ValaList* _tmp28_;
				gint _param_size = 0;
				ValaList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _param_index = 0;
				_tmp26_ = m;
				_tmp27_ = vala_callable_get_parameters ((ValaCallable*) _tmp26_);
				_tmp28_ = _vala_iterable_ref0 (_tmp27_);
				_param_list = _tmp28_;
				_tmp29_ = _param_list;
				_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_param_size = _tmp31_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp32_;
					gint _tmp33_;
					ValaParameter* param = NULL;
					ValaList* _tmp34_;
					gpointer _tmp35_;
					gboolean _tmp36_ = FALSE;
					ValaParameter* _tmp37_;
					ValaDataType* _tmp38_;
					ValaDataType* _tmp39_;
					gboolean _tmp47_ = FALSE;
					ValaParameter* _tmp48_;
					ValaDataType* _tmp49_;
					ValaDataType* _tmp50_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp58_;
					ValaCCodeInitializerList* _tmp59_;
					ValaCCodeConstant* _tmp60_;
					ValaCCodeConstant* _tmp61_;
					ValaCCodeInitializerList* _tmp62_;
					ValaParameter* _tmp63_;
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					ValaCCodeConstant* _tmp68_;
					ValaCCodeConstant* _tmp69_;
					ValaCCodeInitializerList* _tmp70_;
					ValaParameter* _tmp71_;
					ValaDataType* _tmp72_;
					ValaDataType* _tmp73_;
					ValaParameter* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					ValaCCodeConstant* _tmp79_;
					ValaCCodeConstant* _tmp80_;
					ValaCCodeInitializerList* _tmp81_;
					ValaCCodeConstant* _tmp82_;
					ValaCCodeConstant* _tmp83_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp84_;
					ValaCCodeDeclaration* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					gchar* _tmp91_;
					ValaMethod* _tmp92_;
					const gchar* _tmp93_;
					const gchar* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					gchar* _tmp97_;
					gchar* _tmp98_;
					ValaParameter* _tmp99_;
					const gchar* _tmp100_;
					const gchar* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					ValaCCodeInitializerList* _tmp104_;
					ValaCCodeVariableDeclarator* _tmp105_;
					ValaCCodeVariableDeclarator* _tmp106_;
					ValaCCodeDeclaration* _tmp107_;
					ValaCCodeFile* _tmp108_;
					ValaCCodeDeclaration* _tmp109_;
					ValaParameter* _tmp110_;
					ValaParameterDirection _tmp111_;
					ValaParameterDirection _tmp112_;
					_param_index = _param_index + 1;
					_tmp32_ = _param_index;
					_tmp33_ = _param_size;
					if (!(_tmp32_ < _tmp33_)) {
						break;
					}
					_tmp34_ = _param_list;
					_tmp35_ = vala_list_get (_tmp34_, _param_index);
					param = (ValaParameter*) _tmp35_;
					_tmp37_ = param;
					_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) _tmp37_);
					_tmp39_ = _tmp38_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp40_;
						ValaDataType* _tmp41_;
						ValaDataType* _tmp42_;
						ValaTypeSymbol* _tmp43_;
						ValaTypeSymbol* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						_tmp40_ = param;
						_tmp41_ = vala_variable_get_variable_type ((ValaVariable*) _tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = vala_data_type_get_type_symbol (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp44_);
						_tmp46_ = _tmp45_;
						_tmp36_ = g_strcmp0 (_tmp46_, "GLib.Cancellable") == 0;
						_g_free0 (_tmp46_);
					} else {
						_tmp36_ = FALSE;
					}
					if (_tmp36_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp48_ = param;
					_tmp49_ = vala_variable_get_variable_type ((ValaVariable*) _tmp48_);
					_tmp50_ = _tmp49_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_OBJECT_TYPE)) {
						ValaParameter* _tmp51_;
						ValaDataType* _tmp52_;
						ValaDataType* _tmp53_;
						ValaTypeSymbol* _tmp54_;
						ValaTypeSymbol* _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						_tmp51_ = param;
						_tmp52_ = vala_variable_get_variable_type ((ValaVariable*) _tmp51_);
						_tmp53_ = _tmp52_;
						_tmp54_ = vala_data_type_get_type_symbol (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp55_);
						_tmp57_ = _tmp56_;
						_tmp47_ = g_strcmp0 (_tmp57_, "GLib.BusName") == 0;
						_g_free0 (_tmp57_);
					} else {
						_tmp47_ = FALSE;
					}
					if (_tmp47_) {
						_vala_code_node_unref0 (param);
						continue;
					}
					_tmp58_ = vala_ccode_initializer_list_new ();
					info = _tmp58_;
					_tmp59_ = info;
					_tmp60_ = vala_ccode_constant_new ("-1");
					_tmp61_ = _tmp60_;
					vala_ccode_initializer_list_append (_tmp59_, (ValaCCodeExpression*) _tmp61_);
					_vala_ccode_node_unref0 (_tmp61_);
					_tmp62_ = info;
					_tmp63_ = param;
					_tmp64_ = vala_symbol_get_name ((ValaSymbol*) _tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = g_strdup_printf ("\"%s\"", _tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = vala_ccode_constant_new (_tmp67_);
					_tmp69_ = _tmp68_;
					vala_ccode_initializer_list_append (_tmp62_, (ValaCCodeExpression*) _tmp69_);
					_vala_ccode_node_unref0 (_tmp69_);
					_g_free0 (_tmp67_);
					_tmp70_ = info;
					_tmp71_ = param;
					_tmp72_ = vala_variable_get_variable_type ((ValaVariable*) _tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = param;
					_tmp75_ = vala_data_type_get_type_signature (_tmp73_, (ValaSymbol*) _tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = g_strdup_printf ("\"%s\"", _tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = vala_ccode_constant_new (_tmp78_);
					_tmp80_ = _tmp79_;
					vala_ccode_initializer_list_append (_tmp70_, (ValaCCodeExpression*) _tmp80_);
					_vala_ccode_node_unref0 (_tmp80_);
					_g_free0 (_tmp78_);
					_g_free0 (_tmp76_);
					_tmp81_ = info;
					_tmp82_ = vala_ccode_constant_new ("NULL");
					_tmp83_ = _tmp82_;
					vala_ccode_initializer_list_append (_tmp81_, (ValaCCodeExpression*) _tmp83_);
					_vala_ccode_node_unref0 (_tmp83_);
					_tmp84_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp84_;
					_tmp85_ = _cdecl_;
					_tmp86_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp87_ = _tmp86_;
					_tmp88_ = g_strconcat ("_", _tmp87_, NULL);
					_tmp89_ = _tmp88_;
					_tmp90_ = g_strconcat (_tmp89_, "dbus_arg_info_", NULL);
					_tmp91_ = _tmp90_;
					_tmp92_ = m;
					_tmp93_ = vala_symbol_get_name ((ValaSymbol*) _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = g_strconcat (_tmp91_, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					_tmp97_ = g_strconcat (_tmp96_, "_", NULL);
					_tmp98_ = _tmp97_;
					_tmp99_ = param;
					_tmp100_ = vala_symbol_get_name ((ValaSymbol*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = g_strconcat (_tmp98_, _tmp101_, NULL);
					_tmp103_ = _tmp102_;
					_tmp104_ = info;
					_tmp105_ = vala_ccode_variable_declarator_new (_tmp103_, (ValaCCodeExpression*) _tmp104_, NULL);
					_tmp106_ = _tmp105_;
					vala_ccode_declaration_add_declarator (_tmp85_, (ValaCCodeDeclarator*) _tmp106_);
					_vala_ccode_node_unref0 (_tmp106_);
					_g_free0 (_tmp103_);
					_g_free0 (_tmp98_);
					_g_free0 (_tmp96_);
					_g_free0 (_tmp91_);
					_g_free0 (_tmp89_);
					_g_free0 (_tmp87_);
					_tmp107_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp107_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp108_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp109_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp108_, (ValaCCodeNode*) _tmp109_);
					_tmp110_ = param;
					_tmp111_ = vala_parameter_get_direction (_tmp110_);
					_tmp112_ = _tmp111_;
					if (_tmp112_ == VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeInitializerList* _tmp113_;
						gchar* _tmp114_;
						gchar* _tmp115_;
						gchar* _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						gchar* _tmp119_;
						ValaMethod* _tmp120_;
						const gchar* _tmp121_;
						const gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						gchar* _tmp126_;
						ValaParameter* _tmp127_;
						const gchar* _tmp128_;
						const gchar* _tmp129_;
						gchar* _tmp130_;
						gchar* _tmp131_;
						ValaCCodeIdentifier* _tmp132_;
						ValaCCodeIdentifier* _tmp133_;
						ValaCCodeUnaryExpression* _tmp134_;
						ValaCCodeUnaryExpression* _tmp135_;
						_tmp113_ = in_args_info;
						_tmp114_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp115_ = _tmp114_;
						_tmp116_ = g_strconcat ("_", _tmp115_, NULL);
						_tmp117_ = _tmp116_;
						_tmp118_ = g_strconcat (_tmp117_, "dbus_arg_info_", NULL);
						_tmp119_ = _tmp118_;
						_tmp120_ = m;
						_tmp121_ = vala_symbol_get_name ((ValaSymbol*) _tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = g_strconcat (_tmp119_, _tmp122_, NULL);
						_tmp124_ = _tmp123_;
						_tmp125_ = g_strconcat (_tmp124_, "_", NULL);
						_tmp126_ = _tmp125_;
						_tmp127_ = param;
						_tmp128_ = vala_symbol_get_name ((ValaSymbol*) _tmp127_);
						_tmp129_ = _tmp128_;
						_tmp130_ = g_strconcat (_tmp126_, _tmp129_, NULL);
						_tmp131_ = _tmp130_;
						_tmp132_ = vala_ccode_identifier_new (_tmp131_);
						_tmp133_ = _tmp132_;
						_tmp134_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp133_);
						_tmp135_ = _tmp134_;
						vala_ccode_initializer_list_append (_tmp113_, (ValaCCodeExpression*) _tmp135_);
						_vala_ccode_node_unref0 (_tmp135_);
						_vala_ccode_node_unref0 (_tmp133_);
						_g_free0 (_tmp131_);
						_g_free0 (_tmp126_);
						_g_free0 (_tmp124_);
						_g_free0 (_tmp119_);
						_g_free0 (_tmp117_);
						_g_free0 (_tmp115_);
					} else {
						ValaCCodeInitializerList* _tmp136_;
						gchar* _tmp137_;
						gchar* _tmp138_;
						gchar* _tmp139_;
						gchar* _tmp140_;
						gchar* _tmp141_;
						gchar* _tmp142_;
						ValaMethod* _tmp143_;
						const gchar* _tmp144_;
						const gchar* _tmp145_;
						gchar* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
						gchar* _tmp149_;
						ValaParameter* _tmp150_;
						const gchar* _tmp151_;
						const gchar* _tmp152_;
						gchar* _tmp153_;
						gchar* _tmp154_;
						ValaCCodeIdentifier* _tmp155_;
						ValaCCodeIdentifier* _tmp156_;
						ValaCCodeUnaryExpression* _tmp157_;
						ValaCCodeUnaryExpression* _tmp158_;
						_tmp136_ = out_args_info;
						_tmp137_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
						_tmp138_ = _tmp137_;
						_tmp139_ = g_strconcat ("_", _tmp138_, NULL);
						_tmp140_ = _tmp139_;
						_tmp141_ = g_strconcat (_tmp140_, "dbus_arg_info_", NULL);
						_tmp142_ = _tmp141_;
						_tmp143_ = m;
						_tmp144_ = vala_symbol_get_name ((ValaSymbol*) _tmp143_);
						_tmp145_ = _tmp144_;
						_tmp146_ = g_strconcat (_tmp142_, _tmp145_, NULL);
						_tmp147_ = _tmp146_;
						_tmp148_ = g_strconcat (_tmp147_, "_", NULL);
						_tmp149_ = _tmp148_;
						_tmp150_ = param;
						_tmp151_ = vala_symbol_get_name ((ValaSymbol*) _tmp150_);
						_tmp152_ = _tmp151_;
						_tmp153_ = g_strconcat (_tmp149_, _tmp152_, NULL);
						_tmp154_ = _tmp153_;
						_tmp155_ = vala_ccode_identifier_new (_tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp156_);
						_tmp158_ = _tmp157_;
						vala_ccode_initializer_list_append (_tmp136_, (ValaCCodeExpression*) _tmp158_);
						_vala_ccode_node_unref0 (_tmp158_);
						_vala_ccode_node_unref0 (_tmp156_);
						_g_free0 (_tmp154_);
						_g_free0 (_tmp149_);
						_g_free0 (_tmp147_);
						_g_free0 (_tmp142_);
						_g_free0 (_tmp140_);
						_g_free0 (_tmp138_);
					}
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp159_ = m;
			_tmp160_ = vala_callable_get_return_type ((ValaCallable*) _tmp159_);
			_tmp161_ = _tmp160_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_VOID_TYPE)) {
				ValaCCodeInitializerList* info = NULL;
				ValaCCodeInitializerList* _tmp162_;
				ValaCCodeInitializerList* _tmp163_;
				ValaCCodeConstant* _tmp164_;
				ValaCCodeConstant* _tmp165_;
				ValaCCodeInitializerList* _tmp166_;
				ValaMethod* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				gchar* _tmp171_;
				ValaCCodeConstant* _tmp172_;
				ValaCCodeConstant* _tmp173_;
				ValaCCodeInitializerList* _tmp174_;
				ValaMethod* _tmp175_;
				ValaDataType* _tmp176_;
				ValaDataType* _tmp177_;
				ValaMethod* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				gchar* _tmp182_;
				ValaCCodeConstant* _tmp183_;
				ValaCCodeConstant* _tmp184_;
				ValaCCodeInitializerList* _tmp185_;
				ValaCCodeConstant* _tmp186_;
				ValaCCodeConstant* _tmp187_;
				ValaCCodeDeclaration* _cdecl_ = NULL;
				ValaCCodeDeclaration* _tmp188_;
				ValaCCodeDeclaration* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				gchar* _tmp195_;
				ValaMethod* _tmp196_;
				const gchar* _tmp197_;
				const gchar* _tmp198_;
				gchar* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeInitializerList* _tmp203_;
				ValaCCodeVariableDeclarator* _tmp204_;
				ValaCCodeVariableDeclarator* _tmp205_;
				ValaCCodeDeclaration* _tmp206_;
				ValaCCodeFile* _tmp207_;
				ValaCCodeDeclaration* _tmp208_;
				ValaCCodeInitializerList* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				gchar* _tmp213_;
				gchar* _tmp214_;
				gchar* _tmp215_;
				ValaMethod* _tmp216_;
				const gchar* _tmp217_;
				const gchar* _tmp218_;
				gchar* _tmp219_;
				gchar* _tmp220_;
				gchar* _tmp221_;
				gchar* _tmp222_;
				ValaCCodeIdentifier* _tmp223_;
				ValaCCodeIdentifier* _tmp224_;
				ValaCCodeUnaryExpression* _tmp225_;
				ValaCCodeUnaryExpression* _tmp226_;
				_tmp162_ = vala_ccode_initializer_list_new ();
				info = _tmp162_;
				_tmp163_ = info;
				_tmp164_ = vala_ccode_constant_new ("-1");
				_tmp165_ = _tmp164_;
				vala_ccode_initializer_list_append (_tmp163_, (ValaCCodeExpression*) _tmp165_);
				_vala_ccode_node_unref0 (_tmp165_);
				_tmp166_ = info;
				_tmp167_ = m;
				_tmp168_ = vala_gd_bus_module_dbus_result_name (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = g_strdup_printf ("\"%s\"", _tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_constant_new (_tmp171_);
				_tmp173_ = _tmp172_;
				vala_ccode_initializer_list_append (_tmp166_, (ValaCCodeExpression*) _tmp173_);
				_vala_ccode_node_unref0 (_tmp173_);
				_g_free0 (_tmp171_);
				_g_free0 (_tmp169_);
				_tmp174_ = info;
				_tmp175_ = m;
				_tmp176_ = vala_callable_get_return_type ((ValaCallable*) _tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = m;
				_tmp179_ = vala_data_type_get_type_signature (_tmp177_, (ValaSymbol*) _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = g_strdup_printf ("\"%s\"", _tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_ccode_constant_new (_tmp182_);
				_tmp184_ = _tmp183_;
				vala_ccode_initializer_list_append (_tmp174_, (ValaCCodeExpression*) _tmp184_);
				_vala_ccode_node_unref0 (_tmp184_);
				_g_free0 (_tmp182_);
				_g_free0 (_tmp180_);
				_tmp185_ = info;
				_tmp186_ = vala_ccode_constant_new ("NULL");
				_tmp187_ = _tmp186_;
				vala_ccode_initializer_list_append (_tmp185_, (ValaCCodeExpression*) _tmp187_);
				_vala_ccode_node_unref0 (_tmp187_);
				_tmp188_ = vala_ccode_declaration_new ("const GDBusArgInfo");
				_cdecl_ = _tmp188_;
				_tmp189_ = _cdecl_;
				_tmp190_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp191_ = _tmp190_;
				_tmp192_ = g_strconcat ("_", _tmp191_, NULL);
				_tmp193_ = _tmp192_;
				_tmp194_ = g_strconcat (_tmp193_, "dbus_arg_info_", NULL);
				_tmp195_ = _tmp194_;
				_tmp196_ = m;
				_tmp197_ = vala_symbol_get_name ((ValaSymbol*) _tmp196_);
				_tmp198_ = _tmp197_;
				_tmp199_ = g_strconcat (_tmp195_, _tmp198_, NULL);
				_tmp200_ = _tmp199_;
				_tmp201_ = g_strconcat (_tmp200_, "_result", NULL);
				_tmp202_ = _tmp201_;
				_tmp203_ = info;
				_tmp204_ = vala_ccode_variable_declarator_new (_tmp202_, (ValaCCodeExpression*) _tmp203_, NULL);
				_tmp205_ = _tmp204_;
				vala_ccode_declaration_add_declarator (_tmp189_, (ValaCCodeDeclarator*) _tmp205_);
				_vala_ccode_node_unref0 (_tmp205_);
				_g_free0 (_tmp202_);
				_g_free0 (_tmp200_);
				_g_free0 (_tmp195_);
				_g_free0 (_tmp193_);
				_g_free0 (_tmp191_);
				_tmp206_ = _cdecl_;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp206_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp207_ = ((ValaCCodeBaseModule*) self)->cfile;
				_tmp208_ = _cdecl_;
				vala_ccode_file_add_constant_declaration (_tmp207_, (ValaCCodeNode*) _tmp208_);
				_tmp209_ = out_args_info;
				_tmp210_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
				_tmp211_ = _tmp210_;
				_tmp212_ = g_strconcat ("_", _tmp211_, NULL);
				_tmp213_ = _tmp212_;
				_tmp214_ = g_strconcat (_tmp213_, "dbus_arg_info_", NULL);
				_tmp215_ = _tmp214_;
				_tmp216_ = m;
				_tmp217_ = vala_symbol_get_name ((ValaSymbol*) _tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = g_strconcat (_tmp215_, _tmp218_, NULL);
				_tmp220_ = _tmp219_;
				_tmp221_ = g_strconcat (_tmp220_, "_result", NULL);
				_tmp222_ = _tmp221_;
				_tmp223_ = vala_ccode_identifier_new (_tmp222_);
				_tmp224_ = _tmp223_;
				_tmp225_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp224_);
				_tmp226_ = _tmp225_;
				vala_ccode_initializer_list_append (_tmp209_, (ValaCCodeExpression*) _tmp226_);
				_vala_ccode_node_unref0 (_tmp226_);
				_vala_ccode_node_unref0 (_tmp224_);
				_g_free0 (_tmp222_);
				_g_free0 (_tmp220_);
				_g_free0 (_tmp215_);
				_g_free0 (_tmp213_);
				_g_free0 (_tmp211_);
				_vala_ccode_node_unref0 (_cdecl_);
				_vala_ccode_node_unref0 (info);
			}
			_tmp227_ = in_args_info;
			_tmp228_ = vala_ccode_constant_new ("NULL");
			_tmp229_ = _tmp228_;
			vala_ccode_initializer_list_append (_tmp227_, (ValaCCodeExpression*) _tmp229_);
			_vala_ccode_node_unref0 (_tmp229_);
			_tmp230_ = out_args_info;
			_tmp231_ = vala_ccode_constant_new ("NULL");
			_tmp232_ = _tmp231_;
			vala_ccode_initializer_list_append (_tmp230_, (ValaCCodeExpression*) _tmp232_);
			_vala_ccode_node_unref0 (_tmp232_);
			_tmp233_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp233_;
			_tmp234_ = _cdecl_;
			_tmp235_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp236_ = _tmp235_;
			_tmp237_ = g_strconcat ("_", _tmp236_, NULL);
			_tmp238_ = _tmp237_;
			_tmp239_ = g_strconcat (_tmp238_, "dbus_arg_info_", NULL);
			_tmp240_ = _tmp239_;
			_tmp241_ = m;
			_tmp242_ = vala_symbol_get_name ((ValaSymbol*) _tmp241_);
			_tmp243_ = _tmp242_;
			_tmp244_ = g_strconcat (_tmp240_, _tmp243_, NULL);
			_tmp245_ = _tmp244_;
			_tmp246_ = g_strconcat (_tmp245_, "_in[]", NULL);
			_tmp247_ = _tmp246_;
			_tmp248_ = in_args_info;
			_tmp249_ = vala_ccode_variable_declarator_new (_tmp247_, (ValaCCodeExpression*) _tmp248_, NULL);
			_tmp250_ = _tmp249_;
			vala_ccode_declaration_add_declarator (_tmp234_, (ValaCCodeDeclarator*) _tmp250_);
			_vala_ccode_node_unref0 (_tmp250_);
			_g_free0 (_tmp247_);
			_g_free0 (_tmp245_);
			_g_free0 (_tmp240_);
			_g_free0 (_tmp238_);
			_g_free0 (_tmp236_);
			_tmp251_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp251_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp252_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp253_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp252_, (ValaCCodeNode*) _tmp253_);
			_tmp254_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp254_;
			_tmp255_ = _cdecl_;
			_tmp256_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp257_ = _tmp256_;
			_tmp258_ = g_strconcat ("_", _tmp257_, NULL);
			_tmp259_ = _tmp258_;
			_tmp260_ = g_strconcat (_tmp259_, "dbus_arg_info_", NULL);
			_tmp261_ = _tmp260_;
			_tmp262_ = m;
			_tmp263_ = vala_symbol_get_name ((ValaSymbol*) _tmp262_);
			_tmp264_ = _tmp263_;
			_tmp265_ = g_strconcat (_tmp261_, _tmp264_, NULL);
			_tmp266_ = _tmp265_;
			_tmp267_ = g_strconcat (_tmp266_, "_out[]", NULL);
			_tmp268_ = _tmp267_;
			_tmp269_ = out_args_info;
			_tmp270_ = vala_ccode_variable_declarator_new (_tmp268_, (ValaCCodeExpression*) _tmp269_, NULL);
			_tmp271_ = _tmp270_;
			vala_ccode_declaration_add_declarator (_tmp255_, (ValaCCodeDeclarator*) _tmp271_);
			_vala_ccode_node_unref0 (_tmp271_);
			_g_free0 (_tmp268_);
			_g_free0 (_tmp266_);
			_g_free0 (_tmp261_);
			_g_free0 (_tmp259_);
			_g_free0 (_tmp257_);
			_tmp272_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp272_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp273_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp274_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp273_, (ValaCCodeNode*) _tmp274_);
			_tmp275_ = vala_ccode_initializer_list_new ();
			info = _tmp275_;
			_tmp276_ = info;
			_tmp277_ = vala_ccode_constant_new ("-1");
			_tmp278_ = _tmp277_;
			vala_ccode_initializer_list_append (_tmp276_, (ValaCCodeExpression*) _tmp278_);
			_vala_ccode_node_unref0 (_tmp278_);
			_tmp279_ = info;
			_tmp280_ = m;
			_tmp281_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp280_);
			_tmp282_ = _tmp281_;
			_tmp283_ = g_strdup_printf ("\"%s\"", _tmp282_);
			_tmp284_ = _tmp283_;
			_tmp285_ = vala_ccode_constant_new (_tmp284_);
			_tmp286_ = _tmp285_;
			vala_ccode_initializer_list_append (_tmp279_, (ValaCCodeExpression*) _tmp286_);
			_vala_ccode_node_unref0 (_tmp286_);
			_g_free0 (_tmp284_);
			_g_free0 (_tmp282_);
			_tmp287_ = info;
			_tmp288_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp289_ = _tmp288_;
			_tmp290_ = g_strconcat ("_", _tmp289_, NULL);
			_tmp291_ = _tmp290_;
			_tmp292_ = g_strconcat (_tmp291_, "dbus_arg_info_", NULL);
			_tmp293_ = _tmp292_;
			_tmp294_ = m;
			_tmp295_ = vala_symbol_get_name ((ValaSymbol*) _tmp294_);
			_tmp296_ = _tmp295_;
			_tmp297_ = g_strconcat (_tmp293_, _tmp296_, NULL);
			_tmp298_ = _tmp297_;
			_tmp299_ = g_strconcat (_tmp298_, "_in", NULL);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_ccode_identifier_new (_tmp300_);
			_tmp302_ = _tmp301_;
			_tmp303_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp302_);
			_tmp304_ = _tmp303_;
			_tmp305_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp304_, "GDBusArgInfo **");
			_tmp306_ = _tmp305_;
			vala_ccode_initializer_list_append (_tmp287_, (ValaCCodeExpression*) _tmp306_);
			_vala_ccode_node_unref0 (_tmp306_);
			_vala_ccode_node_unref0 (_tmp304_);
			_vala_ccode_node_unref0 (_tmp302_);
			_g_free0 (_tmp300_);
			_g_free0 (_tmp298_);
			_g_free0 (_tmp293_);
			_g_free0 (_tmp291_);
			_g_free0 (_tmp289_);
			_tmp307_ = info;
			_tmp308_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp309_ = _tmp308_;
			_tmp310_ = g_strconcat ("_", _tmp309_, NULL);
			_tmp311_ = _tmp310_;
			_tmp312_ = g_strconcat (_tmp311_, "dbus_arg_info_", NULL);
			_tmp313_ = _tmp312_;
			_tmp314_ = m;
			_tmp315_ = vala_symbol_get_name ((ValaSymbol*) _tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = g_strconcat (_tmp313_, _tmp316_, NULL);
			_tmp318_ = _tmp317_;
			_tmp319_ = g_strconcat (_tmp318_, "_out", NULL);
			_tmp320_ = _tmp319_;
			_tmp321_ = vala_ccode_identifier_new (_tmp320_);
			_tmp322_ = _tmp321_;
			_tmp323_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp322_);
			_tmp324_ = _tmp323_;
			_tmp325_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp324_, "GDBusArgInfo **");
			_tmp326_ = _tmp325_;
			vala_ccode_initializer_list_append (_tmp307_, (ValaCCodeExpression*) _tmp326_);
			_vala_ccode_node_unref0 (_tmp326_);
			_vala_ccode_node_unref0 (_tmp324_);
			_vala_ccode_node_unref0 (_tmp322_);
			_g_free0 (_tmp320_);
			_g_free0 (_tmp318_);
			_g_free0 (_tmp313_);
			_g_free0 (_tmp311_);
			_g_free0 (_tmp309_);
			_tmp327_ = info;
			_tmp328_ = vala_ccode_constant_new ("NULL");
			_tmp329_ = _tmp328_;
			vala_ccode_initializer_list_append (_tmp327_, (ValaCCodeExpression*) _tmp329_);
			_vala_ccode_node_unref0 (_tmp329_);
			_tmp330_ = vala_ccode_declaration_new ("const GDBusMethodInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp330_;
			_tmp331_ = _cdecl_;
			_tmp332_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp333_ = _tmp332_;
			_tmp334_ = g_strconcat ("_", _tmp333_, NULL);
			_tmp335_ = _tmp334_;
			_tmp336_ = g_strconcat (_tmp335_, "dbus_method_info_", NULL);
			_tmp337_ = _tmp336_;
			_tmp338_ = m;
			_tmp339_ = vala_symbol_get_name ((ValaSymbol*) _tmp338_);
			_tmp340_ = _tmp339_;
			_tmp341_ = g_strconcat (_tmp337_, _tmp340_, NULL);
			_tmp342_ = _tmp341_;
			_tmp343_ = info;
			_tmp344_ = vala_ccode_variable_declarator_new (_tmp342_, (ValaCCodeExpression*) _tmp343_, NULL);
			_tmp345_ = _tmp344_;
			vala_ccode_declaration_add_declarator (_tmp331_, (ValaCCodeDeclarator*) _tmp345_);
			_vala_ccode_node_unref0 (_tmp345_);
			_g_free0 (_tmp342_);
			_g_free0 (_tmp337_);
			_g_free0 (_tmp335_);
			_g_free0 (_tmp333_);
			_tmp346_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp346_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp347_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp348_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp347_, (ValaCCodeNode*) _tmp348_);
			_tmp349_ = infos;
			_tmp350_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp351_ = _tmp350_;
			_tmp352_ = g_strconcat ("_", _tmp351_, NULL);
			_tmp353_ = _tmp352_;
			_tmp354_ = g_strconcat (_tmp353_, "dbus_method_info_", NULL);
			_tmp355_ = _tmp354_;
			_tmp356_ = m;
			_tmp357_ = vala_symbol_get_name ((ValaSymbol*) _tmp356_);
			_tmp358_ = _tmp357_;
			_tmp359_ = g_strconcat (_tmp355_, _tmp358_, NULL);
			_tmp360_ = _tmp359_;
			_tmp361_ = vala_ccode_identifier_new (_tmp360_);
			_tmp362_ = _tmp361_;
			_tmp363_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp362_);
			_tmp364_ = _tmp363_;
			vala_ccode_initializer_list_append (_tmp349_, (ValaCCodeExpression*) _tmp364_);
			_vala_ccode_node_unref0 (_tmp364_);
			_vala_ccode_node_unref0 (_tmp362_);
			_g_free0 (_tmp360_);
			_g_free0 (_tmp355_);
			_g_free0 (_tmp353_);
			_g_free0 (_tmp351_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (out_args_info);
			_vala_ccode_node_unref0 (in_args_info);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp365_ = infos;
	_tmp366_ = vala_ccode_constant_new ("NULL");
	_tmp367_ = _tmp366_;
	vala_ccode_initializer_list_append (_tmp365_, (ValaCCodeExpression*) _tmp367_);
	_vala_ccode_node_unref0 (_tmp367_);
	_tmp368_ = vala_ccode_declaration_new ("const GDBusMethodInfo * const");
	_cdecl_ = _tmp368_;
	_tmp369_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp370_ = _tmp369_;
	_tmp371_ = g_strconcat ("_", _tmp370_, NULL);
	_tmp372_ = _tmp371_;
	_tmp373_ = g_strconcat (_tmp372_, "dbus_method_info[]", NULL);
	_tmp374_ = _tmp373_;
	_tmp375_ = infos;
	_tmp376_ = vala_ccode_variable_declarator_new (_tmp374_, (ValaCCodeExpression*) _tmp375_, NULL);
	_tmp377_ = _tmp376_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp377_);
	_vala_ccode_node_unref0 (_tmp377_);
	_g_free0 (_tmp374_);
	_g_free0 (_tmp372_);
	_g_free0 (_tmp370_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp378_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp378_, (ValaCCodeNode*) _cdecl_);
	_tmp379_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp380_ = _tmp379_;
	_tmp381_ = g_strconcat ("_", _tmp380_, NULL);
	_tmp382_ = _tmp381_;
	_tmp383_ = g_strconcat (_tmp382_, "dbus_method_info", NULL);
	_tmp384_ = _tmp383_;
	_tmp385_ = vala_ccode_identifier_new (_tmp384_);
	_tmp386_ = (ValaCCodeExpression*) _tmp385_;
	_g_free0 (_tmp384_);
	_g_free0 (_tmp382_);
	_g_free0 (_tmp380_);
	result = _tmp386_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}

static ValaCCodeExpression*
vala_gd_bus_module_get_signal_info (ValaGDBusModule* self,
                                    ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp192_;
	ValaCCodeConstant* _tmp193_;
	ValaCCodeConstant* _tmp194_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp195_;
	gchar* _tmp196_;
	gchar* _tmp197_;
	gchar* _tmp198_;
	gchar* _tmp199_;
	gchar* _tmp200_;
	gchar* _tmp201_;
	ValaCCodeInitializerList* _tmp202_;
	ValaCCodeVariableDeclarator* _tmp203_;
	ValaCCodeVariableDeclarator* _tmp204_;
	ValaCCodeFile* _tmp205_;
	gchar* _tmp206_;
	gchar* _tmp207_;
	gchar* _tmp208_;
	gchar* _tmp209_;
	gchar* _tmp210_;
	gchar* _tmp211_;
	ValaCCodeIdentifier* _tmp212_;
	ValaCCodeExpression* _tmp213_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _sig_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _sig_index = 0;
		_tmp1_ = vala_object_type_symbol_get_signals (sym);
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_sig_list = _tmp2_;
		_tmp3_ = _sig_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_sig_size = _tmp5_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaSignal* sig = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaSignal* _tmp10_;
			ValaSymbolAccessibility _tmp11_;
			ValaSymbolAccessibility _tmp12_;
			ValaSignal* _tmp13_;
			ValaCCodeInitializerList* args_info = NULL;
			ValaCCodeInitializerList* _tmp14_;
			ValaCCodeInitializerList* _tmp100_;
			ValaCCodeConstant* _tmp101_;
			ValaCCodeConstant* _tmp102_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp103_;
			ValaCCodeDeclaration* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			ValaSignal* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			gchar* _tmp114_;
			gchar* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			ValaCCodeInitializerList* _tmp118_;
			ValaCCodeVariableDeclarator* _tmp119_;
			ValaCCodeVariableDeclarator* _tmp120_;
			ValaCCodeDeclaration* _tmp121_;
			ValaCCodeFile* _tmp122_;
			ValaCCodeDeclaration* _tmp123_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp124_;
			ValaCCodeInitializerList* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeInitializerList* _tmp128_;
			ValaSignal* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			ValaCCodeConstant* _tmp134_;
			ValaCCodeConstant* _tmp135_;
			ValaCCodeInitializerList* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			ValaSignal* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			ValaCCodeIdentifier* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaCCodeUnaryExpression* _tmp150_;
			ValaCCodeUnaryExpression* _tmp151_;
			ValaCCodeCastExpression* _tmp152_;
			ValaCCodeCastExpression* _tmp153_;
			ValaCCodeInitializerList* _tmp154_;
			ValaCCodeConstant* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeDeclaration* _tmp157_;
			ValaCCodeDeclaration* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			gchar* _tmp162_;
			gchar* _tmp163_;
			gchar* _tmp164_;
			ValaSignal* _tmp165_;
			gchar* _tmp166_;
			gchar* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
			ValaCCodeInitializerList* _tmp170_;
			ValaCCodeVariableDeclarator* _tmp171_;
			ValaCCodeVariableDeclarator* _tmp172_;
			ValaCCodeDeclaration* _tmp173_;
			ValaCCodeFile* _tmp174_;
			ValaCCodeDeclaration* _tmp175_;
			ValaCCodeInitializerList* _tmp176_;
			gchar* _tmp177_;
			gchar* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			ValaSignal* _tmp183_;
			gchar* _tmp184_;
			gchar* _tmp185_;
			gchar* _tmp186_;
			gchar* _tmp187_;
			ValaCCodeIdentifier* _tmp188_;
			ValaCCodeIdentifier* _tmp189_;
			ValaCCodeUnaryExpression* _tmp190_;
			ValaCCodeUnaryExpression* _tmp191_;
			_sig_index = _sig_index + 1;
			_tmp6_ = _sig_index;
			_tmp7_ = _sig_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _sig_list;
			_tmp9_ = vala_list_get (_tmp8_, _sig_index);
			sig = (ValaSignal*) _tmp9_;
			_tmp10_ = sig;
			_tmp11_ = vala_symbol_get_access ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp13_ = sig;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp13_)) {
				_vala_code_node_unref0 (sig);
				continue;
			}
			_tmp14_ = vala_ccode_initializer_list_new ();
			args_info = _tmp14_;
			{
				ValaList* _param_list = NULL;
				ValaSignal* _tmp15_;
				ValaList* _tmp16_;
				ValaList* _tmp17_;
				gint _param_size = 0;
				ValaList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _param_index = 0;
				_tmp15_ = sig;
				_tmp16_ = vala_callable_get_parameters ((ValaCallable*) _tmp15_);
				_tmp17_ = _vala_iterable_ref0 (_tmp16_);
				_param_list = _tmp17_;
				_tmp18_ = _param_list;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_param_size = _tmp20_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					ValaParameter* param = NULL;
					ValaList* _tmp23_;
					gpointer _tmp24_;
					ValaCCodeInitializerList* info = NULL;
					ValaCCodeInitializerList* _tmp25_;
					ValaCCodeInitializerList* _tmp26_;
					ValaCCodeConstant* _tmp27_;
					ValaCCodeConstant* _tmp28_;
					ValaCCodeInitializerList* _tmp29_;
					ValaParameter* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					ValaCCodeConstant* _tmp35_;
					ValaCCodeConstant* _tmp36_;
					ValaCCodeInitializerList* _tmp37_;
					ValaParameter* _tmp38_;
					ValaDataType* _tmp39_;
					ValaDataType* _tmp40_;
					ValaParameter* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					ValaCCodeConstant* _tmp46_;
					ValaCCodeConstant* _tmp47_;
					ValaCCodeInitializerList* _tmp48_;
					ValaCCodeConstant* _tmp49_;
					ValaCCodeConstant* _tmp50_;
					ValaCCodeDeclaration* _cdecl_ = NULL;
					ValaCCodeDeclaration* _tmp51_;
					ValaCCodeDeclaration* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					ValaSignal* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					gchar* _tmp64_;
					gchar* _tmp65_;
					ValaParameter* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					ValaCCodeInitializerList* _tmp71_;
					ValaCCodeVariableDeclarator* _tmp72_;
					ValaCCodeVariableDeclarator* _tmp73_;
					ValaCCodeDeclaration* _tmp74_;
					ValaCCodeFile* _tmp75_;
					ValaCCodeDeclaration* _tmp76_;
					ValaCCodeInitializerList* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					ValaSignal* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					ValaParameter* _tmp91_;
					const gchar* _tmp92_;
					const gchar* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeUnaryExpression* _tmp98_;
					ValaCCodeUnaryExpression* _tmp99_;
					_param_index = _param_index + 1;
					_tmp21_ = _param_index;
					_tmp22_ = _param_size;
					if (!(_tmp21_ < _tmp22_)) {
						break;
					}
					_tmp23_ = _param_list;
					_tmp24_ = vala_list_get (_tmp23_, _param_index);
					param = (ValaParameter*) _tmp24_;
					_tmp25_ = vala_ccode_initializer_list_new ();
					info = _tmp25_;
					_tmp26_ = info;
					_tmp27_ = vala_ccode_constant_new ("-1");
					_tmp28_ = _tmp27_;
					vala_ccode_initializer_list_append (_tmp26_, (ValaCCodeExpression*) _tmp28_);
					_vala_ccode_node_unref0 (_tmp28_);
					_tmp29_ = info;
					_tmp30_ = param;
					_tmp31_ = vala_symbol_get_name ((ValaSymbol*) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = g_strdup_printf ("\"%s\"", _tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = vala_ccode_constant_new (_tmp34_);
					_tmp36_ = _tmp35_;
					vala_ccode_initializer_list_append (_tmp29_, (ValaCCodeExpression*) _tmp36_);
					_vala_ccode_node_unref0 (_tmp36_);
					_g_free0 (_tmp34_);
					_tmp37_ = info;
					_tmp38_ = param;
					_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) _tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = param;
					_tmp42_ = vala_data_type_get_type_signature (_tmp40_, (ValaSymbol*) _tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strdup_printf ("\"%s\"", _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = vala_ccode_constant_new (_tmp45_);
					_tmp47_ = _tmp46_;
					vala_ccode_initializer_list_append (_tmp37_, (ValaCCodeExpression*) _tmp47_);
					_vala_ccode_node_unref0 (_tmp47_);
					_g_free0 (_tmp45_);
					_g_free0 (_tmp43_);
					_tmp48_ = info;
					_tmp49_ = vala_ccode_constant_new ("NULL");
					_tmp50_ = _tmp49_;
					vala_ccode_initializer_list_append (_tmp48_, (ValaCCodeExpression*) _tmp50_);
					_vala_ccode_node_unref0 (_tmp50_);
					_tmp51_ = vala_ccode_declaration_new ("const GDBusArgInfo");
					_cdecl_ = _tmp51_;
					_tmp52_ = _cdecl_;
					_tmp53_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp54_ = _tmp53_;
					_tmp55_ = g_strconcat ("_", _tmp54_, NULL);
					_tmp56_ = _tmp55_;
					_tmp57_ = g_strconcat (_tmp56_, "dbus_arg_info_", NULL);
					_tmp58_ = _tmp57_;
					_tmp59_ = sig;
					_tmp60_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp59_, NULL);
					_tmp61_ = _tmp60_;
					_tmp62_ = g_strconcat (_tmp58_, _tmp61_, NULL);
					_tmp63_ = _tmp62_;
					_tmp64_ = g_strconcat (_tmp63_, "_", NULL);
					_tmp65_ = _tmp64_;
					_tmp66_ = param;
					_tmp67_ = vala_symbol_get_name ((ValaSymbol*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = g_strconcat (_tmp65_, _tmp68_, NULL);
					_tmp70_ = _tmp69_;
					_tmp71_ = info;
					_tmp72_ = vala_ccode_variable_declarator_new (_tmp70_, (ValaCCodeExpression*) _tmp71_, NULL);
					_tmp73_ = _tmp72_;
					vala_ccode_declaration_add_declarator (_tmp52_, (ValaCCodeDeclarator*) _tmp73_);
					_vala_ccode_node_unref0 (_tmp73_);
					_g_free0 (_tmp70_);
					_g_free0 (_tmp65_);
					_g_free0 (_tmp63_);
					_g_free0 (_tmp61_);
					_g_free0 (_tmp58_);
					_g_free0 (_tmp56_);
					_g_free0 (_tmp54_);
					_tmp74_ = _cdecl_;
					vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp74_, VALA_CCODE_MODIFIERS_STATIC);
					_tmp75_ = ((ValaCCodeBaseModule*) self)->cfile;
					_tmp76_ = _cdecl_;
					vala_ccode_file_add_constant_declaration (_tmp75_, (ValaCCodeNode*) _tmp76_);
					_tmp77_ = args_info;
					_tmp78_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
					_tmp79_ = _tmp78_;
					_tmp80_ = g_strconcat ("_", _tmp79_, NULL);
					_tmp81_ = _tmp80_;
					_tmp82_ = g_strconcat (_tmp81_, "dbus_arg_info_", NULL);
					_tmp83_ = _tmp82_;
					_tmp84_ = sig;
					_tmp85_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp84_, NULL);
					_tmp86_ = _tmp85_;
					_tmp87_ = g_strconcat (_tmp83_, _tmp86_, NULL);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strconcat (_tmp88_, "_", NULL);
					_tmp90_ = _tmp89_;
					_tmp91_ = param;
					_tmp92_ = vala_symbol_get_name ((ValaSymbol*) _tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = g_strconcat (_tmp90_, _tmp93_, NULL);
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp97_);
					_tmp99_ = _tmp98_;
					vala_ccode_initializer_list_append (_tmp77_, (ValaCCodeExpression*) _tmp99_);
					_vala_ccode_node_unref0 (_tmp99_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					_g_free0 (_tmp86_);
					_g_free0 (_tmp83_);
					_g_free0 (_tmp81_);
					_g_free0 (_tmp79_);
					_vala_ccode_node_unref0 (_cdecl_);
					_vala_ccode_node_unref0 (info);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp100_ = args_info;
			_tmp101_ = vala_ccode_constant_new ("NULL");
			_tmp102_ = _tmp101_;
			vala_ccode_initializer_list_append (_tmp100_, (ValaCCodeExpression*) _tmp102_);
			_vala_ccode_node_unref0 (_tmp102_);
			_tmp103_ = vala_ccode_declaration_new ("const GDBusArgInfo * const");
			_cdecl_ = _tmp103_;
			_tmp104_ = _cdecl_;
			_tmp105_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp106_ = _tmp105_;
			_tmp107_ = g_strconcat ("_", _tmp106_, NULL);
			_tmp108_ = _tmp107_;
			_tmp109_ = g_strconcat (_tmp108_, "dbus_arg_info_", NULL);
			_tmp110_ = _tmp109_;
			_tmp111_ = sig;
			_tmp112_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp111_, NULL);
			_tmp113_ = _tmp112_;
			_tmp114_ = g_strconcat (_tmp110_, _tmp113_, NULL);
			_tmp115_ = _tmp114_;
			_tmp116_ = g_strconcat (_tmp115_, "[]", NULL);
			_tmp117_ = _tmp116_;
			_tmp118_ = args_info;
			_tmp119_ = vala_ccode_variable_declarator_new (_tmp117_, (ValaCCodeExpression*) _tmp118_, NULL);
			_tmp120_ = _tmp119_;
			vala_ccode_declaration_add_declarator (_tmp104_, (ValaCCodeDeclarator*) _tmp120_);
			_vala_ccode_node_unref0 (_tmp120_);
			_g_free0 (_tmp117_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp113_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp108_);
			_g_free0 (_tmp106_);
			_tmp121_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp121_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp122_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp123_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp122_, (ValaCCodeNode*) _tmp123_);
			_tmp124_ = vala_ccode_initializer_list_new ();
			info = _tmp124_;
			_tmp125_ = info;
			_tmp126_ = vala_ccode_constant_new ("-1");
			_tmp127_ = _tmp126_;
			vala_ccode_initializer_list_append (_tmp125_, (ValaCCodeExpression*) _tmp127_);
			_vala_ccode_node_unref0 (_tmp127_);
			_tmp128_ = info;
			_tmp129_ = sig;
			_tmp130_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp129_);
			_tmp131_ = _tmp130_;
			_tmp132_ = g_strdup_printf ("\"%s\"", _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = vala_ccode_constant_new (_tmp133_);
			_tmp135_ = _tmp134_;
			vala_ccode_initializer_list_append (_tmp128_, (ValaCCodeExpression*) _tmp135_);
			_vala_ccode_node_unref0 (_tmp135_);
			_g_free0 (_tmp133_);
			_g_free0 (_tmp131_);
			_tmp136_ = info;
			_tmp137_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp138_ = _tmp137_;
			_tmp139_ = g_strconcat ("_", _tmp138_, NULL);
			_tmp140_ = _tmp139_;
			_tmp141_ = g_strconcat (_tmp140_, "dbus_arg_info_", NULL);
			_tmp142_ = _tmp141_;
			_tmp143_ = sig;
			_tmp144_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp143_, NULL);
			_tmp145_ = _tmp144_;
			_tmp146_ = g_strconcat (_tmp142_, _tmp145_, NULL);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_ccode_identifier_new (_tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp151_, "GDBusArgInfo **");
			_tmp153_ = _tmp152_;
			vala_ccode_initializer_list_append (_tmp136_, (ValaCCodeExpression*) _tmp153_);
			_vala_ccode_node_unref0 (_tmp153_);
			_vala_ccode_node_unref0 (_tmp151_);
			_vala_ccode_node_unref0 (_tmp149_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp145_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp140_);
			_g_free0 (_tmp138_);
			_tmp154_ = info;
			_tmp155_ = vala_ccode_constant_new ("NULL");
			_tmp156_ = _tmp155_;
			vala_ccode_initializer_list_append (_tmp154_, (ValaCCodeExpression*) _tmp156_);
			_vala_ccode_node_unref0 (_tmp156_);
			_tmp157_ = vala_ccode_declaration_new ("const GDBusSignalInfo");
			_vala_ccode_node_unref0 (_cdecl_);
			_cdecl_ = _tmp157_;
			_tmp158_ = _cdecl_;
			_tmp159_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp160_ = _tmp159_;
			_tmp161_ = g_strconcat ("_", _tmp160_, NULL);
			_tmp162_ = _tmp161_;
			_tmp163_ = g_strconcat (_tmp162_, "dbus_signal_info_", NULL);
			_tmp164_ = _tmp163_;
			_tmp165_ = sig;
			_tmp166_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp165_, NULL);
			_tmp167_ = _tmp166_;
			_tmp168_ = g_strconcat (_tmp164_, _tmp167_, NULL);
			_tmp169_ = _tmp168_;
			_tmp170_ = info;
			_tmp171_ = vala_ccode_variable_declarator_new (_tmp169_, (ValaCCodeExpression*) _tmp170_, NULL);
			_tmp172_ = _tmp171_;
			vala_ccode_declaration_add_declarator (_tmp158_, (ValaCCodeDeclarator*) _tmp172_);
			_vala_ccode_node_unref0 (_tmp172_);
			_g_free0 (_tmp169_);
			_g_free0 (_tmp167_);
			_g_free0 (_tmp164_);
			_g_free0 (_tmp162_);
			_g_free0 (_tmp160_);
			_tmp173_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp173_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp174_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp175_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp174_, (ValaCCodeNode*) _tmp175_);
			_tmp176_ = infos;
			_tmp177_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp178_ = _tmp177_;
			_tmp179_ = g_strconcat ("_", _tmp178_, NULL);
			_tmp180_ = _tmp179_;
			_tmp181_ = g_strconcat (_tmp180_, "dbus_signal_info_", NULL);
			_tmp182_ = _tmp181_;
			_tmp183_ = sig;
			_tmp184_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp183_, NULL);
			_tmp185_ = _tmp184_;
			_tmp186_ = g_strconcat (_tmp182_, _tmp185_, NULL);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_ccode_identifier_new (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp189_);
			_tmp191_ = _tmp190_;
			vala_ccode_initializer_list_append (_tmp176_, (ValaCCodeExpression*) _tmp191_);
			_vala_ccode_node_unref0 (_tmp191_);
			_vala_ccode_node_unref0 (_tmp189_);
			_g_free0 (_tmp187_);
			_g_free0 (_tmp185_);
			_g_free0 (_tmp182_);
			_g_free0 (_tmp180_);
			_g_free0 (_tmp178_);
			_vala_ccode_node_unref0 (info);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (args_info);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp192_ = infos;
	_tmp193_ = vala_ccode_constant_new ("NULL");
	_tmp194_ = _tmp193_;
	vala_ccode_initializer_list_append (_tmp192_, (ValaCCodeExpression*) _tmp194_);
	_vala_ccode_node_unref0 (_tmp194_);
	_tmp195_ = vala_ccode_declaration_new ("const GDBusSignalInfo * const");
	_cdecl_ = _tmp195_;
	_tmp196_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp197_ = _tmp196_;
	_tmp198_ = g_strconcat ("_", _tmp197_, NULL);
	_tmp199_ = _tmp198_;
	_tmp200_ = g_strconcat (_tmp199_, "dbus_signal_info[]", NULL);
	_tmp201_ = _tmp200_;
	_tmp202_ = infos;
	_tmp203_ = vala_ccode_variable_declarator_new (_tmp201_, (ValaCCodeExpression*) _tmp202_, NULL);
	_tmp204_ = _tmp203_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp204_);
	_vala_ccode_node_unref0 (_tmp204_);
	_g_free0 (_tmp201_);
	_g_free0 (_tmp199_);
	_g_free0 (_tmp197_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp205_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp205_, (ValaCCodeNode*) _cdecl_);
	_tmp206_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp207_ = _tmp206_;
	_tmp208_ = g_strconcat ("_", _tmp207_, NULL);
	_tmp209_ = _tmp208_;
	_tmp210_ = g_strconcat (_tmp209_, "dbus_signal_info", NULL);
	_tmp211_ = _tmp210_;
	_tmp212_ = vala_ccode_identifier_new (_tmp211_);
	_tmp213_ = (ValaCCodeExpression*) _tmp212_;
	_g_free0 (_tmp211_);
	_g_free0 (_tmp209_);
	_g_free0 (_tmp207_);
	result = _tmp213_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}

static ValaCCodeExpression*
vala_gd_bus_module_get_property_info (ValaGDBusModule* self,
                                      ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* infos = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeInitializerList* _tmp108_;
	ValaCCodeConstant* _tmp109_;
	ValaCCodeConstant* _tmp110_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	ValaCCodeInitializerList* _tmp118_;
	ValaCCodeVariableDeclarator* _tmp119_;
	ValaCCodeVariableDeclarator* _tmp120_;
	ValaCCodeFile* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	ValaCCodeIdentifier* _tmp128_;
	ValaCCodeExpression* _tmp129_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	infos = _tmp0_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _prop_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _prop_index = 0;
		_tmp1_ = vala_object_type_symbol_get_properties (sym);
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_prop_list = _tmp2_;
		_tmp3_ = _prop_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_prop_size = _tmp5_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaProperty* prop = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaProperty* _tmp12_;
			ValaMemberBinding _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaProperty* _tmp21_;
			ValaCCodeInitializerList* info = NULL;
			ValaCCodeInitializerList* _tmp22_;
			ValaCCodeInitializerList* _tmp23_;
			ValaCCodeConstant* _tmp24_;
			ValaCCodeConstant* _tmp25_;
			ValaCCodeInitializerList* _tmp26_;
			ValaProperty* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValaCCodeConstant* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			ValaCCodeInitializerList* _tmp34_;
			ValaProperty* _tmp35_;
			ValaDataType* _tmp36_;
			ValaDataType* _tmp37_;
			ValaProperty* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			gboolean _tmp45_ = FALSE;
			ValaProperty* _tmp46_;
			ValaPropertyAccessor* _tmp47_;
			ValaPropertyAccessor* _tmp48_;
			ValaCCodeInitializerList* _tmp70_;
			ValaCCodeConstant* _tmp71_;
			ValaCCodeConstant* _tmp72_;
			ValaCCodeDeclaration* _cdecl_ = NULL;
			ValaCCodeDeclaration* _tmp73_;
			ValaCCodeDeclaration* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			ValaProperty* _tmp81_;
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			ValaCCodeInitializerList* _tmp86_;
			ValaCCodeVariableDeclarator* _tmp87_;
			ValaCCodeVariableDeclarator* _tmp88_;
			ValaCCodeDeclaration* _tmp89_;
			ValaCCodeFile* _tmp90_;
			ValaCCodeDeclaration* _tmp91_;
			ValaCCodeInitializerList* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			ValaProperty* _tmp99_;
			const gchar* _tmp100_;
			const gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			ValaCCodeIdentifier* _tmp104_;
			ValaCCodeIdentifier* _tmp105_;
			ValaCCodeUnaryExpression* _tmp106_;
			ValaCCodeUnaryExpression* _tmp107_;
			_prop_index = _prop_index + 1;
			_tmp6_ = _prop_index;
			_tmp7_ = _prop_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prop_list;
			_tmp9_ = vala_list_get (_tmp8_, _prop_index);
			prop = (ValaProperty*) _tmp9_;
			_tmp12_ = prop;
			_tmp13_ = vala_property_get_binding (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != VALA_MEMBER_BINDING_INSTANCE) {
				_tmp11_ = TRUE;
			} else {
				ValaProperty* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = prop;
				_tmp16_ = vala_property_get_overrides (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = _tmp17_;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				ValaProperty* _tmp18_;
				ValaSymbolAccessibility _tmp19_;
				ValaSymbolAccessibility _tmp20_;
				_tmp18_ = prop;
				_tmp19_ = vala_symbol_get_access ((ValaSymbol*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp10_ = _tmp20_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp10_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp21_ = prop;
			if (!vala_gd_bus_module_is_dbus_visible ((ValaCodeNode*) _tmp21_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp22_ = vala_ccode_initializer_list_new ();
			info = _tmp22_;
			_tmp23_ = info;
			_tmp24_ = vala_ccode_constant_new ("-1");
			_tmp25_ = _tmp24_;
			vala_ccode_initializer_list_append (_tmp23_, (ValaCCodeExpression*) _tmp25_);
			_vala_ccode_node_unref0 (_tmp25_);
			_tmp26_ = info;
			_tmp27_ = prop;
			_tmp28_ = vala_gd_bus_module_get_dbus_name_for_member ((ValaSymbol*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("\"%s\"", _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_ccode_constant_new (_tmp31_);
			_tmp33_ = _tmp32_;
			vala_ccode_initializer_list_append (_tmp26_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_tmp34_ = info;
			_tmp35_ = prop;
			_tmp36_ = vala_property_get_property_type (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = prop;
			_tmp39_ = vala_data_type_get_type_signature (_tmp37_, (ValaSymbol*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strdup_printf ("\"%s\"", _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_constant_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_initializer_list_append (_tmp34_, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_tmp46_ = prop;
			_tmp47_ = vala_property_get_get_accessor (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_ != NULL) {
				ValaProperty* _tmp49_;
				ValaPropertyAccessor* _tmp50_;
				ValaPropertyAccessor* _tmp51_;
				_tmp49_ = prop;
				_tmp50_ = vala_property_get_set_accessor (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp45_ = _tmp51_ != NULL;
			} else {
				_tmp45_ = FALSE;
			}
			if (_tmp45_) {
				ValaCCodeInitializerList* _tmp52_;
				ValaCCodeConstant* _tmp53_;
				ValaCCodeConstant* _tmp54_;
				_tmp52_ = info;
				_tmp53_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITA" \
"BLE");
				_tmp54_ = _tmp53_;
				vala_ccode_initializer_list_append (_tmp52_, (ValaCCodeExpression*) _tmp54_);
				_vala_ccode_node_unref0 (_tmp54_);
			} else {
				ValaProperty* _tmp55_;
				ValaPropertyAccessor* _tmp56_;
				ValaPropertyAccessor* _tmp57_;
				_tmp55_ = prop;
				_tmp56_ = vala_property_get_get_accessor (_tmp55_);
				_tmp57_ = _tmp56_;
				if (_tmp57_ != NULL) {
					ValaCCodeInitializerList* _tmp58_;
					ValaCCodeConstant* _tmp59_;
					ValaCCodeConstant* _tmp60_;
					_tmp58_ = info;
					_tmp59_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_READABLE");
					_tmp60_ = _tmp59_;
					vala_ccode_initializer_list_append (_tmp58_, (ValaCCodeExpression*) _tmp60_);
					_vala_ccode_node_unref0 (_tmp60_);
				} else {
					ValaProperty* _tmp61_;
					ValaPropertyAccessor* _tmp62_;
					ValaPropertyAccessor* _tmp63_;
					_tmp61_ = prop;
					_tmp62_ = vala_property_get_set_accessor (_tmp61_);
					_tmp63_ = _tmp62_;
					if (_tmp63_ != NULL) {
						ValaCCodeInitializerList* _tmp64_;
						ValaCCodeConstant* _tmp65_;
						ValaCCodeConstant* _tmp66_;
						_tmp64_ = info;
						_tmp65_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE");
						_tmp66_ = _tmp65_;
						vala_ccode_initializer_list_append (_tmp64_, (ValaCCodeExpression*) _tmp66_);
						_vala_ccode_node_unref0 (_tmp66_);
					} else {
						ValaCCodeInitializerList* _tmp67_;
						ValaCCodeConstant* _tmp68_;
						ValaCCodeConstant* _tmp69_;
						_tmp67_ = info;
						_tmp68_ = vala_ccode_constant_new ("G_DBUS_PROPERTY_INFO_FLAGS_NONE");
						_tmp69_ = _tmp68_;
						vala_ccode_initializer_list_append (_tmp67_, (ValaCCodeExpression*) _tmp69_);
						_vala_ccode_node_unref0 (_tmp69_);
					}
				}
			}
			_tmp70_ = info;
			_tmp71_ = vala_ccode_constant_new ("NULL");
			_tmp72_ = _tmp71_;
			vala_ccode_initializer_list_append (_tmp70_, (ValaCCodeExpression*) _tmp72_);
			_vala_ccode_node_unref0 (_tmp72_);
			_tmp73_ = vala_ccode_declaration_new ("const GDBusPropertyInfo");
			_cdecl_ = _tmp73_;
			_tmp74_ = _cdecl_;
			_tmp75_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp76_ = _tmp75_;
			_tmp77_ = g_strconcat ("_", _tmp76_, NULL);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strconcat (_tmp78_, "dbus_property_info_", NULL);
			_tmp80_ = _tmp79_;
			_tmp81_ = prop;
			_tmp82_ = vala_symbol_get_name ((ValaSymbol*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = g_strconcat (_tmp80_, _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			_tmp86_ = info;
			_tmp87_ = vala_ccode_variable_declarator_new (_tmp85_, (ValaCCodeExpression*) _tmp86_, NULL);
			_tmp88_ = _tmp87_;
			vala_ccode_declaration_add_declarator (_tmp74_, (ValaCCodeDeclarator*) _tmp88_);
			_vala_ccode_node_unref0 (_tmp88_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp78_);
			_g_free0 (_tmp76_);
			_tmp89_ = _cdecl_;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp89_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp90_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp91_ = _cdecl_;
			vala_ccode_file_add_constant_declaration (_tmp90_, (ValaCCodeNode*) _tmp91_);
			_tmp92_ = infos;
			_tmp93_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
			_tmp94_ = _tmp93_;
			_tmp95_ = g_strconcat ("_", _tmp94_, NULL);
			_tmp96_ = _tmp95_;
			_tmp97_ = g_strconcat (_tmp96_, "dbus_property_info_", NULL);
			_tmp98_ = _tmp97_;
			_tmp99_ = prop;
			_tmp100_ = vala_symbol_get_name ((ValaSymbol*) _tmp99_);
			_tmp101_ = _tmp100_;
			_tmp102_ = g_strconcat (_tmp98_, _tmp101_, NULL);
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_ccode_identifier_new (_tmp103_);
			_tmp105_ = _tmp104_;
			_tmp106_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp105_);
			_tmp107_ = _tmp106_;
			vala_ccode_initializer_list_append (_tmp92_, (ValaCCodeExpression*) _tmp107_);
			_vala_ccode_node_unref0 (_tmp107_);
			_vala_ccode_node_unref0 (_tmp105_);
			_g_free0 (_tmp103_);
			_g_free0 (_tmp98_);
			_g_free0 (_tmp96_);
			_g_free0 (_tmp94_);
			_vala_ccode_node_unref0 (_cdecl_);
			_vala_ccode_node_unref0 (info);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp108_ = infos;
	_tmp109_ = vala_ccode_constant_new ("NULL");
	_tmp110_ = _tmp109_;
	vala_ccode_initializer_list_append (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_declaration_new ("const GDBusPropertyInfo * const");
	_cdecl_ = _tmp111_;
	_tmp112_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp113_ = _tmp112_;
	_tmp114_ = g_strconcat ("_", _tmp113_, NULL);
	_tmp115_ = _tmp114_;
	_tmp116_ = g_strconcat (_tmp115_, "dbus_property_info[]", NULL);
	_tmp117_ = _tmp116_;
	_tmp118_ = infos;
	_tmp119_ = vala_ccode_variable_declarator_new (_tmp117_, (ValaCCodeExpression*) _tmp118_, NULL);
	_tmp120_ = _tmp119_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp120_);
	_vala_ccode_node_unref0 (_tmp120_);
	_g_free0 (_tmp117_);
	_g_free0 (_tmp115_);
	_g_free0 (_tmp113_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp121_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp121_, (ValaCCodeNode*) _cdecl_);
	_tmp122_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_strconcat ("_", _tmp123_, NULL);
	_tmp125_ = _tmp124_;
	_tmp126_ = g_strconcat (_tmp125_, "dbus_property_info", NULL);
	_tmp127_ = _tmp126_;
	_tmp128_ = vala_ccode_identifier_new (_tmp127_);
	_tmp129_ = (ValaCCodeExpression*) _tmp128_;
	_g_free0 (_tmp127_);
	_g_free0 (_tmp125_);
	_g_free0 (_tmp123_);
	result = _tmp129_;
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (infos);
	return result;
}

static void
vala_gd_bus_module_declare_interface_info (ValaGDBusModule* self,
                                           ValaObjectTypeSymbol* sym)
{
	ValaCCodeInitializerList* info = NULL;
	ValaCCodeInitializerList* _tmp0_;
	ValaCCodeConstant* _tmp1_;
	ValaCCodeConstant* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeExpression* _tmp10_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeUnaryExpression* _tmp12_;
	ValaCCodeCastExpression* _tmp13_;
	ValaCCodeCastExpression* _tmp14_;
	ValaCCodeExpression* _tmp15_;
	ValaCCodeExpression* _tmp16_;
	ValaCCodeUnaryExpression* _tmp17_;
	ValaCCodeUnaryExpression* _tmp18_;
	ValaCCodeCastExpression* _tmp19_;
	ValaCCodeCastExpression* _tmp20_;
	ValaCCodeExpression* _tmp21_;
	ValaCCodeExpression* _tmp22_;
	ValaCCodeUnaryExpression* _tmp23_;
	ValaCCodeUnaryExpression* _tmp24_;
	ValaCCodeCastExpression* _tmp25_;
	ValaCCodeCastExpression* _tmp26_;
	ValaCCodeConstant* _tmp27_;
	ValaCCodeConstant* _tmp28_;
	ValaCCodeDeclaration* _cdecl_ = NULL;
	ValaCCodeDeclaration* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValaCCodeVariableDeclarator* _tmp36_;
	ValaCCodeVariableDeclarator* _tmp37_;
	ValaCCodeFile* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_ccode_initializer_list_new ();
	info = _tmp0_;
	_tmp1_ = vala_ccode_constant_new ("-1");
	_tmp2_ = _tmp1_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp2_);
	_vala_ccode_node_unref0 (_tmp2_);
	_tmp3_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("\"%s\"", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_constant_new (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp8_);
	_vala_ccode_node_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = vala_gd_bus_module_get_method_info (self, sym);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp12_, "GDBusMethodInfo **");
	_tmp14_ = _tmp13_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_vala_ccode_node_unref0 (_tmp12_);
	_vala_ccode_node_unref0 (_tmp10_);
	_tmp15_ = vala_gd_bus_module_get_signal_info (self, sym);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp18_, "GDBusSignalInfo **");
	_tmp20_ = _tmp19_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_vala_ccode_node_unref0 (_tmp18_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp21_ = vala_gd_bus_module_get_property_info (self, sym);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp24_, "GDBusPropertyInfo **");
	_tmp26_ = _tmp25_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp26_);
	_vala_ccode_node_unref0 (_tmp26_);
	_vala_ccode_node_unref0 (_tmp24_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp27_ = vala_ccode_constant_new ("NULL");
	_tmp28_ = _tmp27_;
	vala_ccode_initializer_list_append (info, (ValaCCodeExpression*) _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = vala_ccode_declaration_new ("const GDBusInterfaceInfo");
	_cdecl_ = _tmp29_;
	_tmp30_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat ("_", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp33_, "dbus_interface_info", NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_variable_declarator_new (_tmp35_, (ValaCCodeExpression*) info, NULL);
	_tmp37_ = _tmp36_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp37_);
	_vala_ccode_node_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp38_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_constant_declaration (_tmp38_, (ValaCCodeNode*) _cdecl_);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (info);
}

ValaCCodeExpression*
vala_gd_bus_module_get_interface_info (ValaGDBusModule* self,
                                       ValaObjectTypeSymbol* sym)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("_", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "dbus_interface_info", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_identifier_new (_tmp5_);
	_tmp7_ = (ValaCCodeExpression*) _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

static void
vala_gd_bus_module_real_visit_class (ValaCodeVisitor* base,
                                     ValaClass* cl)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), cl);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) cl);
}

static void
vala_gd_bus_module_real_visit_interface (ValaCodeVisitor* base,
                                         ValaInterface* iface)
{
	ValaGDBusModule * self;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (iface != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_interface ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule), iface);
	vala_gd_bus_module_visit_object_type_symbol (self, (ValaObjectTypeSymbol*) iface);
}

static void
vala_gd_bus_module_visit_object_type_symbol (ValaGDBusModule* self,
                                             ValaObjectTypeSymbol* sym)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	vala_gd_bus_module_declare_interface_info (self, sym);
}

ValaGDBusModule*
vala_gd_bus_module_construct (GType object_type)
{
	ValaGDBusModule* self = NULL;
	self = (ValaGDBusModule*) vala_gvariant_module_construct (object_type);
	return self;
}

ValaGDBusModule*
vala_gd_bus_module_new (void)
{
	return vala_gd_bus_module_construct (VALA_TYPE_GD_BUS_MODULE);
}

static void
vala_gd_bus_module_class_init (ValaGDBusModuleClass * klass,
                               gpointer klass_data)
{
	vala_gd_bus_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gd_bus_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gd_bus_module_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_gd_bus_module_real_visit_interface;
}

static void
vala_gd_bus_module_instance_init (ValaGDBusModule * self,
                                  gpointer klass)
{
}

static GType
vala_gd_bus_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gd_bus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGDBusModule), 0, (GInstanceInitFunc) vala_gd_bus_module_instance_init, NULL };
	GType vala_gd_bus_module_type_id;
	vala_gd_bus_module_type_id = g_type_register_static (VALA_TYPE_GVARIANT_MODULE, "ValaGDBusModule", &g_define_type_info, 0);
	return vala_gd_bus_module_type_id;
}

GType
vala_gd_bus_module_get_type (void)
{
	static volatile gsize vala_gd_bus_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gd_bus_module_type_id__volatile)) {
		GType vala_gd_bus_module_type_id;
		vala_gd_bus_module_type_id = vala_gd_bus_module_get_type_once ();
		g_once_init_leave (&vala_gd_bus_module_type_id__volatile, vala_gd_bus_module_type_id);
	}
	return vala_gd_bus_module_type_id__volatile;
}

