# BuildPlugin.cmake - Copyright (c) 2017-2019 Tobias Junghans
#
# description: build Veyon plugin
# usage: BUILD_PLUGIN(<NAME> <SOURCES> MOCFILES <HEADERS> RESOURCES <QRCFILES> FORMS <UIFILES> LINK <SHARED|MODULE>)

MACRO(BUILD_PLUGIN PLUGIN_NAME)
	CMAKE_PARSE_ARGUMENTS(PLUGIN "COTIRE" "" "MOCFILES;RESOURCES;FORMS;LINK" ${ARGN})
	SET(PLUGIN_SOURCES ${PLUGIN_UNPARSED_ARGUMENTS})

	INCLUDE_DIRECTORIES(${CMAKE_CURRENT_BINARY_DIR} ${CMAKE_CURRENT_SOURCE_DIR})

	QT5_WRAP_CPP(plugin_MOC_out ${PLUGIN_MOCFILES})
	QT5_WRAP_UI(plugin_UIC_out ${PLUGIN_FORMS})
	QT5_ADD_RESOURCES(plugin_RCC_out ${PLUGIN_RESOURCES})

	FOREACH(f ${PLUGIN_SOURCES})
		ADD_FILE_DEPENDENCIES(${f} ${plugin_UIC_out})
	ENDFOREACH(f)

	IF ("${PLUGIN_LINK}" STREQUAL "SHARED")
	  ADD_LIBRARY(${PLUGIN_NAME} SHARED ${PLUGIN_SOURCES} ${plugin_MOC_out} ${plugin_RCC_out})
	ELSE ()
	  ADD_LIBRARY(${PLUGIN_NAME} MODULE ${PLUGIN_SOURCES} ${plugin_MOC_out} ${plugin_RCC_out})
	ENDIF ()
	
	TARGET_LINK_LIBRARIES(${PLUGIN_NAME} Qt5::Widgets Qt5::Network)

	TARGET_LINK_LIBRARIES(${PLUGIN_NAME} veyon-core)

	SET_TARGET_PROPERTIES(${PLUGIN_NAME} PROPERTIES PREFIX "")
	SET_TARGET_PROPERTIES(${PLUGIN_NAME} PROPERTIES LINK_FLAGS "-Wl,-no-undefined")
	INSTALL(TARGETS ${PLUGIN_NAME} LIBRARY DESTINATION ${VEYON_LIB_DIR})

	SET_DIRECTORY_PROPERTIES(PROPERTIES ADDITIONAL_MAKE_CLEAN_FILES "${plugin_MOC_out} ${plugin_RCC_out}")

	IF(PLUGIN_COTIRE)
		COTIRE_VEYON(${PLUGIN_NAME})
	ENDIF()
ENDMACRO(BUILD_PLUGIN)

