/*
    The WebDruid - a web server log analysis program

    Copyright (C) 2003-2004  Fabien Chevalier (fabien@juliana-multimedia.com)

    Original webalizer copyright:
    Copyright (C) 1997-2001  Bradford L. Barrett (brad@mrunix.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

    This software uses the gd graphics library, which is copyright by
    Quest Protein Database Center, Cold Spring Harbor Labs.  Please
    see the documentation supplied with the library for additional
    information and license terms, or visit www.boutell.com/gd/ for the
    most recent version of the library and supporting documentation.
*/

#ifndef _PRESERVE_H
#define _PRESERVE_H

/*
   This constant defines the version we use for on disk temporary statistics storage
   (aka incremental mode).
   This is to be increased each time changes are made that would make a new release
   of webdruid unable to read the old format.
   The policy for now is to display a warning when an old file is found, and then to
   ignore it.
*/

#define INCREMENTAL_VERSION 1

/*
   History file - used to keep track of what we computed for previous months.
*/

#define HISTORY_FILENAME "webalizer.hist"

extern void    get_history();                 /* load history file        */
extern void    put_history();                 /* save history file        */
extern int     save_state();                  /* save run state           */
extern int     restore_state();               /* restore run state        */

extern int     hist_month[12];                /* arrays for monthly total */
extern int     hist_year[12];
extern u_long  hist_hit[12];                  /* calculations: used to    */
extern u_long  hist_files[12];                /* produce index.html       */
extern u_long  hist_site[12];                 /* these are read and saved */
extern double  hist_xfer[12];                 /* in the history file      */
extern u_long  hist_page[12];
extern u_long  hist_visit[12];

extern int     hist_fday[12];                 /* first/last day arrays    */
extern int     hist_lday[12];

#endif  /* _PRESERVE_H */
