import os, sys
if __name__ == '__main__': 
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Setup a log file
#os.environ['STUPID_LOG_FILE'] = os.path.join(os.getcwd(), 'zLOG.log')
#os.environ['STUPID_LOG_SEVERITY'] = '-200'  # DEBUG

from Testing import ZopeTestCase

from Acquisition import aq_base
from AccessControl import getSecurityManager, Unauthorized

standard_permissions = ZopeTestCase.standard_permissions
access_permissions   = ['Search & replace in objects'] 
change_permissions   = ['Change Python Scripts', 'Change Database Methods', 
                        'Change Page Templates', 'Change DTML Methods',
                        'Change DTML Documents']

_searchterm           = 'abc'
_replaceterm          = 'xyz'
_params_text          = 'test_abc_params'
_params_text_replaced = 'test_xyz_params'
_body_text            = 'test_abc_body'
_body_text_replaced   = 'test_xyz_body'

# Guard against failure if PageTemplates are not available
_pt = ZopeTestCase.hasProduct('PageTemplates')

ZopeTestCase.installProduct('ZSQLMethods')
ZopeTestCase.installProduct('PythonScripts')
ZopeTestCase.installProduct('PageTemplates')
ZopeTestCase.installProduct('ReplaceSupport')


class TestReplaceSupport(ZopeTestCase.ZopeTestCase):

    def afterSetUp(self):
        'Set up the objects we intend to test'
        disp = self.folder.manage_addProduct['PythonScripts']
        disp.manage_addPythonScript('ps')
        self.ps = self.folder['ps']
        self.ps.ZPythonScript_edit(_params_text, _body_text)

        disp = self.folder.manage_addProduct['ZSQLMethods']
        disp.manage_addZSQLMethod('zm', '', 'conn', _params_text, _body_text)
        self.zm = self.folder['zm']

        if _pt: 
            disp = self.folder.manage_addProduct['PageTemplates']
            disp.manage_addPageTemplate('pt', text=_body_text)
            self.pt = self.folder['pt']

        self.folder.addDTMLMethod('dm', file=_body_text)
        self.dm = self.folder['dm']

        self.folder.addDTMLDocument('dd', file=_body_text)
        self.dd = self.folder['dd']

    # Test fixture ##################################################

    def test_02_FixturePS(self):
        'PythonScript should exist'
        assert hasattr(self.folder, 'ps'), 'No object'
        assert self.ps.body() == _body_text+'\n', 'Body mismatch'
        assert self.ps.params() == _params_text, 'Params mismatch'

    def test_02_FixtureZM(self):
        'ZSQLMethod should exist'
        assert hasattr(self.folder, 'zm'), 'No object'
        assert self.zm.src == _body_text, 'Body mismatch'
        assert self.zm.arguments_src == _params_text, 'Params mismatch'

    if _pt:
        def test_02_FixturePT(self):
            'PageTemplate should exist'
            assert hasattr(self.folder, 'pt'), 'No object'
            assert self.pt._text == _body_text, 'Body mismatch'

    def test_02_FixtureDM(self):
        'DTMLMethod should exist'
        assert hasattr(self.folder, 'dm'), 'No object'
        assert self.dm.raw == _body_text, 'Body mismatch'

    def test_02_FixtureDT(self):
        'DTMLDocument should exist'
        assert hasattr(self.folder, 'dd'), 'No object'
        assert self.dd.raw == _body_text, 'Body mismatch'

    # Test installation #############################################

    def test_03_Installed(self):
        'ZopeReplace method should be available'
        assert hasattr(aq_base(self.folder), 'ZopeReplace'), 'ZopeReplace is not installed'

    def test_03_Registry(self):
        '_ReplaceHandlerRegistry should be available'
        assert hasattr(aq_base(self.folder), '_ReplaceHandlerRegistry'), 'Handler registry is not installed'

    # Test handlers #################################################

    def test_04_HandlerPS(self):
        'PythonScript handler should exist'
        handler = self.folder._ReplaceHandlerRegistry.getHandler('Script (Python)')
        assert handler is not None, 'No handler'
        perm = handler.getChangePermission()
        assert perm == 'Change Python Scripts', 'Unexpected change permission'

    def test_04_HandlerZM(self):
        'ZSQLMethod handler should exist'
        handler = self.folder._ReplaceHandlerRegistry.getHandler('Z SQL Method')
        assert handler is not None, 'No handler'
        perm = handler.getChangePermission()
        assert perm == 'Change Database Methods', 'Unexpected change permission'

    def test_04_HandlerPT(self):
        'PageTemplate handler should exist'
        handler = self.folder._ReplaceHandlerRegistry.getHandler('Page Template')
        assert handler is not None, 'No handler'
        perm = handler.getChangePermission()
        assert perm == 'Change Page Templates', 'Unexpected change permission'

    def test_04_HandlerDM(self):
        'DTMLMethod handler should exist'
        handler = self.folder._ReplaceHandlerRegistry.getHandler('DTML Method')
        assert handler is not None, 'No handler'
        perm = handler.getChangePermission()
        assert perm == 'Change DTML Methods', 'Unexpected change permission'

    def test_04_HandlerDD(self):
        'DTMLDocument handler should exist'
        handler = self.folder._ReplaceHandlerRegistry.getHandler('DTML Document')
        assert handler is not None, 'No handler'
        perm = handler.getChangePermission()
        assert perm == 'Change DTML Documents', 'Unexpected change permission'

    # Test replace code #############################################

    def test_05_ReplacePS(self):
        'PythonScript handler should work'
        self.folder._ZopeReplace(self.folder, obj_ids=['ps'],
                                 obj_searchterm=_searchterm, 
                                 obj_replaceterm=_replaceterm)
        assert self.ps.body() == _body_text_replaced+'\n', 'Body mismatch'
        assert self.ps.params() == _params_text_replaced, 'Params mismatch'

    def test_05_ReplaceZM(self):
        'ZSQLMethod handler should work'
        self.folder._ZopeReplace(self.folder, obj_ids=['zm'],
                                 obj_searchterm=_searchterm, 
                                 obj_replaceterm=_replaceterm)
        assert self.zm.src == _body_text_replaced, 'Body mismatch'
        assert self.zm.arguments_src == _params_text_replaced, 'Params mismatch'

    if _pt:
        def test_05_ReplacePT(self):
            'PageTemplate handler should work'
            self.folder._ZopeReplace(self.folder, obj_ids=['pt'],
                                     obj_searchterm=_searchterm, 
                                     obj_replaceterm=_replaceterm)
            assert self.pt._text == _body_text_replaced, 'Body mismatch'

    def test_05_ReplaceDM(self):
        'DTMLMethod handler should work'
        self.folder._ZopeReplace(self.folder, obj_ids=['dm'],
                                 obj_searchterm=_searchterm, 
                                 obj_replaceterm=_replaceterm)
        assert self.dm.raw == _body_text_replaced, 'Body mismatch'

    def test_05_ReplaceDD(self):
        'DTMLDocument handler should work'
        self.folder._ZopeReplace(self.folder, obj_ids=['dd'],
                                 obj_searchterm=_searchterm, 
                                 obj_replaceterm=_replaceterm) 
        assert self.dd.raw == _body_text_replaced, 'Body mismatch'

    # Test access protection ########################################

    def test_06_AccessAllowed(self):
        'ZopeReplace method should be accessible'
        self.setPermissions(standard_permissions+access_permissions)
        try:
            dummy = self.folder.restrictedTraverse('ZopeReplace')
        except Unauthorized:
            assert 0, 'Access to ZopeReplace was denied'
            
    def test_06_AccessDenied(self):
        'ZopeReplace method should be protected'
        self.setPermissions(standard_permissions+change_permissions)
        try:
            self.folder.restrictedTraverse('ZopeReplace')(
                                self.folder, obj_ids=['dd'],
                                obj_searchterm=_searchterm, 
                                obj_replaceterm=_replaceterm)
        except Unauthorized:
            pass    # test passed
        else:
            assert self.dd.raw == _body_text, 'Access permission did not protect ZopeReplace'
            assert self.dd.raw != _body_text, 'Access to ZopeReplace was denied but did not throw an exception'

    def test_06_AccessDeniedAlias(self):
        'Alias name "PrincipiaReplace" should be protected'
        # PrincipiaReplace is an alias and actually protected by ZopeReplace__roles__
        self.setPermissions(standard_permissions+change_permissions)
        try:
            self.folder.restrictedTraverse('PrincipiaReplace')(
                                self.folder, obj_ids=['dd'],
                                obj_searchterm=_searchterm, 
                                obj_replaceterm=_replaceterm)
        except Unauthorized:
            pass    # test passed
        else:
            assert self.dd.raw == _body_text, 'Access permission did not protect PrincipiaReplace'
            assert self.dd.raw != _body_text, 'Access to PrincipiaReplace was denied but did not throw an exception'

    # Test change protection ########################################

    def test_07_ChangePS(self):
        'PythonScript should be protected'
        self.setPermissions(standard_permissions+access_permissions)
        self.folder.ZopeReplace(self.folder, obj_ids=['ps'],
                                obj_searchterm=_searchterm, 
                                obj_replaceterm=_replaceterm)
        assert self.ps.body() == _body_text+'\n', 'Change permission did not protect object'

    def test_07_ChangeZM(self):
        'ZSQLMethod should be protected'
        self.setPermissions(standard_permissions+access_permissions)
        self.folder.ZopeReplace(self.folder, obj_ids=['zm'],
                                obj_searchterm=_searchterm, 
                                obj_replaceterm=_replaceterm)
        assert self.zm.src == _body_text, 'Change permission did not protect object'

    if _pt:
        def test_07_ChangePT(self):
            'PageTemplate should be protected'
            self.setPermissions(standard_permissions+access_permissions)
            self.folder.ZopeReplace(self.folder, obj_ids=['pt'],
                                    obj_searchterm=_searchterm, 
                                    obj_replaceterm=_replaceterm)
            assert self.pt._text == _body_text, 'Change permission did not protect object'

    def test_07_ChangeDM(self):
        'DTMLMethod should be protected'
        self.setPermissions(standard_permissions+access_permissions)
        self.folder.ZopeReplace(self.folder, obj_ids=['dm'],
                                obj_searchterm=_searchterm, 
                                obj_replaceterm=_replaceterm)
        assert self.dm.raw == _body_text, 'Change permission did not protect object'

    def test_07_ChangeDD(self):
        'DTMLDocument should be protected'
        self.setPermissions(standard_permissions+access_permissions)
        self.folder.ZopeReplace(self.folder, obj_ids=['dd'],
                                obj_searchterm=_searchterm, 
                                obj_replaceterm=_replaceterm)
        assert self.dd.raw == _body_text, 'Change permission did not protect object'

    # Test recursion ################################################

    def test_08_Subdir(self):
        'ZopeReplace should work in subdirectories'
        self.folder.manage_addFolder('sub')
        self.folder.sub.addDTMLDocument('dd', file=_body_text)
        self.folder._ZopeReplace(self.folder, obj_ids=['dd'],
                                 obj_searchterm=_searchterm, 
                                 obj_replaceterm=_replaceterm, 
                                 search_sub=1)
        assert self.folder.sub.dd.raw == _body_text_replaced, 'ZopeReplace did not work recursively'

    # b/w compatibility clutch
    if not hasattr(ZopeTestCase.ZopeTestCase, 'setPermissions'):
        setPermissions = ZopeTestCase.ZopeTestCase._setPermissions


# Required for ZClass testing
app = ZopeTestCase.app()
ZopeTestCase.utils.setupZGlobals(app)
ZopeTestCase.close(app)

class TestReplaceSupportZClass(ZopeTestCase.ZopeTestCase):

    _setup_fixture = 0

    def afterSetUp(self):
        products = self.app.Control_Panel.Products
        products.manage_addProduct('aProduct_', '')
        p = products.aProduct_
        p.manage_addZClass('aZClass_', zope_object=1)
        m = p.aZClass_.propertysheets.methods
        m.manage_addProduct['OFSP'].addDTMLDocument('dd', file=_body_text)
        self.product = p
        self.methods = m

    def test_01_ZClass(self):
        'ZopeReplace should work in ZClass products'
        self.product._ZopeReplace(self.product, obj_ids=['dd'],
                                  obj_searchterm=_searchterm, 
                                  obj_replaceterm=_replaceterm, 
                                  search_sub=1)
        assert self.methods['dd '].raw == _body_text_replaced, 'ZopeReplace did not work in ZClass product'

    def test_02_Dummy(self):
        'Test nothing ;-)'
        pass

 
def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestReplaceSupport))
    suite.addTest(makeSuite(TestReplaceSupportZClass))
    return suite

if __name__ == '__main__': 
    framework()
