/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.io.UnsupportedEncodingException;

public class StringUtil {
    private static final char TWO_BYTE_LIMIT = '\u0080';
    private static final int TWO_BYTE_CONSTANT1 = 192;
    private static final int TWO_BYTE_CONSTANT2 = 128;
    private static final int TWO_BYTE_SHIFT1 = 6;
    private static final int TWO_BYTE_MASK1 = 31;
    private static final int TWO_BYTE_MASK2 = 63;
    private static final char THREE_BYTE_LIMIT = '\u0800';
    private static final int THREE_BYTE_CONSTANT1 = 224;
    private static final int THREE_BYTE_CONSTANT2 = 128;
    private static final int THREE_BYTE_CONSTANT3 = 128;
    private static final int THREE_BYTE_SHIFT1 = 12;
    private static final int THREE_BYTE_SHIFT2 = 6;
    private static final int THREE_BYTE_MASK1 = 15;
    private static final int THREE_BYTE_MASK2 = 63;
    private static final int THREE_BYTE_MASK3 = 63;

    public static byte[] getUtf8Bytes(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n = string.charAt(i);
            n2 += n == 0 ? 2 : (n < 128 ? 1 : (n < 2048 ? 2 : 3));
        }
        byte[] byArray = new byte[n2];
        n = 0;
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '\u0000') {
                byArray[n++] = -64;
                byArray[n++] = -128;
                continue;
            }
            if (c < '\u0080') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n++] = (byte)(0xC0 | c >>> 6 & 0x1F);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | c >>> 12 & 0xF);
            byArray[n++] = (byte)(0x80 | c >>> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | c & 0x3F);
        }
        return byArray;
    }

    public static String getString(byte[] byArray) throws UnsupportedEncodingException {
        return StringUtil.getStringRepresentation(byArray, byArray.length);
    }

    public static String getStringRepresentation(byte[] byArray, int n) throws UnsupportedEncodingException {
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = byArray[n3++] & 0xFF;
            try {
                cArray[n2++] = (char)(n4 < 192 ? n4 : (n4 < 224 ? (n4 & 0x1F) << 6 | byArray[n3++] & 0x3F : (n4 & 0xF) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UnsupportedEncodingException("Missing UTF-8 bytes after initial byte [0x" + Integer.toHexString(n4) + "] in string [" + new String(cArray, 0, n2) + "]");
            }
        }
        return new String(cArray, 0, n2);
    }

    public static String toHexString(byte[] byArray) {
        return StringUtil.toHexString(byArray, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(StringUtil.hexNibble(by >> 4)).append(StringUtil.hexNibble(by));
        }
        return stringBuffer.toString();
    }

    private static char hexNibble(int n) {
        return (char)((n &= 0xF) < 10 ? 48 + n : 97 + n - 10);
    }
}

